#!/bin/bash

# 该脚本中任何操作系统的操作命令，都不可以将命令执行结果输出，需使用“>/dev/null 2>&1”重定向
# 否则升级框架检查项会失败
G_SCRIPT_NAME=$(basename $0)

function ChangePermitAndFsyncCertFiles()
{
	local dir="$1"
	chown -h root:root $dir >/dev/null 2>&1
	chown -h root:root $dir/HM_DefaultCert.crt >/dev/null 2>&1
	chown -h root:root $dir/HM_DefaultCACert.crt >/dev/null 2>&1
	chown -h root:root $dir/HM_DefaultPriKey.key >/dev/null 2>&1
	chown -h root:root $dir/DM_DefaultCert.crt >/dev/null 2>&1
	chown -h root:root $dir/DM_DefaultPriKey.key >/dev/null 2>&1
	chown -h root:root $dir/FTPS_DefaultCert.crt >/dev/null 2>&1
	chown -h root:root $dir/FTPS_DefaultPriKey.key >/dev/null 2>&1
	chown -h root:root $dir/HTTPS_DefaultCert.crt >/dev/null 2>&1
	chown -h root:root $dir/HTTPS_DefaultPriKey.key >/dev/null 2>&1
	chown -h root:root $dir/HDA_DefaultCACert.crt >/dev/null 2>&1

	chmod 700 $dir >/dev/null 2>&1
	chmod 600 $dir/HM_DefaultCert.crt >/dev/null 2>&1
	chmod 600 $dir/HM_DefaultCACert.crt >/dev/null 2>&1
	chmod 600 $dir/HM_DefaultPriKey.key >/dev/null 2>&1
	chmod 600 $dir/DM_DefaultCert.crt >/dev/null 2>&1
	chmod 600 $dir/DM_DefaultPriKey.key >/dev/null 2>&1
	chmod 600 $dir/FTPS_DefaultCert.crt >/dev/null 2>&1
	chmod 600 $dir/FTPS_DefaultPriKey.key >/dev/null 2>&1
	chmod 600 $dir/HTTPS_DefaultCert.crt >/dev/null 2>&1
	chmod 600 $dir/HTTPS_DefaultPriKey.key >/dev/null 2>&1
	chmod 600 $dir/HDA_DefaultCACert.crt >/dev/null 2>&1

	fsync $dir/HM_DefaultCert.crt >/dev/null 2>&1
	fsync $dir/HM_DefaultCACert.crt >/dev/null 2>&1
	fsync $dir/HM_DefaultPriKey.key >/dev/null 2>&1
	fsync $dir/DM_DefaultCert.crt >/dev/null 2>&1
	fsync $dir/DM_DefaultPriKey.key >/dev/null 2>&1
	fsync $dir/FTPS_DefaultCert.crt >/dev/null 2>&1
	fsync $dir/FTPS_DefaultPriKey.key >/dev/null 2>&1
	fsync $dir/HTTPS_DefaultCert.crt >/dev/null 2>&1
	fsync $dir/HTTPS_DefaultPriKey.key >/dev/null 2>&1
	fsync $dir/HDA_DefaultCACert.crt >/dev/null 2>&1
}

function BackupDefaultCert()
{
	L_SA_DISK_EQUIP_CERT_PATH="/startup_disk/conf/conf_local/equip_cert"
	L_SA_CERT_PATH="$1"

	if [ ! -e $L_SA_DISK_EQUIP_CERT_PATH ];then
		OS_echo "[$G_SCRIPT_NAME] equip_cert is not exist."
		mkdir $L_SA_DISK_EQUIP_CERT_PATH >/dev/null 2>&1
	fi

	if [[ ! -e "$L_SA_DISK_EQUIP_CERT_PATH/HM_Equip_Cert.crt" || ! -e "$L_SA_DISK_EQUIP_CERT_PATH/HM_Equip_CACert.crt" || ! -e "$L_SA_DISK_EQUIP_CERT_PATH/HM_Equip_PriKey.key" ]]; then
		cp -f -P $L_SA_CERT_PATH/HM_DefaultCert.crt $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		cp -f -P $L_SA_CERT_PATH/HM_DefaultCACert.crt $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		cp -f -P $L_SA_CERT_PATH/HM_DefaultPriKey.key $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		ret=$?
		OS_echo "[$G_SCRIPT_NAME] Backup HM cert to startup_disk, ret $ret."
	fi
	
	if [[ ! -e "$L_SA_DISK_EQUIP_CERT_PATH/DM_Equip_Cert.crt" || ! -e "$L_SA_DISK_EQUIP_CERT_PATH/DM_Equip_PriKey.key" ]]; then
		cp -f -P $L_SA_CERT_PATH/DM_DefaultCert.crt $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		cp -f -P $L_SA_CERT_PATH/DM_DefaultPriKey.key $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		ret=$?
		OS_echo "[$G_SCRIPT_NAME] Backup DM cert to startup_disk, ret $ret."
	fi
	
	if [[ ! -e "$L_SA_DISK_EQUIP_CERT_PATH/FTPS_Equip_Cert.crt" || ! -e "$L_SA_DISK_EQUIP_CERT_PATH/FTPS_Equip_PriKey.key" ]]; then
		cp -f -P $L_SA_CERT_PATH/FTPS_DefaultCert.crt $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		cp -f -P $L_SA_CERT_PATH/FTPS_DefaultPriKey.key $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		ret=$?
		OS_echo "[$G_SCRIPT_NAME] Backup FTPS cert to startup_disk, ret $ret."
	fi
	
	if [[ ! -e "$L_SA_DISK_EQUIP_CERT_PATH/HTTPS_Equip_Cert.crt" || ! -e "$L_SA_DISK_EQUIP_CERT_PATH/HTTPS_Equip_PriKey.key" ]]; then
		cp -f -P $L_SA_CERT_PATH/HTTPS_DefaultCert.crt $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		cp -f -P $L_SA_CERT_PATH/HTTPS_DefaultPriKey.key $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		ret=$?
		OS_echo "[$G_SCRIPT_NAME] Backup HTTPS cert to startup_disk, ret $ret."
	fi
	
	if [[ ! -e "$L_SA_DISK_EQUIP_CERT_PATH/HDA_Equip_CACert.crt" ]]; then
		cp -f -P /OSM/conf/disk_auth/default_cert/HDA_DefaultCACert.crt $L_SA_DISK_EQUIP_CERT_PATH/ >/dev/null 2>&1
		ret=$?
		OS_echo "[$G_SCRIPT_NAME] Backup HDA cert to startup_disk, ret $ret."
	fi

	ChangePermitAndFsyncCertFiles $L_SA_DISK_EQUIP_CERT_PATH
}

BackupDefaultCert "/OSM/conf"
BackupDefaultCert "/OSM/conf/omm_cert/default_cert"

echo "True"
exit 0
