#!/bin/bash
# Copyright (c) Huawei Technologies Co., Ltd. 2020-2030. All rights reserved.
# 2023/9/11 16:56
# 613-615 补丁内存泄漏的检查

result="True"

function is_need_check_version()
{
    local current_version=$(head /OSM/conf/manifest.yml | grep -w Version | awk '{print $2}')
    local low_version="7600509200"
    local high_version="7600511219"
    local low_patch_ver="26"
    local high_patch_ver="12"
    if [ $current_version -gt $high_version ] && [ $current_version -lt $high_version ]; then
        OS_echo "$current_version not need check mem leak."
        return 0
    fi
    # 补丁版本
    local currentHotVer="0"
    if [ -f /startup_disk/image/$current_version/hotpatch/patch_cur/patch.yml ]; then
        currentHotVer=$(cat /startup_disk/image/$current_version/hotpatch/patch_cur/patch.yml | grep -w "patch_version" | awk '{print $2}' | tr -cd "[0-9]")
    fi
    if [ "$current_version" == "$low_version" ] && [ $currentHotVer -ge $low_patch_ver ]; then
        OS_echo "$current_version $currentHotVer not need check mem leak."
        return 0
    elif [ "$current_version" == "$high_version" ] && [ $currentHotVer -ge $high_patch_ver ]; then
        OS_echo "$current_version $currentHotVer not need check mem leak."
        return 0
    fi
    return 1
}

function check_is_need_restart()
{
    is_need_check_version
    if [ "$?" == "0" ];then
        OS_echo "current vesion not need check mem leak."
        return 0
    fi
    local block32num=$(diagsh --attach="app_data_12" --cmd="dpmm show slab -m 386" | grep -w "anonymous_32" | awk '{print $9}')
    if [ -z "$block32num" ]
        then
            OS_echo "query anonymous_32 failed, try again"
            sleep 3
            block32num=$(diagsh --attach="app_data_12" --cmd="dpmm show slab -m 386" | grep -w "anonymous_32" | awk '{print $9}')
            if [ -z "$block32num" ]
                then
                    OS_echo "after retry, still not get anonymous_32 cnt"
                    block32num=0
            else
                OS_echo "after retry, get needed value anonymous_32"
            fi
    fi
    local block3072num=$(diagsh --attach="app_data_12" --cmd="dpmm show slab -m 386" | grep -w "anonymous_3072" | awk '{print $9}')
    if [ -z "$block3072num" ]
        then
            OS_echo "query anonymous_3072 failed, try again"
            sleep 3
            block3072num=$(diagsh --attach="app_data_12" --cmd="dpmm show slab -m 386" | grep -w "anonymous_3072" | awk '{print $9}')
            if [ -z "$block3072num" ]
                then
                    OS_echo "after retry, still not get anonymous_3072 cnt"
                    block3072num=0
            else
                OS_echo "after retry, get needed value anonymous_3072"
            fi
    fi
    local leak_total=$((($block32num * 32) + ($block3072num * 3072)))
    local leak_total_boom=$(($leak_total * 10))
    OS_echo "block32num $block32num, block3072num $block3072num, leak_total $leak_total, leak_total_boom $leak_total_boom"
    local memflow_num=$(diagsh --attach="app_data_12" --cmd="dpumm_shm show meminfo all" | grep -w "0xb40004" | awk '{print $4}')
    if [ -z "$memflow_num" ]
        then
            OS_echo "query memflow_num failed, try again"
            sleep 3
            memflow_num=$(diagsh --attach="app_data_12" --cmd="dpumm_shm show meminfo all" | grep -w "0xb40004" | awk '{print $4}')
            if [ -z "$memflow_num" ]
                then
                    OS_echo "after retry, still not get memflow_num"
                    return 0
            else
                OS_echo "after retry, get needed value memflow_num"
            fi
    fi
    local memflow_size=$(($memflow_num * 8600))
    OS_echo "memflow_num $memflow_num, memflow_size $memflow_size"
    if [ $leak_total_boom -lt $memflow_size ]
        then
            return 0
    fi
    return 1
}

check_is_need_restart
if [ "$?" == "1" ];then
    OS_echo "mem leak too much, need restart."
    result="False"
fi
echo $result
exit 0
