#!/bin/bash
# 检查当前环境中是smb3开关是否开启, 用于升级前提前拦截错误并完成整改;
# 避免升级过程中业务中断的风险.
# 先检查是否支持NAS, 如果不支持, 不需要检查, 默认返回True.

function smb3_enable_check()
{
    : ${TMPDIR:=/tmp}
    local temp_dir=""
    local save_mask=$(umask)
    umask 077
    temp_dir=$(mktemp -d "${TMPDIR}/XXXXXXXXXXXXXXXXXX") 
    if [ $? -ne 0 ]
    then
        umask "${save_mask}"
        return 1
    fi
    umask "${save_mask}"
    
    IsSupportNas=$(cat /OSM/conf/app_data/spec/product.ini | grep IsSupportNas |awk -F"=" '{print $NF}'|tr '\r' '\n')
    if [ x"${IsSupportNas}" == x"0" ] || [ x"${IsSupportNas}" == x ]
    then
        result="True"
    else
        local result_file="/tempfile.$$"
        local result_file_path="$temp_dir$result_file"
        local cache_cmds_output="nas_proto_pum -m smb2 -c getSmb3EnableBeforeUpgrade"
        diagsh --attach="app_data_12" --cmd="${cache_cmds_output}" --showtime > "$result_file_path"
        result=$(awk '/getSmb3EnableBeforeUpgrade/{getline a;print a}' $result_file_path)
        if [ x"${result}" == x ]; then
          result="True"
        fi  
    fi
    
    echo $result
    
    rm -f $result_file_path
    trap '[ -n "${temp_dir}" ] && rm -rf "${temp_dir}"' EXIT
}

smb3_enable_check