#!/bin/bash
# ********************************************** ***************************** #
# File Name: check_fdsa_tunefs.sh
# Description: fdsa系统盘检测
# Input: none        
# Output: none
# Created: 2024-09-06
# Function List：
# History
# **************************************************************************** #

source /OSM/script/os_load_base.sh

PATH_SYSDISK_CHECK=/OSM/fdsa/plugins/common/fdsa_check_sysdisk.sh
EXTEND_INI=/startup_disk/conf/conf_local/extend.ini
SYSDISK_SWITCH=/OSM/coffer_log/log/heal/data/fdsa_sysdisk_switch
ITEM_OLDMODE=FdsaSysDiskOldMode
SECTION_NAME=GLOBAL

manifest_file_path=/startup_disk/image/pkg_cur/manifest.yml
path_file_path=/OSM/conf/patch.yml
fdsa_diagnose_path=/OSM/script/fdsa_diagnose_op.sh

PATCH_VERSION="SPH0" # 默认为基线版本

if [ ! -f $manifest_file_path ]; then	# manifest文件不存在
    OS_echo "The manifest.yml path or file does not exist"
    echo "True"
    exit 0
fi
MainVer=`cat ${manifest_file_path}  | grep -w SpcVersion | awk '{print $(NF)}'`

if [ -f $path_file_path ]; then
    try_get_patchver=`cat ${path_file_path} | grep patch_version | head -1 | awk '{print $(NF)}'`
    if [ -z $try_get_patchver ]; then
        OS_echo "Cannot get patch version, check environment pls."
        echo "True"
        exit 0
    fi
    PATCH_VERSION=$try_get_patchver
fi

productRet=$( (diagsh --attach="app_data_12" --cmd="db show product type")) 2>/dev/null
case $productRet in
    *"Ocean protect."*)
        PRODUCT_TYPE="ocean_protect"
        ;;
    *"Ocean disk."*)
        PRODUCT_TYPE="ocean_disk"
        ;;
    *"Ocean micro."*)
        PRODUCT_TYPE="ocean_disk"
        ;;
    *)
        PRODUCT_TYPE=""
esac

version_arr=("6.1.2" "6.1.3" "6.1.5" "6.1.6" "6.1.7" "6.1.8" "V500R007C71SPC100" "V500R007C73SPC100")
problem_patch_arr=("SPH60" "SPH30" "SPH30" "SPH0" "SPH0" "SPH0" "SPH150" "SPH120")
fix_problem_patch_arr=("SPH67" "SPH33" "SPH38" "SPH20" "SPH8" "SPH2" "SPH9999" "SPH9999")

ocean_protect_arr=("1.2.0" "1.3.0" "1.5.0" "1.6.0")
ocean_protect_problem_patch_arr=("SPH30" "SPH0" "SPH0" "SPH0")
ocean_protect_fix_problem_patch_arr=("SPH38" "SPH20" "SPH8" "SPH2")

ocean_disk_arr=("1.1.0" "1.2.0" "1.3.0")
ocean_disk_problem_patch_arr=("SPH0" "SPH0" "SPH0")
ocean_disk_fix_problem_patch_arr=("SPH20" "SPH8" "SPH2")

arr_length=${#version_arr[@]}
ocean_proect_arr_length=${#ocean_protect_arr[@]}
ocean_disk_arr_length=${#ocean_disk_arr[@]}
i=0
j=0
k=0
IS_VERSION_WITH_PROBLEM()
{
    while [ $i -lt $arr_length ]
    do
        if [ "$MainVer" == ${version_arr[$i]} ]; then
            if [ `expr substr $PATCH_VERSION 4 4 \>= substr ${problem_patch_arr[$i]} 4 4` -eq 1 ] && [ `expr substr $PATCH_VERSION 4 4 \< substr ${fix_problem_patch_arr[$i]} 4 4` -eq 1 ] ;then
                return 1
            fi
        fi
        let i++
    done

    while [ $j -lt $ocean_proect_arr_length ]
    do
        if [ "${PRODUCT_TYPE}" == "ocean_protect" ] && [ "$MainVer" == ${ocean_protect_arr[$j]} ]; then
            if [ `expr substr $PATCH_VERSION 4 4 \>= substr ${ocean_protect_problem_patch_arr[$j]} 4 4` -eq 1 ] && [ `expr substr $PATCH_VERSION 4 4 \< substr ${ocean_protect_fix_problem_patch_arr[$j]} 4 4` -eq 1 ] ;then
                return 1
            fi
        fi
        let j++
    done

    while [ $k -lt $ocean_disk_arr_length ]
    do
        if [ "${PRODUCT_TYPE}" == "ocean_disk" ] && [ "$MainVer" == ${ocean_disk_arr[$k]} ]; then
            if [ `expr substr $PATCH_VERSION 4 4 \>= substr ${ocean_disk_problem_patch_arr[$k]} 4 4` -eq 1 ] && [ `expr substr $PATCH_VERSION 4 4 \< substr ${ocean_disk_fix_problem_patch_arr[$k]} 4 4` -eq 1 ] ;then
                return 1
            fi
        fi
        let k++
    done

    return 0
}

CHECK_AND_SET_SYSDISK_MODE_FOR_C71()
{
    if [ -f ${SYSDISK_SWITCH} ]; then
        OS_echo "${SYSDISK_SWITCH} exists, no need to set fdsa sysdisk."
        return 0
    fi
    echo -e "econf renewcfg  ${SECTION_NAME} ${ITEM_OLDMODE} 0 \nexit\n" | diagnose --auto 2>/dev/null 1>/dev/null
    set_fdsa_sysdisk_switch.sh on 2>/dev/null 1>/dev/null
    return 0
}

CHECK_AND_SET_SYSDISK_MODE_FOR_REST()
{
    local tmp_result=`echo y | fdsa_diagnose_op.sh fdsa sysdiskmode show | grep "sysdisk mode is" | grep -o '[0-9]\+'`
    if [ ${tmp_result} == 3 ]; then
        OS_echo "sysdisk mode is 3, no need to set fdsa sysdisk mode."
        return 0
    fi
    diagsh --attach="app_data_diagnose_666" --cmd="econf renewcfg ${SECTION_NAME} ${ITEM_OLDMODE} ${tmp_result}" 2>/dev/null 1>/dev/null
    echo y | fdsa_diagnose_op.sh fdsa sysdiskmode set 3 2>/dev/null 1>/dev/null
    return 0
}

#--------------------------------- main ----------------------
IS_VERSION_WITH_PROBLEM
if [ "$?" == 0 ] ;then
    echo "True"
    exit 0
fi

if [ ! -f $fdsa_diagnose_path ]; then
    OS_echo "The fdsa_diagnose_op.sh file does not exist"
    echo "True"
    exit 0
fi

if [ "$MainVer" == "V500R007C71SPC100" ]; then
    CHECK_AND_SET_SYSDISK_MODE_FOR_C71
else
    CHECK_AND_SET_SYSDISK_MODE_FOR_REST
fi

echo "True"
exit 0