#!/bin/bash

# 50M=51200KB
VALUE_THRESHOLD=51200
CMPT_NAME="fdsamonitor"

# **************************************************************************** #
# Function Name: cg_to_kb
# Description: 转换以KB为单位的内存值
# Parameter: 内存值字符串
# **************************************************************************** #
cg_to_kb()
{
    str=$1
    strG="[Gg]"
    strM="[Mm]"
    strKB="[kK]B"
    resultKB=0

    if [[ ${str} == *${strG}* ]];then
        sizeG=`echo ${str} | awk -F ${strG} '{print $1}'`
        resultKB=`awk -v x=${sizeG} 'BEGIN{printf "%d\n",x * 1024 * 1024}'`
        str=`echo ${str} | awk -F ${strG} '{print $2}'`
    fi

    if [[ ${str} == *${strM}* ]];then
        sizeM=`echo ${str} | awk -F ${strM} '{print $1}'`
        resultKB=`awk -v x=${sizeM} -v y=${resultKB} 'BEGIN{printf "%d\n",x * 1024 + y}'`
        str=`echo ${str} | awk -F ${strM} '{print $2}'`
    fi

    if [[ ${str} == *${strKB}* ]];then
        sizeKB=`echo ${str} | awk -F ${strKB} '{print $1}'`
        resultKB=`awk -v x=${sizeKB} -v y=${resultKB} 'BEGIN{printf "%d\n",x + y}'`
    fi
	echo ${resultKB}
}

# **************************************************************************** #
# Function Name: check_mem
# Description: 检查fdsamonitor内存是否正常
# Parameter: fdsamonitor内存值
# **************************************************************************** #
check_mem()
{
    fdsamon_pid=$(ps -ef | grep "${CMPT_NAME}" | grep -v grep | head -n 1 | awk '{print $2}')
    OS_echo "check_fdsamon_mem.sh fdsamon_pid=${fdsamon_pid}"
    mem_fdsamon=$(cat /proc/${fdsamon_pid}/status 2>/dev/null | grep VmRSS | awk -F ' ' '{print $(NF-1)$(NF-0)}')
    OS_echo "check_fdsamon_mem.sh mem_fdsamon_before=${mem_fdsamon}"
    mem_fdsamon=`cg_to_kb ${mem_fdsamon}`
    OS_echo "check_fdsamon_mem.sh mem_fdsamon_after=${mem_fdsamon}"
    if [ ${mem_fdsamon} -ge ${VALUE_THRESHOLD} ]; then
        OS_echo "check_fdsamon_mem.sh ${CMPT_NAME} restart mem_fdsamon:${mem_fdsamon},threshold:${VALUE_THRESHOLD}"
        # 杀进程
        setsid /OSM/fdsa/bin/stop_fdsa.sh ${CMPT_NAME} >/dev/null 2>&1
        # 拉进程
        setsid /OSM/fdsa/bin/start_fdsa.sh ${CMPT_NAME} >/dev/null 2>&1
        sleep 5s
        L_NEW_PID=`pidof ${CMPT_NAME}`
        OS_echo "${CMPT_NAME}: newPid $L_NEW_PID"
        if [ "${L_NEW_PID}" = "" ]; then
            OS_echo "check_fdsamon_mem.sh ${CMPT_NAME} first start fail, now restart again."
            # 重拉进程
            setsid /OSM/fdsa/bin/start_fdsa.sh ${CMPT_NAME} >/dev/null 2>&1
        fi
    fi
}

check_mem

echo "True"
exit 0