#!/bin/bash
#包含头脚本
source /OSM/script/os_load_base.sh

if [ -f /usr/bin/root_proxy ]; then
  ROOT_PROXY="/usr/bin/root_proxy --proxy-ignore-insecure 1 --proxy-shname $0 --proxy-lineno $LINENO"
fi

UPGRADE_SH=check_frame.sh
G_DISK_UTIL=/tmp/diskusagenew
SWM_LIB_DIR=/OSM/component/swm/lib/
CHECK_ITEM_DIR=/OSM/coffer_bin/upg_check/check_item/
IMAGE_DISK=/startup_disk/image
START_IMAGE_DIR=$IMAGE_DISK/pkg_cur/packages/
CUR_MODEL=$(cat /proc/osp/bsp | ${ROOT_PROXY} awk '/Product Name is/ {print $4}' | tr 'a-z' 'A-Z')
DEV_INFO=`uname -r | ${ROOT_PROXY} awk -F '.' '{print $NF}'`
CUR_VERSION=$(cat /OSM/conf/manifest.yml |grep " Version:" | ${ROOT_PROXY} awk '/Version:/ {print $2}')
REFACTOR_VERSION=7600505080
DORADO_601GA_VERSION=7600302133

OS_ExecDiagnose()
{
    local L_PID=$1
    local L_CMD=$2
    
    diagsh --attach="$L_PID" --cmd="$L_CMD"
    
    return 0
}

GetCPUUsage_QOS()
{
    local L_CMD="qos show cur_cpu_load"
    OS_ExecDiagnose "*_12" "$L_CMD"
}
# **************************************************************************** #
# Function Name:
# Description:
# Parameter:
# Return:
# **************************************************************************** #
OS_DROP_MEMORY()
{
    ${ROOT_PROXY} rm -rf /usr/share/X11
    ${ROOT_PROXY} rm -rf /usr/share/vim
    # 'vos.ko', 'os_clear_nvram.ko', 'osp_bsp_reboot.ko' 和 loop.ko 不能删除
    find /usr/lib/modules/*euleros*aarch64 ! -regex ".*vos.*ko$\|.*loop\.ko$" -name "*.ko" | xargs -l ${ROOT_PROXY} rm -f
    osm_modules_white=(updatebios.ko updateiob.ko sfc.ko os_test.ko iocount.ko drv_iosubsys_nvme.ko libata.ko sata_mml.ko satahp.ko mic.ko read_cpuversion.ko)
    osm_modules_files=$(find /OSM/modules -type f)
    for file in ${osm_modules_files}
    do
        # /OSM/modules/backup_ko目录下的空也不能删除，用于ko hot replace
        if [[ ! ${osm_modules_white[*]} =~ ${file##*/} ]] && [[ ! ${file} =~ ^.*backup_ko/.*ko$ ]]
        then
            ${ROOT_PROXY} rm -f ${file}
        fi
    done
}

OS_CLEAR_PANGEA_KO()
{
    # 仅删除ip框的ko，非ip框不管，函数退出
    if [ ! -f /startup_disk/conf/conf_local/data_node ]
    then
        return 0
    fi
    osm_modules_files=$(find /OSM/modules -type f && find /OSM/modules -type l)
    osm_modules_blacklist=(nvme_sysdisk.ko bsp.ko drvframe.ko drv_iosubsys_ini.ko osp_proc.ko libahci.ko lbc.ko pcie_base.ko pcie_cae.ko pcie_rc.ko ahci.ko)
    for file in ${osm_modules_files}
    do
        # /OSM/modules/backup_ko目录下的ko不能删除，用于ko hot replace
        if [[ ${osm_modules_blacklist[*]} =~ ${file##*/} ]] && [[ ! ${file} =~ ^.*backup_ko/.*ko$ ]]
        then
            OS_echo "deleting file below:"
            OS_echo ${file}
            ${ROOT_PROXY} rm -f ${file}
        fi
    done
}

# **************************************************************************** #
# Function Name:
# Description:
# Parameter:
# Return:
# **************************************************************************** #
OS_CHECK_FREE_MEM_ENOUGH()
{    
    OS_echo "[$UPGRADE_SH]: begin to check the free mem when upgrade check."
    echo 3 >/proc/sys/vm/drop_caches &
    sleep 3
    OS_echo "current free memory is $FREE_MEM"
    OS_CLEAR_PANGEA_KO
    tmp=`ls ${START_IMAGE_DIR} | grep debug`
    if [ -z "$tmp" ]; then
        #check memory is enough
        FREE_MEM=`free -m|grep ^Mem|${ROOT_PROXY} awk '{print $4}'`
        echo "$FREE_MEM"
        return 0
    else
        if [ -f /startup_disk/conf/conf_local/data_node ]; then
            OS_DROP_MEMORY
            OS_echo "current free memory is $FREE_MEM"
        fi
        # dubug类型，强制返回2000M
        echo "2000"
       return 0
    fi


}
# **************************************************************************** #
# Function Name:
# Description:
# Parameter:
# Return:
# **************************************************************************** #
OS_CHECK_CPU_USAGE()
{    
    OS_echo "[$UPGRADE_SH]: begin to check the cpu usage."
	
    if [ -f /OSM/conf/cpu_check_hook ]; then
        OS_echo "${UPGRADE_SH} : no_cpu_check flag exist, do not check cpu usage.">/dev/null
        echo "$(cat /OSM/conf/cpu_check_hook)"
        echo ""
        echo ""
        return 0
        
    fi
   
    #调用QOS的diagnose命令检查CPU利用率
    [ -f $G_CPU_USAGE ] && ${ROOT_PROXY} rm $G_CPU_USAGE
    local var=0
    for((i=0;i<10;i++))
    do
        OS_ExecDiagnose "*_12" "qos show cur_cpu_load" > $G_CPU_USAGE
        tmpvar=`cat $G_CPU_USAGE |grep "CPU load average" |${ROOT_PROXY} awk '{print $4}'`
        var=$(expr $var + $tmpvar) 
        sleep 1
    done
    L_CUR_CPU_USING=$(expr $var / 10 )

	OS_echo "[$UPGRADE_SH]: the cpu usage is $L_CUR_CPU_USING."
    echo "$L_CUR_CPU_USING"
    echo ""
    echo ""
    return 0
}

# **************************************************************************** #
# Function Name: OS_CHECK_FW_INDEPENDENT
# Description: check if has firmware upgrade in backgrand
# Parameter:
# Return:
# **************************************************************************** #
OS_CHECK_FW_INDEPENDENT()
{
    OS_echo "[$UPGRADE_SH]: begin to check fw independent upg, cur_version: ${CUR_VERSION}, refactor_ver: ${REFACTOR_VERSION}."
    local result=''
    if [ ${CUR_VERSION} -le ${REFACTOR_VERSION} ]; then
        result=`swm_diagnose -c "upg fw -1" | grep -E 'param input error.|Do not support x86 or simu.'`
        if [[ -z  ${result} ]]; then
            echo "False"
            return 0
        fi
    else
        result=`swm_diagnose -c "fw show_request_status" | ${ROOT_PROXY} sed -n '3p' | ${ROOT_PROXY} awk '{print $1}'`
        if [[ -n  ${result} ]]; then
            echo "False"
            return 0
        fi
    fi
    echo "True"
    return 0
}

# **************************************************************************** #
# Function Name: OS_CheckDiskUsage
# Description: check if the disk usage is more than threshold
# Parameter:
# Return:
# **************************************************************************** #
GetDiskUsage()
{
    L_CMD="sddebug userate 60"
    OS_ExecDiagnose "*_12" "$L_CMD"
}

OS_CheckDiskUsage()
{
    local -i L_OneDiskUsage=0
    local -i L_DiskUtilUsageResult=0
    local -i L_DiskCount=0
    local -i L_DiskAverage=0
    local -i L_DiskSum=0
    local -i L_DiskUsageIgnore=10
    
    [ -f $G_DISK_UTIL ] && ${ROOT_PROXY} rm $G_DISK_UTIL
    GetDiskUsage > $G_DISK_UTIL
    while read sdid util type; 
    do
        if [ -n "$(echo $sdid | grep '[a-zA-Z]')" -o -z "$sdid" ]; then
            OS_echo "${UPGRADE_SH}: sdid=$sdid"
            continue;
        fi
        L_OneDiskUsage=$util
        OS_echo "${UPGRADE_SH}: sdid=$sdid  util=${L_OneDiskUsage}"
        #将利用率小于等于10的盘排除开，不计算平均值和最大值，可以避免长期利用率为零或者很低的盘对平均值计算的影响
        if [ ${L_DiskUsageIgnore} -gt ${L_OneDiskUsage} ]; then
            OS_echo "${UPGRADE_SH}: sdid=$sdid diskusage less than 10, continue"
            continue;
        fi
        [ ${L_OneDiskUsage} -gt ${L_DiskUtilUsageResult} ] && L_DiskUtilUsageResult=${L_OneDiskUsage}
        L_DiskCount=$(( L_DiskCount + 1 ))
        L_DiskSum=$((L_DiskSum + L_OneDiskUsage ))
    done < $G_DISK_UTIL &>/dev/null
    
    #获取到的磁盘数不为0的时候，计算磁盘平均利用率
    if [ 0 -ne $L_DiskCount ]; then
        L_DiskAverage=$(( L_DiskSum / L_DiskCount ))
    fi
    if [ ${L_DiskUtilUsageResult} -gt 80 -o ${L_DiskAverage} -gt 60 ]; then
        echo "False"
    else
        echo "True"
    fi

    return 0
}
# **************************************************************************** #
# Function Name: CHECK_BEFORE_INSTALL_HOTPATCH
# Description: 热补丁升级前检查
# Parameter:
# Return:
# **************************************************************************** #
CHECK_BEFORE_INSTALL_HOTPATCH()
{
    OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH">/dev/null
    
    local L_UPG_HOTPATCH_PATH_NAME=$1
    /OSM/script/os_upgrade_hotpatch.sh -g $L_UPG_HOTPATCH_PATH_NAME &>/dev/null
    L_IsSpecPatch=$? 
    
    #判断是否是特殊补丁
    if [ 10 -eq ${L_IsSpecPatch} ];then
        #特殊补丁不需要升级前的检查
        echo "True"
        echo "pass"
        return 0
    fi
    
    #热补丁升级前的检查
    /OSM/script/os_upgrade_hotpatch.sh -w install $L_UPG_HOTPATCH_PATH_NAME &>/dev/null
    L_RET=$? 
    
    if [ 0 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 0">/dev/null
        echo "True"
        echo "pass"
        return 0
    fi
    
    if [ 1 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 1">/dev/null
        echo "False"  
        echo "pkgerror"
        return 0
    fi
    
    if [ 2 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 2">/dev/null
        echo "False"  
        echo "versionerror"
        return 0
    fi
    
    if [ 3 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 3">/dev/null
        echo "False"  
        echo "reinstall"
        return 0
    fi
    
    if [ 4 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 4">/dev/null
        echo "False"  
        echo "memoryerror"
        return 0
    fi
    
    if [ 5 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 5">/dev/null
        echo "False"  
        echo "sysdiskerror"
        return 0
    fi
    
    if [ 6 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 6">/dev/null
        echo "False"  
        echo "sysbusy"
        return 0
    fi
    
    if [ 8 -eq ${L_RET} ];then
        OS_echo "[$UPGRADE_SH]: upgrade- CHECK_BEFORE_INSTALL_HOTPATCH = 8">/dev/null
        echo "False"  
        echo "hotpatcherror"
        return 0
    fi
       
    echo "False"  
    echo "failed"  
    return 0
   
}

OS_CheckFirmware()
{
    if [ ${DEV_INFO} == 'x86_64' ]; then
        echo "True"
        return 0
    fi
    local cmd_name="msc upgradeprecheck"
    local origin_result=`OS_ExecDiagnose "*_21" "${cmd_name}"`
    local check_pass=${cmd_name}' True'
    local check_result=`echo ${origin_result}`
    if [[ ${check_result} == *${check_pass}* ]]; then
        echo "True"
    else
        echo "False"
    fi
    return 0
}

OS_CheckFastUpgrade()
{
    if [ ${DEV_INFO} == 'aarch64' ]; then
        rmmod -f updatebios.ko &>/dev/null
    fi
    # upgcheck check_bg_task_status 命令601版本才新增的
    if [[ ${CUR_VERSION} -ge ${DORADO_601GA_VERSION} ]]; then
        # 检查是否存在后台任务，避免此时下发固件任务，会导致后台任务配套表被修改
        local result
        result=$(swm_diagnose -c "upgcheck check_bg_task_status")
        if [[ "${result}" == *"False"* ]]; then
            OS_echo "[$0]: Exists fw background task running."
            echo "False"
            return 0
        fi
    fi
    local fast_check_file=''
    if [ ${CUR_VERSION} -le ${REFACTOR_VERSION} ]; then
        fast_check_cmd='fast_upgrade_check.py'
    else
        fast_check_cmd='fast_upgrade_check_new.py'
    fi

    LD_LIBRARY_PATH=${SWM_LIB_DIR} BOARD_TYPE=${CUR_MODEL} ${CHECK_ITEM_DIR}/${fast_check_cmd} -c &>/dev/null

    ret=$?
    if [ $ret -eq 0 ]; then
        echo "True"
        return 0
    fi
    echo "False"
    return 0
}

OS_HandleApolloBeforeUpgrade()
{
    local fast_check_cmd='fast_upgrade_check_new.py'

    LD_LIBRARY_PATH=${SWM_LIB_DIR} BOARD_TYPE=${CUR_MODEL} ${CHECK_ITEM_DIR}/${fast_check_cmd} -H &>/dev/null
    ret=$?
    if [ $ret -eq 0 ]; then
        echo "True"
        return 0
    fi
    echo "False"
    return 0
}

OS_CheckSmartIoVersion()
{
    if [ ${DEV_INFO} == 'x86_64' ]; then
        echo "True"
        return 0
    fi
    local origin_result=''
    if [ ${CUR_VERSION} -le ${REFACTOR_VERSION} ]; then
        if [[ ${CUR_VERSION} -ge ${DORADO_601GA_VERSION} ]]; then
            if [ ${CUR_MODEL} == 'PANGEA_V6R1C00_HI1620_4U4C' -o ${CUR_MODEL} == 'PANGEA_V6R3C10_HI1620_4U4C' ]; then
                # 检查1822的版本是否强匹配
                origin_result=`swm_diagnose -c "fw check 2"`
            else
                origin_result=`swm_diagnose -c "fw check 1"`
            fi
        else
            if [ ${CUR_MODEL} == 'PANGEA_V6R1C00_HI1620_4U4C' -o ${CUR_MODEL} == 'PANGEA_V6R3C10_HI1620_4U4C' ]; then
                # 检查1822的版本是否强匹配
                origin_result=`swm_diagnose -c "fw check 2 0"`
            else
                origin_result=`swm_diagnose -c "fw check 1 0"`
            fi
        fi
        ver_same_str='the version is same'
        if [[ "${origin_result}" == *"${ver_same_str}"* ]]; then
            echo "True"
        else
            echo "False"
        fi
    else
        result=`swm_diagnose -c "fw check_local 6" | grep "False"`
        if [[ -n  ${result} ]]; then
            echo "False"
        else
            echo "True"
        fi
    fi
    return 0

}

OS_CheckSupportHotUpg()
{
    
    local check_file='roll_upgrade_preck.py'
    LD_LIBRARY_PATH=${SWM_LIB_DIR} BOARD_TYPE=${CUR_MODEL} python ${CHECK_ITEM_DIR}/${check_file} -f
    return 0
}

OS_CheckNeedSwitchApollo()
{
    if [ ${DEV_INFO} == 'x86_64' ]; then
        echo "False"
        return 0
    fi
    local fast_check_file=''
    if [ ${CUR_VERSION} -le ${REFACTOR_VERSION} ]; then
        fast_check_file='fast_upgrade_check.py'
    else
        fast_check_file='fast_upgrade_check_new.py'
    fi

    LD_LIBRARY_PATH=${SWM_LIB_DIR} BOARD_TYPE=${CUR_MODEL} ${CHECK_ITEM_DIR}/${fast_check_file} -a &>/dev/null
    ret=$?
    if [ $ret -eq 0 ]; then
        echo "True"
        return 0
    fi
    echo "False"
    return 0
}

OS_CheckPartitionSpace()
{
    if [ ${DEV_INFO} == 'x86_64' ]; then
        echo "True"
        echo ""
        echo ""
        return 0
    fi
    image_partition=`df -m /startup_disk/image 2>/dev/null | grep "startup_disk/image" | ${ROOT_PROXY} awk '{print $5}' | ${ROOT_PROXY} awk -F '%' '{print $1}'`
    coffer_partition=`df -m /OSM/coffer_data 2>/dev/null | grep "OSM/coffer_data" | ${ROOT_PROXY} awk '{print $4}'`
    ls /startup_disk/image/pkg_cur/packages 2>/dev/null | grep -iE "debug|release_crack" >/dev/null 2>&1
    if [[ "$?" -ne "0" ]];then
        space_threshold=`expr 4 \* 1024`
    else
        if [[ -f /startup_disk/conf/conf_local/data_node ]];then
            space_threshold=`expr 4 \* 1024`
        else
            space_threshold=`expr 5 \* 1024`
        fi
    fi

    sys_path="/OSM/coffer_data/update/SYS_software.tgz"
    sys_upload_path="/OSM/coffer_data/upload/SYS_software.tgz"
    sys_size=0
    if [[ -f ${sys_path} ]]; then
        sys_software=`ls -l ${sys_path} | ${ROOT_PROXY} awk '{print $5}'`
        sys_size=`expr ${sys_software} \/ 1024 \/ 1024`
    fi
    if [[ -f ${sys_upload_path} ]]; then
        sys_upload_software=`ls -l ${sys_upload_path} | ${ROOT_PROXY} awk '{print $5}'`
        sys_size=`expr ${sys_upload_software} \/ 1024 \/ 1024 + ${sys_size}`
    fi
    coffer_partition=`expr ${coffer_partition} + ${sys_size}`

    local cur_version=`readlink /startup_disk/image/pkg_cur | ${ROOT_PROXY} awk -F '/' '{print $1}'`
    local versions=`ls /startup_disk/image/ | grep -E "^[0-9]{10}$" | grep -v ${cur_version}`
    local image_other_size=0
    for ver in ${versions}
    do
        image_other_size=$(( $image_other_size + `du -m -s /startup_disk/image/${ver} | ${ROOT_PROXY} awk '{print $1}'` ))
    done
    local total_image_size=`df -m /startup_disk/image 2>/dev/null | grep "startup_disk/image" | ${ROOT_PROXY} awk '{print $2}'`
    image_partition=`expr ${image_partition} - ${image_other_size} \* 100 / ${total_image_size}`

    # image分区的阈值改为55%，因为ext4文件系统会默认保留5%的空间作为预留空间，因此阈值上调至55，抵消该特性带来的影响
    if [ ${image_partition} -gt 55 -o ${coffer_partition} -lt ${space_threshold} ];then
        OS_echo "[$UPGRADE_SH]: image partition used ${image_partition}%, coffer_data available space is ${coffer_partition}">/dev/null
        echo "False"
        echo "10007"
        echo "${image_partition}%;55%;${coffer_partition}M;${space_threshold}M"
        return 0
    fi
    echo "True"
    echo ""
    echo ""
    return 0
}

mount_with_retry()
{
    #修改启动分区读写权限
    local disk_property=$1
    for((i=0;i<10;i++))
    do
        ${ROOT_PROXY} mount -o $disk_property,remount $IMAGE_DISK 1>/dev/null 2>/dev/kmsg
        mount_ret=$?
        if [ $? -eq 0 ];then
            break
        fi
        OS_echo "[$UPGRADE_SH]:mount ${IMAGE_DISK} for $disk_property fail times=${i}."
        sleep 1
    done
    if [ ${mount_ret} -ne 0 ];then
        OS_echo "[$UPGRADE_SH]:mount ${IMAGE_DISK} for $disk_property fail."
        return 1
    fi
    return 0
}

function check_pkg_upd()
{
  if [ -f /OSM/coffer_data/swm/upgrade_flag ]; then
      OS_echo "[$UPGRADE_SH]: upgrade_flag exist, not check pkg_upd."
      return 1
  fi
  if [ -d /startup_disk/image/pkg_upd/packages ]; then
      OS_echo "[$UPGRADE_SH]: exist pkg_upd."
      return 1
  fi
  OS_echo "[$UPGRADE_SH]: pkg_upd is not exist."
  return 0
}

function os_check_pkg_upd() {
    check_pkg_upd
    if [ $? -eq 0 ]; then
        echo "True"
        return 0
    fi
    echo "False"
    return 0
}

function delete_pkg_upd()
{
    if [ -f /OSM/coffer_data/swm/upgrade_flag ]; then
        OS_echo "[$UPGRADE_SH]: upgrade_flag exist, not delete pkg_upd."
        return 1
    fi
    mount_with_retry rw
    if [ $? != 0 ]; then
        mount_with_retry ro
        return 1
    fi
    ${ROOT_PROXY} rm -rf /startup_disk/image/pkg_upd/packages/*
    if [ $? != 0 ]; then
        mount_with_retry ro
        return 1
    fi
    mount_with_retry ro
    return 0
}

function os_check_and_delete_pkg_upd() {
  check_pkg_upd
  if [ $? -ne 0 ]; then
      delete_pkg_upd
      if [ $? -ne 0 ]; then
          echo "False"
          return 0
      fi
  fi
  echo "True"
  return 0
}
# --------------------------  main  ------------------------------------------ #

#为了调用OS_SET_DISK_RW

L_INPUT_PARA_NUM=$#

if [ $L_INPUT_PARA_NUM -lt 1 ] ; then
    OS_echo "${UPGRADE_SH}: [check_frame.sh]wrong input num: $#." >/dev/null
else
    L_TMP=`echo $1 | grep '\-[a-zA-Z0-9]'`
    if [ -z "$L_TMP" ] ; then
        OS_echo "${UPGRADE_SH}: [check_frame.sh]wrong input para $1." >/dev/null
    fi
fi

while getopts bcmdgfFijkHlo options 2>/dev/null
do
    case $options in
        b)  OS_echo "${UPGRADE_SH} [-b]: Upgrade check fw independent upg" >/dev/null
            OS_CHECK_FW_INDEPENDENT
            exit $?
            ;;
        c)  OS_echo "${UPGRADE_SH} [-c]: Upgrade get cpu usage" >/dev/null
            OS_CHECK_CPU_USAGE
            exit $?
            ;;
        m)  OS_echo "${UPGRADE_SH} [-m]: Upgrade get free mem" >/dev/null
            OS_CHECK_FREE_MEM_ENOUGH
            exit $?
            ;;
        d)  OS_echo "${UPGRADE_SH} [-d]: Upgrade check disk usage" >/dev/null
            OS_CheckDiskUsage
            exit $?
            ;;
        g)  OS_echo "${UPGRADE_SH} [-g]: Upgrade check firmware" >/dev/null
            OS_CheckFirmware $OPTARG
            exit $?
            ;;
        f)  OS_echo "${UPGRADE_SH} [-f]: Upgrade check fast upgrade" >/dev/null
            OS_CheckFastUpgrade $OPTARG
            exit $?
            ;;
        F)  OS_echo "${UPGRADE_SH} [-F]: Upgrade check smartio version." >/dev/null
            OS_CheckSmartIoVersion $OPTARG
            exit $?
            ;;
        H)  OS_echo "${UPGRADE_SH} [-h]: Handle apollo before upgrade." >/dev/null
            OS_HandleApolloBeforeUpgrade $OPTARG
            exit $?
            ;;
        i)  OS_echo "${UPGRADE_SH} [-i]: Check if need to perform Apollo switch" >/dev/null
            OS_CheckNeedSwitchApollo $OPTARG
            exit $?
            ;;
        j)  OS_echo "${UPGRADE_SH} [-j]: Check if high-end device support hot upgrade." >/dev/null
            OS_CheckSupportHotUpg $OPTARG
            exit $?
            ;;
        k)  OS_echo "${UPGRADE_SH} [-k]: Check whether the available space of the system disk image and data partition is sufficient." >/dev/null
            OS_CheckPartitionSpace
            exit $?
            ;;
        l) OS_echo "${UPGRADE_SH} [-l]: Check whether pkg_upd dir exist." >/dev/null
            os_check_pkg_upd
            exit $?
            ;;
        o) OS_echo "${UPGRADE_SH} [-o]: Check pkg_upd dir exist and delete pkg_upd dir." >/dev/null
            os_check_and_delete_pkg_upd
            exit $?
            ;;
        *) OS_echo "${UPGRADE_SH}: invalid options" >/dev/null
            exit 1
            ;;
    esac
done

exit 1

