#!/bin/bash
#包含头脚本
source /OSM/script/os_load_base.sh

if [ -f /usr/bin/root_proxy ]; then
  ROOT_PROXY="/usr/bin/root_proxy --proxy-ignore-insecure 1 --proxy-shname $0 --proxy-lineno $LINENO"
fi

G_DISK_BOOT=/startup_disk/image
APOLLO1_PATH="/startup_disk/image/pkg_cur/apollo-1.1.1.0"
HIS_KERNEL_FILE_601_RELEASE=${APOLLO1_PATH}/"his_kernel-1.0.0.4-release-20200412055744-aarch64.tar.gz"
HIS_KERNEL_FILE_600_RELEASE=${APOLLO1_PATH}/"his_kernel-1.0.0.3-release-20200111085413-aarch64.tar.gz"
HIS_KERNEL_FILE_601_CRACK=${APOLLO1_PATH}/"his_kernel-1.0.0.4-release_crack-20200412060304-aarch64.tar.gz"
HIS_KERNEL_FILE_600_CRACK=${APOLLO1_PATH}/"his_kernel-1.0.0.3-release_crack-20200111085750-aarch64.tar.gz"
HIS_KERNEL_FILE_601_DEBUG=${APOLLO1_PATH}/"his_kernel-1.0.0.4-debug-20200412060620-aarch64.tar.gz"
HIS_KERNEL_FILE_600_DEBUG=${APOLLO1_PATH}/"his_kernel-1.0.0.3-debug-20200111085113-aarch64.tar.gz"

HIS_KERNEL_FILE_LIST=(${HIS_KERNEL_FILE_601_RELEASE} ${HIS_KERNEL_FILE_600_RELEASE} ${HIS_KERNEL_FILE_601_CRACK} ${HIS_KERNEL_FILE_600_CRACK} ${HIS_KERNEL_FILE_601_DEBUG} ${HIS_KERNEL_FILE_600_DEBUG})


Mount_With_Retry()
{
    #修改启动分区读写权限
    L_DISK_PROPERTY=$1
    for((i=0;i<10;i++))
    do
        ${ROOT_PROXY} mount -o $L_DISK_PROPERTY,remount $G_DISK_BOOT 1>/dev/null 2>/dev/kmsg
        L_MOUNT_RET=$?
        if [[ "0" == "$L_MOUNT_RET" ]];then
            break
        fi
        OS_echo "[CHECK_HIS_KERNLE] : mount ${G_DISK_MOUNT_IMAGE} for $L_DISK_PROPERTY fail times=${i}."
        sleep 1
    done
    if [[ "0" != "$L_MOUNT_RET" ]];then
        OS_echo "[CHECK_HIS_KERNLE] : mount ${G_DISK_MOUNT_IMAGE} for $L_DISK_PROPERTY fail."
        return 1
    fi
    return 0
}

REMOVE_HIS_KERNEL()
{
    for his_kernel in ${HIS_KERNEL_FILE_LIST[@]}
    do
        if [[ -f "${his_kernel}" ]]; then
            ${ROOT_PROXY} rm -rf "${his_kernel}"
            if [[ $? != 0 ]]; then
                return 1
            fi
        fi
    done
    return 0
}

Mount_With_Retry rw
REMOVE_HIS_KERNEL
ret=$?
Mount_With_Retry ro

if [[ "${ret}" != 0 ]]; then
  echo "False"
  exit 1
fi

echo "True"
exit 0

