#!/usr/bin/python
# -*- coding: utf-8 -*-
import json
import logging
import sys


logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')

def swm_check_version():
    version_file = "/tmp/check_extend_param"
    dst_version = ""
    dst_version_list = ["6.0.1", "6.1.RC1"]

    with open(version_file, 'r') as f:
        read_str = str(f.read()).replace("'", '"')
        logging.info("swm: Read str %s.", read_str)
        extend_param = json.loads(read_str)
        dst_version = str(extend_param.get('targetVersion', ''))
        logging.info("swm: Dst version %s read from extend param file %s.", dst_version, version_file)

    if dst_version in dst_version_list:
        print("False")
        return 0

    print("True")
    return 0


def main():
    try:
        ret = swm_check_version()
        return ret
    except Exception as e:
        logging.exception("swm: %s", e)
        print("False")
        return 1


if __name__ == '__main__':
    sys.exit(main())
