#!/usr/bin/python
# -*- coding:utf-8 -*-
import sys
import logging
from xml.dom import minidom

# 定义返回值
RETURN_OK = 0
RETURN_ERROR = 1
PYTHON_2 = '2.7' in sys.version

# 初始化系统日志
logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')


def is_multi_eng():
    result = False
    with open("/OSM/conf/bay_config.ini") as bay_cfg:
        line = bay_cfg.readline()
        while line:
            line = bay_cfg.readline()
            if line.strip() == 'ScaleOutType=0':
                result = True
                break
    return result


def parse_ruls_port_list(port_list):
    if PYTHON_2:
        import commands
        ip_rule_ret_obj = commands.getstatusoutput("ip rule | grep -v 'blackhole' "
                                                   "| grep -E '172\.16\.[0-3]\.[1-8] ' "
                                                   "| awk '{print $5}'")
    else:
        import subprocess
        ip_rule_ret_obj = subprocess.getstatusoutput("ip rule | grep -v 'blackhole' "
                                                     "| grep -E '172\.16\.[0-3]\.[1-8] ' "
                                                     "| awk '{print $5}'")
    if ip_rule_ret_obj[0] != 0:
        logging.warning("DEVM_UPG_CHECK_TOOL: get ip rule info fail, ret %d.", ip_rule_ret_obj[0])
        return RETURN_ERROR

    for port_id in ip_rule_ret_obj[1].split("\n"):
        if port_id == '':
            continue
        port_id_value = int(port_id, 10)
        port_list.append(port_id_value)

    return RETURN_OK


def parse_scaleout_port_list(port_id_arr):
    doc = minidom.parse("/OSM/conf/eam_conf/net_conf.xml")
    root = doc.documentElement
    des_nodes = root.getElementsByTagName('description')
    for des_node in des_nodes:
        type_value = des_node.getAttribute('type')
        if type_value != 'scaleout':
            continue

        index_nodes = des_node.getElementsByTagName('index')
        for index_node in index_nodes:
            port_id_nodes = index_node.getElementsByTagName('portId')
            if port_id_nodes is None:
                continue
            port_id_str = port_id_nodes[0].childNodes[0].nodeValue
            port_id_value = int(port_id_str, 16)
            port_id_arr.append(port_id_value)


def check_is_ip_conflict():
    scale_out_port_list = []
    ip_rule_port_list = []

    parse_scaleout_port_list(scale_out_port_list)
    ret = parse_ruls_port_list(ip_rule_port_list)
    if ret != RETURN_OK:
        return RETURN_ERROR

    for port_id in ip_rule_port_list:
        if port_id in scale_out_port_list:
            continue
        else:
            logging.warning("DEVM_UPG_CHECK_TOOL: port id is %d.", port_id)
            return RETURN_ERROR

    return RETURN_OK


def main():
    try:
        multi_eng = is_multi_eng()
        if multi_eng is True:
            check_ret = check_is_ip_conflict()
            if check_ret != RETURN_OK:
                logging.warning("DEVM_UPG_CHECK_TOOL: check is not ok.")
                print("False")
                return RETURN_OK

        logging.info("DEVM_UPG_CHECK_TOOL: check is ok.")
        print("True")
        return RETURN_OK
    except Exception as e:
        logging.exception("DEVM_UPG_CHECK_TOOL: %s", e)
        print("False")
        return RETURN_ERROR


if __name__ == '__main__':
    sys.exit(main())