#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import sys
import shlex
import subprocess

USER_EXIST = r'id -u admin > /dev/null 2>&1'
USER_CMD = r"cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:'"
USER_LOGIN_CMD = "/ISM/cli/ismcli -u {0}"
TIMEOUT = 5 * 60

logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')


def cli(command):
    sub_cmds = command.split(" | ")
    process = None
    for sub_cmd in sub_cmds:
        if process:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdin=process.stdout, stdout=subprocess.PIPE)
        else:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdout=subprocess.PIPE)
    out = process.communicate(timeout=TIMEOUT)
    return out[0].decode("utf-8")


def get_user_name():
    ret = os.system(USER_EXIST)
    if not ret:
        return 'admin'
    else:
        output = cli(USER_CMD)
        if not output:
            logging.warning("Get user failed")
            return ''
        return output.strip().split(':')[0]


def net_check_is_have_bond():
    user_name = get_user_name()
    if not user_name:
        logging.warning("NET_CHECK_IS_HAVE_BOND: Get user failed.")
        print("False")
        return
    cli_login_str = USER_LOGIN_CMD.format(user_name)
    cmd_exec_dis_output_file_path = "/tmp/netcheckishavebond"

    # 构造cli命令
    cli_cmd_str = "echo -e 'show bond_port' | " + cli_login_str + r"  > " + cmd_exec_dis_output_file_path

    ret = os.system(cli_cmd_str)
    if ret:
        logging.warning("NET_CHECK_IS_HAVE_BOND: Cmd(%s) exec failed, ret %d.", cli_cmd_str, ret)
        print("False")
        # 删除临时文件
        shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
        os.system(shell_cmd_str)
        return

    with open(cmd_exec_dis_output_file_path) as lines:
        lines_array = lines.readlines()
        # 跳过前两行表头打印或是无bond记录时的回显
        lines_array = lines_array[4:]

        find = False
        # 解析每条bond记录，判断是否MTU是默认值，不是则报错
        for line in lines_array:
            record = line.lstrip().split()
            if record[4] != "Up":
                continue
            logging.warning("NET_CHECK_IS_HAVE_BOND: %s is %s.", record[1], record[4])
            find = True
            break
        if find:
            logging.warning("NET_CHECK_IS_HAVE_BOND: Check is not ok.")
            print("False")
        else:
            logging.warning("NET_CHECK_IS_HAVE_BOND: Check is ok.")
            print("True")

    # 删除临时文件
    shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
    os.system(shell_cmd_str)
    return


def main():
    try:
        net_check_is_have_bond()
        return 0

    except Exception as e:
        logging.exception("NET_CHECK_IS_HAVE_BOND: %s", e)
        print("False")
        return 1


if __name__ == '__main__':
    sys.exit(main())
