#!/bin/bash
##检查Rquota Port是否为默认值762，如果被修改过，即非762， 需要在升级前进行提示错误；
##如果当前不是rquota port的默认值762的话，即Rquota Port被修改了，则返回失败，否则为true##

##删除文件##
function DELETE_FILE()
{
    sudo rm -f /tmp/nasShowVstore.txt
    sudo rm -f /tmp/nasShowVstoreID.txt
    sudo rm -f /tmp/nasCheckRquotaPort.txt
    sudo rm -f /tmp/nasCheckRquotaPortTotal.sh
}

##检查是否存在admin用户，没有就找其他用户##
if $(id -u admin > /dev/null 2>&1)
then
    adminName="admin"
else
    adminName=$(cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:')
    adminName=${adminName%%:*}
fi
##不存在任何用户的话，显示未完成检查##
if [ -z $adminName ]
then
    echo "FALSE"
    exit 1
fi

##查询是否存在rquota port字段##
DELETE_FILE
sudo touch /tmp/nasShowVstore.txt
sudo touch /tmp/nasShowVstoreID.txt
sudo touch /tmp/nasCheckRquotaPort.txt
sudo touch /tmp/nasCheckRquotaPortTotal.sh

##查询租户，并记录其Id
echo -e "show vstore\n" | /ISM/cli/ismcli -u $adminName > /tmp/nasShowVstore.txt
sed -n '5,$p' /tmp/nasShowVstore.txt | awk '{print $1}' > /tmp/nasShowVstoreID.txt

##把需要执行的命令提前准备好，放进一个脚本文件中，记录租户id不为0时候的执行命令##
echo "sudo /ISM/cli/start.sh -u admin <<EOF" > /tmp/nasCheckRquotaPortTotal.sh
for line in $(cat /tmp/nasShowVstoreID.txt)
do
 if [ $line -ne 0 ]; then
    echo "change vstore view id=$line" >> /tmp/nasCheckRquotaPortTotal.sh
    echo "show service nfs_config" >> /tmp/nasCheckRquotaPortTotal.sh
 fi
done
echo "EOF" >> /tmp/nasCheckRquotaPortTotal.sh

##执行脚本，并且判断为Rquota Port字段且值不为762时候，存在返回false 否则为true##
sudo sh /tmp/nasCheckRquotaPortTotal.sh > /tmp/nasCheckRquotaPort.txt
ans=$(cat /tmp/nasCheckRquotaPort.txt | grep -w 'Rquota Port' | grep -v '762')
if [  -n "$ans" ]
then
    DELETE_FILE
    echo "FALSE" 
    exit 0
fi

## 遍历循环
DELETE_FILE
echo "TRUE"
exit 0
