#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2018-2022. All rights reserved.

import os
import sqlite3

from infra.debug.log import swm_logger as log

DB_CACHE_DIR = "/OSM/ccdb/cache"


class SqlExecutor(object):
    def get_dd_dir_name(self):
        dd_dir_name = ""
        for dir_name in os.listdir(DB_CACHE_DIR):
            if "dd_database" in dir_name:
                dd_dir_name = dir_name
                break
        return dd_dir_name

    def get_invalid_ini_key_dict(self, cursor):
        ini_key_dict = {}
        # hostLinkId 第33-end: FC: WWN; ISCSI: IQN
        # 2031616=0x1F0000 表示多路径31.00.000版本
        sql = "select substr(hostLinkId,33,length(hostLinkId)-32) as iniKey from DD_OBJ_HOST_LINK_S \
        where (iniType=223 or iniType=222) and hostId!=4294967295 and ultrapathVersion<2031616 \
        and ultrapathVersion!=0 group by iniKey"
        values = cursor.execute(sql)
        for value in values:
            ini_key_dict[value[0]] = 1
        return ini_key_dict

    def get_windows_invalid_ini_key_by_dict(self, cursor, ini_key_dict):
        invalid_ini_key_list = []
        if len(ini_key_dict) == 0:
            return invalid_ini_key_list

        # OS_TYPE_Windows:1 OS_TYPE_Win_2012:9
        sql = "select iqn from DD_ISCSI_INI_S where (osType=1 or osType=9) and isFree=0"
        values = cursor.execute(sql)
        for value in values:
            if value[0] in ini_key_dict:
                # IQN不能完整打印出现，按安全结论，屏蔽掉前3分之1
                start_index = len(value[0]) // 3
                invalid_ini_key_list.append(value[0][start_index:])

        sql = "select wwn from DD_FC_INI_S where (osType=1 or osType=9) and isFree=0"
        values = cursor.execute(sql)
        for value in values:
            if value[0] in ini_key_dict:
                invalid_ini_key_list.append(value[0])

        return invalid_ini_key_list

    @classmethod
    def get_windows_invalid_ini_key(cls):
        dd_database_path = os.path.join(DB_CACHE_DIR, cls().get_dd_dir_name(), "dd_database")
        if not os.path.exists(dd_database_path):
            log.error('Dd DataBase ({0}) is not exists.'.format(dd_database_path))
            return False, ""
        conn = sqlite3.connect(dd_database_path)
        cursor = conn.cursor()

        ini_key_dict = cls().get_invalid_ini_key_dict(cursor)
        invalid_ini_key_list = cls().get_windows_invalid_ini_key_by_dict(cursor, ini_key_dict)

        conn.close()

        return True, invalid_ini_key_list
