#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2018-2022. All rights reserved.
import sys
import time


class Timer(object):
    NOW_TIME_FUNC = time.perf_counter if sys.version_info >= (3, 3) else time.time  # pylint: disable=E1101

    def __init__(self, time_limit):
        self.start_time = self.NOW_TIME_FUNC()
        self.end_time = self.start_time + int(time_limit)

    def waited_time(self):
        return self.NOW_TIME_FUNC() - self.start_time

    def is_timeout(self):
        return self.NOW_TIME_FUNC() >= self.end_time
