#!/bin/bash
G_BDM_RET_SUCC=0              
G_BDM_RET_FAIL=1 

BDM_CHECK_PATCH_601()
{
    local CMD="ver show 3"
    local L_TempFile="bdmupgdiskcheckpatchtempfile"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}
    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{print $4}'`
    rm ${L_TempFile}
    
    if [[ "$VER" == "SPH1" ]] || [[ "$VER" == "--" ]]; then
        return ${G_BDM_RET_FAIL}
    fi
    return ${G_BDM_RET_SUCC}
}

#获取阵列版本
BDM_CHECK_PRODUCT_VER()
{
    local CMD="ver show 1"
    local L_RET=0
    local L_TempFile="bdmupgdiskchecktempfile"
    local VER=""
(
swm_diagnose <<EOF
${CMD}
exit
EOF
) > ${L_TempFile}

    VER=`grep Controller "${L_TempFile}" | head -1 | awk '{print $4}'`
    rm ${L_TempFile}
    if [[ "$VER" == "6.0.1" ]]
    then
        BDM_CHECK_PATCH_601
        L_RET=$?
        if [ "${L_RET}" == "${G_BDM_RET_SUCC}" ] ;then
            return ${G_BDM_RET_SUCC}
        else
            return ${G_BDM_RET_FAIL}
        fi
    else
        return ${G_BDM_RET_SUCC}
    fi
}

BDM_CHECK_PRODUCT_VER
ret=$?
if [ "${ret}" == "${G_BDM_RET_SUCC}" ] ;then
    echo "TRUE"
else
    echo "FALSE"
fi
exit 0
