#!/bin/bash
# BMC告警检查

function bmc_power_alarm_check()
{
    # 查看当前设备电源告警点数目
    ret=`ipmitool raw 0x32 0xb9 0x00 0x10 0x00 0x00 0xff  2>&1`
    if [ "$?" != 0 ];then
	    return 0
    fi
    ret=`echo $ret | sed s/[[:space:]]//g`
    local p_alarm_num=$((16#$ret))
    for ((i=0; i<${p_alarm_num}; i++))
    do
        local p_alarm_id=`printf "0x%02x" $i`
        ret1=`ipmitool raw 0x32 0x07 0x00 0x10 0x00 ${p_alarm_id} 0x3b 2>&1`
        if [ "$?" == 0 ];then
            ret1=`echo $ret1 | sed s/[[:space:]]//g`
            if [ "$ret1" == "07000000" ];then
                ret2=`ipmitool raw 0x32 0x07 0x00 0x10 0x00 ${p_alarm_id} 0x3c 2>&1`
                if [ "$?" == 0 ];then
                    ret2=`echo $ret2 | sed s/[[:space:]]//g`
                    if [ "$ret2" != "00000000" ] && [ "$ret2" != "ffffffff" ];then
                        return 1
                    fi
                fi
            fi
        fi
    done
    return 0
}

function comm_alarm_check()
{
    array=(2410 2c10 3510)
    # 判断当前设备是否存在控制器与管理板告警，只在高端控制板存在
    ret=`ipmitool raw 0x32 0x09 0x00 0x02 0x00 0x00 0x00 2>&1`
    if [ "$?" == 0 ];then
        ret=`echo $ret | sed s/[[:space:]]//g`
        if [[ "${array[*]}" =~ "$ret" ]]; then
            local TempFile="commalarm_tmp"
            ipmitool raw 0x32 0xb3 0x00 0x02 0x00 0x00 0x3c 0x27 > ${TempFile} 2>&1
            # 查询失败返回成功
            if [ "$?" == 0 ];then
                # 控制器与管理板A有告警: 01 00 01 00; 无告警：00 00 01 00
                local status_a=`cat ${TempFile} | tr -d '\n' | awk -F " " '{print $149}' `
                # 控制器与管理板B有告警: 01 00 11 00; 无告警：00 00 11 00
                local status_b=`cat ${TempFile} | tr -d '\n' | awk -F " " '{print $153}' `
                # 删除临时文件
                rm ${TempFile} > /dev/null 2>&1
                # 空字符串则返回成功
                if [ -z "$status_a" ] || [ -z "$status_b" ] ; then
                    return 0
                fi
                if [ $((16#$status_a)) -eq 1 ] || [ $((16#$status_b)) -eq 1 ]; then
                    return 1
                fi
            fi
        fi
    fi

    return 0
}

function board_flash_alarm_check()
{
    # 查看当前设备主板告警点数目
    b_ret=`ipmitool raw 0x32 0xb9 0x00 0x02 0x00 0x00 0xff 2>&1`
    if [ "$?" != 0 ];then
	    return 0
    fi
    b_ret=`echo $b_ret | sed s/[[:space:]]//g`
    alarm_num=$((16#$b_ret))
    local alarm_max=`printf "0x%02x" $alarm_num`
    for ((i=0; i<${alarm_num}; i++))
    do
        local alarm_id=`printf "0x%02x" $i`
        ret1=`ipmitool raw 0x32 0x07 0x00 0x02 0x00 ${alarm_id} 0x3b 2>&1`
        if [ "$?" == 0 ];then
            ret1=`echo $ret1 | sed s/[[:space:]]//g`
            if [ "$ret1" == "15" ];then
                local TmpFlashFile="flash_alarm_tmp"
                ipmitool raw 0x32 0xb3 0x00 0x02 0x00 0x00 0x3c ${alarm_max} > ${TmpFlashFile} 2>&1
                # 查询成功继续查询告警状态
                if [ "$?" == 0 ];then
                    local index=`expr $i \* 4` 
                    index=`expr $index + 1`
                    local flash_alarm_sta=`cat ${TmpFlashFile} | tr -d '\n' | awk -F " " -v awk_idx="$index" '{print $awk_idx}' `
                    # 删除临时文件
                    rm ${TmpFlashFile} > /dev/null 2>&1
                    if [ -z "$flash_alarm_sta" ] ; then
                        return 0
                    fi
                    if [ $((16#$flash_alarm_sta)) -eq 1 ]; then
                        return 1
                    fi
                fi
                # 查询失败直接返回成功
                return 0
            fi
        fi
    done
    return 0
}


function smm_flash_alarm_check()
{
    if [ "$1" == "" ]; then	
	    return 0
    fi
    input_smm_idx=$1
    # 查看当前设备主板告警点数目
    smm_ret=`ipmitool raw 0x32 0xb9 $input_smm_idx 0x04 0x00 0x00 0xff 2>&1`
    if [ "$?" != 0 ];then
	    return 0
    fi
    smm_ret=`echo $smm_ret | sed s/[[:space:]]//g`
    smm_alarm_num=$((16#$smm_ret))
    smm_alarm_max=`printf "0x%02x" $smm_alarm_num`
    for ((i=0; i<${smm_alarm_num}; i++))
    do
        smm_alarm_id=`printf "0x%02x" $i`
        smm_ret1=`ipmitool raw 0x32 0x07 $input_smm_idx 0x04 0x00 ${smm_alarm_id} 0x3b 2>&1`
        if [ "$?" == 0 ];then
            smm_ret1=`echo $smm_ret1 | sed s/[[:space:]]//g`
            if [ "$smm_ret1" == "15" ];then
                SmmTmpFlashFile="smm_flash_file"
                # 查询A管理板
                ipmitool raw 0x32 0xb3 $input_smm_idx 0x04 0x00 0x00 0x3c ${smm_alarm_max} > ${SmmTmpFlashFile} 2>&1
                if [ "$?" == 0 ];then
                    smm_id=`expr $i \* 4` 
                    smm_id=`expr $smm_id + 1`
                    smm_alarm_sta=`cat ${SmmTmpFlashFile} | tr -d '\n' | awk -F " " -v awk_idx="$smm_id" '{print $awk_idx}' `
                    # 删除临时文件
                    rm ${SmmTmpFlashFile} > /dev/null 2>&1
                    if [ -z "$smm_alarm_sta" ] ; then
                        return 0
                    fi
                    if [ $((16#$smm_alarm_sta)) -eq 1 ]; then
                        return 1
                    fi
                fi
            fi
        fi
    done
    return 0
}


comm_alarm_check
if [ $? -ne 0 ]; then
	echo "False"
	exit 0
fi

board_flash_alarm_check
if [ $? -ne 0 ]; then
	echo "False"
	exit 0
fi

smma_pst=`ipmitool raw 0x32 0x06 0x00 0x02 0x00 0x10 0x00 2>&1`
if [ "$?" == 0 ];then
    smma_pst=`echo $smma_pst | sed s/[[:space:]]//g`
    if [ "$smma_pst" == "01" ];then
        smm_flash_alarm_check 0x00
	    if [ $? -ne 0 ]; then
	        echo "False"
	        exit 0
        fi
    fi
fi

smmb_pst=`ipmitool raw 0x32 0x06 0x00 0x02 0x00 0x11 0x00 2>&1`
if [ "$?" == 0 ];then
    smmb_pst=`echo $smmb_pst | sed s/[[:space:]]//g`
    if [ "$smmb_pst" == "01" ];then
        smm_flash_alarm_check 0x01
	    if [ $? -ne 0 ]; then
	        echo "False"
	        exit 0
        fi
    fi
fi

bmc_power_alarm_check
if [ $? -ne 0 ]; then
	echo "False"
	exit 0
fi

echo "True"
exit 0
