#!/bin/bash
G_BDM_RET_SUCC=0
G_BDM_RET_FAIL=1 
Manifest_Path="/OSM/conf/manifest.yml"
Patch_Conf_Path="/OSM/conf/patch.yml"

BDM_CHECK_PATCH_613()
{
    if [ ! -e "${Patch_Conf_Path}" ]; then
        return ${G_BDM_RET_FAIL}
    fi
    local VER=$(cat "${Patch_Conf_Path}" |grep -w "patch_version" |awk '{print $2}' |sed 's/ //g')
    if [[ "$VER" == "--" ]]; then
        return ${G_BDM_RET_FAIL}
    fi

    if [[ $VER =~ SPH[0-9]+ ]]; then
        num=${VER#SPH}
        if [[ $num -ge 10 ]]; then
            return ${G_BDM_RET_SUCC}
        fi
    fi
    return ${G_BDM_RET_FAIL}
}

BDM_CHECK_PATCH_615()
{
    if [ ! -e "${Patch_Conf_Path}" ]; then
        return ${G_BDM_RET_FAIL}
    fi

    local VER=$(cat "${Patch_Conf_Path}" |grep -w "patch_version" |awk '{print $2}' |sed 's/ //g')
    if [[ "$VER" == "--" ]]; then
        return ${G_BDM_RET_FAIL}
    fi

    if [[ "$VER" == "--" ]]; then
        return ${G_BDM_RET_FAIL}
    fi

    if [[ $VER =~ SPH[0-9]+ ]]; then
        num=${VER#SPH}
        if [[ $num -ge 8 ]]; then
            return ${G_BDM_RET_SUCC}
        fi
    fi
    return ${G_BDM_RET_FAIL}
}

#获取阵列版本
BDM_CHECK_PRODUCT_VER()
{
    local VER=""
    local Product=""

    Product=$(cat "${Manifest_Path}" | grep "Product:" | awk '{print $2}')
    if [[ "$Product" != "Converged" ]]; then
        return ${G_BDM_RET_SUCC}
    fi

    VER=$(cat "${Manifest_Path}" |grep -w "SpcVersion" |awk '{print $2}' |sed 's/ //g')
    VER=${VER:0:5}

    if [[ "$VER" == "6.1.3" ]];then
        BDM_CHECK_PATCH_613
        return $?
    elif [[ "$VER" == "6.1.5" ]];then
        BDM_CHECK_PATCH_615
        return $?
    else
        return ${G_BDM_RET_SUCC}
    fi
}

BDM_CHECK_PRODUCT_VER
ret=$?
if [ "${ret}" == "${G_BDM_RET_SUCC}" ] ;then
    echo "TRUE"
else
    echo "FALSE"
fi
exit 0
