#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2018-2024. All rights reserved.
import sys

from check_item.check_util.util import get_product_name, ProductName, console_print
from infra.debug.log import swm_logger as log

LOG_TAG = 'NoV6Checker'
BSP_INFO_FILEPATH = '/proc/osp/bsp'
NO_V6_FLAG = 'rv:1'


def check_has_no_v6_flag():
    with open(BSP_INFO_FILEPATH, 'r') as fp:
        flag_line = ''
        for line in fp:
            if line.startswith('Product config info:'):
                flag_line = line.split(':', 1)[1]
                break

    log.info('%s: Get Product config info line is: %s', LOG_TAG, flag_line)
    return NO_V6_FLAG in flag_line.strip().split(';') if flag_line else False


def main():
    product_name = get_product_name()
    if not product_name:
        console_print('False')
        log.error('%s: Get product name failed.', LOG_TAG)
        return 1
    if product_name != ProductName.Dorado:
        console_print('True')
        log.info('%s: Only dorado has no v6 feature.', LOG_TAG)
        return 0
    if check_has_no_v6_flag():
        console_print('False')
        log.info('%s: Exists no v6 flag.', LOG_TAG)
        return 0
    console_print('True')
    log.info('%s: Not Exists no v6 flag.', LOG_TAG)
    return 0


if __name__ == '__main__':
    sys.exit(main())
