#!/bin/bash
if [ -f /usr/bin/root_proxy ]; then
    ROOT_PROXY="/usr/bin/root_proxy --proxy-ignore-insecure 1 --proxy-shname $0 --proxy-lineno $LINENO"
fi
OCEAN_PROTECT_110_LAST_VERSION=7600508181
G_PKG_YML_FILE=/startup_disk/image/pkg_upd/manifest.yml
G_CUR_PKG_YML_FILE=/startup_disk/image/pkg_cur/manifest.yml
UPGRADE_SH=checkRepDedupeDegrade.sh
result="False"
L_PKG_VERSION_STR=`${ROOT_PROXY} cat "${G_PKG_YML_FILE}" |grep -m 1 Version |awk -F":" '{print $2}'`
OS_echo "${UPGRADE_SH} : dedupe degrade:pkg version ${L_PKG_VERSION_STR}">/dev/null
declare -i L_PKG_VERSION=0
L_PKG_VERSION=`echo "${L_PKG_VERSION_STR}" | ${ROOT_PROXY} sed 's/[.T]//g' | ${ROOT_PROXY} sed 's/[[:space:]]//g'`
G_CUR_PKG_PRODUCT=`${ROOT_PROXY} cat "${G_CUR_PKG_YML_FILE}" |grep -m 1 Product |awk -F":" '{print $2}'`
#获取目标 是否大于 不支持重删的最后一个版本， 大于则目标版本也支持重删， 不做处理
if [[ ${L_PKG_VERSION} -gt ${OCEAN_PROTECT_110_LAST_VERSION} || ${G_CUR_PKG_PRODUCT} != "BackupStorage" ]];then
    OS_echo "dedupe degrade pkg version support dedupe or product not BackupStorage ."
    result="True"
else
    diagsh --attach=*_12 --cmd="reprm showExistDedupeCfg" > /OSM/conf/reprmtepfile
    keyword=`${ROOT_PROXY} cat "/OSM/conf/reprmtepfile" | grep 'pass' |awk -F ' ' '{print $4}'|awk -F ',' '{print $1}'`
    if [ "${keyword}" != "pass" ];then
        OS_echo "dedupe degrade check failed, keyword: ${keyword}."
        result="False"
    else
        result="True"
    fi
fi
 
echo ${result}
${ROOT_PROXY} rm -f /OSM/conf/reprmtepfile
exit 0