#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import sys
import yaml
import re
import subprocess

logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')

RESULT_FILE_PATH = "/tmp/checkDdVersionTempResult"

# 直接执行diagnose命令的字符串格式：
# {0}表示attach的进程id,比如app_data为12，
# {1}表示需要执行的diagnose命令，
DIAGNOSE_CHECK_CMD = "diagsh,--attach=*_{0},--cmd={1}"

# 618 TR5发布版本号+1
VER_MICRO_618 = 7610107197
VER_OCEANSTOR_618 = 7600518302
VER_MICRO_V7 = 7610710000
VER_OCEANSTOR_V7 = 7600710000
# 版本信息文件（目标版本）
UPG_MANIFEST_PATH = '/startup_disk/image/pkg_upd/manifest.yml'
SYSTEM_NAME_IN_YML = "SYS"


# 获取目标版本信息
def get_upg_system_version_new():
    """
    获取系统版本号
    """
    if not os.path.exists(UPG_MANIFEST_PATH):
        logging.warning("sys file didnt exist.")
        return "", "", ""
    with open(UPG_MANIFEST_PATH) as file_handle:
        cfg_yml = yaml.safe_load(file_handle)
        try:
            target_version = str(cfg_yml.get(SYSTEM_NAME_IN_YML)["Version"])
            target_spc_version = str(cfg_yml.get(SYSTEM_NAME_IN_YML)["SpcVersion"])
            product = str(cfg_yml.get(SYSTEM_NAME_IN_YML)["Product"])
            return target_version, target_spc_version, product
        except Exception:
            logging.warning("CHECK_FUNC: Failed to get version.")
            return "", "", ""


def do_diag(diag_cmd_str):
    diag_cmd_str = DIAGNOSE_CHECK_CMD.format(12, diag_cmd_str)
    diag_out = ""
    try:
        diag_process = subprocess.Popen(diag_cmd_str.split(','), stdout=subprocess.PIPE, shell=False)
        diag_out = diag_process.communicate()[0].decode('utf-8')
    except Exception as error:
        logging.exception(error)
        logging.error("DOWNGRADE_CHECK: Cmd(%s) exec failed.", diag_cmd_str)
    return diag_out


# 检查产品类型及目标版本
def downgrade_check_bucket_exp8():
    """
    检查产品类型及目标版本
    """
    ret = do_diag("pmgr isddptypecandowngrade -t 1")
    if re.search('True', ret):
        return 0
    target_version = get_upg_system_version_new()[0]
    product = get_upg_system_version_new()[2]
    logging.info("DOWNGRADE_CHECK: product: %s target version: %s.", product, target_version)
    if not target_version or not product:
        logging.error("DOWNGRADE_CHECK: The product or target version is empty.")
        return -1
    if ("Micro" == product or "Micro_Unified" == product) and int(target_version) < VER_MICRO_618:
        logging.error("DOWNGRADE_CHECK: micro not match, product:%s, version:%s.", product, target_version)
        return -1
    elif ("BackupStorage" != product) and int(target_version) < VER_OCEANSTOR_618:
        logging.error("DOWNGRADE_CHECK: oceanstor not match, product:%s, version:%s.", product, target_version)
        return -1
    return 0


def downgrade_check_cap_opt():
    """
    检查产品类型及目标版本
    """
    ret = do_diag("pmgr isddptypecandowngrade -t 2")
    if re.search('True', ret):
        return 0
    if re.search('type not valid', ret):
        return 0
    target_version = get_upg_system_version_new()[0]
    product = get_upg_system_version_new()[2]
    logging.info("DOWNGRADE_CHECK: product: %s target version: %s.", product, target_version)
    if not target_version or not product:
        logging.error("DOWNGRADE_CHECK: The product or target version is empty.")
        return -1
    if ("Micro" == product or "Micro_Unified" == product) and int(target_version) < VER_MICRO_V7:
        logging.error("DOWNGRADE_CHECK: micro not match, product:%s, version:%s.", product, target_version)
        return -1
    elif ("BackupStorage" != product) and int(target_version) < VER_OCEANSTOR_V7:
        logging.error("DOWNGRADE_CHECK: oceanstor not match, product:%s, version:%s.", product, target_version)
        return -1
    return 0


def main():
    """
    执行函数
    """
    try:
        ret = downgrade_check_bucket_exp8()
        if ret != 0:
            print("False")
            return 0
        ret = downgrade_check_cap_opt()
        if ret != 0:
            print("False")
            return 0
        print("True")
        return 0

    except Exception as exp:
        logging.exception("downgrade_diskdomin_version_for_fast_path_check: %s", exp)
        print("False")
        return 1


if __name__ == '__main__':
    sys.exit(main())
