#!/usr/bin/python
# -*- coding: utf-8 -*-
#版权所有 (c) 华为技术有限公司 2023

import os
import random
import sys
import yaml
from config import path
from infra.debug.log import swm_logger as log
from infra.util import pkg
from service.version.ver_mgr import VerMgr

# 直接执行diagnose命令的字符串格式：
# {0}表示attach的进程id,比如app_data为12，
# {1}表示需要执行的diagnose命令，
# {2}表示命令执行回显重定向文件，用于命令执行后的结果解析
DIAGNOSE_CHECK_CMD = "diagsh --attach=*_{0} --cmd='{1}' > '{2}'"
# 615发布版本，版本号
VER_615_REALEASE = '7600511'


def downgrade_check_impl():

    diagnose_cmd_str = "cdpschedule isAllowDowngrade"
    # 执行回显输出的临时文件，为了尽量避免与其他检查项冲突，
    # 文件名建议通过随机字符串格式化
    cmd_exec_output_file_path = "/tmp/showspaceisallowdowngrade_{0}".\
        format(''.join(random.sample('zyxwvutsrqponmlkjihgfedcba', 5)))

    diagnose_cmd_str = DIAGNOSE_CHECK_CMD.format(12, diagnose_cmd_str,
                                                 cmd_exec_output_file_path)
    ret = os.system(diagnose_cmd_str)
    if ret:
        log.error("DOWNGRADE_CHECK: Cmd(%s) exec failed.", diagnose_cmd_str)
        print("1077949019")
        os.remove(cmd_exec_output_file_path)
        return False

    with open(cmd_exec_output_file_path) as lines:
        lines_array = lines.readlines()
        for line in lines_array:
            # 解析每行字符串，获取需要的信息进行判断，
            if "True" in line:
                os.remove(cmd_exec_output_file_path)
                return True

    log.error("DOWNGRADE_CHECK: The system have hypercdp and use newmemdb.")

    os.remove(cmd_exec_output_file_path)
    return False


def downgrade_check(src_ver, target_ver):
    if (target_ver[:7] > VER_615_REALEASE):
        print("True")
        return

    is_allow = downgrade_check_impl();
    if (is_allow):
        print("True")
        return;

    print("False")
    return


def main():
    """
    检查主函数，一般不需要修改
    :return:
    """
    try:

        src_ver = VerMgr.get_src_version()[0]
        # 降级/升级目标版本，如果采用shell脚本实现，需要自行解析
        # /startup_disk/image/pkg_upd/manifest.yml中SYS下的version字段值，
        # 此配置文件只有升级开始并完成软件包上传后才有
        target_ver = pkg.get_pkg_version(path.TARGET_CONFIG_PATH)[0]
        if not src_ver or not target_ver:
            log.error("DOWNGRADE_CHECK: The src or target version is empty.")
            print("False")
            print("1077949019")
            print("src version or target version is not exist")
            return 1
        downgrade_check(src_ver, target_ver)

        return 0
    except Exception as ecp:
        print("False")
        print("1077949019")
        log.exception(ecp)
        return 1


if __name__ == '__main__':
    sys.exit(main())
