#!/bin/bash
COMP_ALG_HZU_FIRST_VERSION=7600710069
G_PKG_YML_FILE=/startup_disk/image/pkg_upd/manifest.yml
L_PKG_VERSION_STR=$(cat ${G_PKG_YML_FILE} |grep -m 1 Version |awk -F":" '{print $2}')
declare -i L_PKG_VERSION=0
L_PKG_VERSION=$(echo "${L_PKG_VERSION_STR}" | sed 's/[.T]//g' | sed 's/[[:space:]]//g')

##检查热补丁是否切换过压缩算法##
isSwitched=0
checkHotpatch()
{
	if [ ${L_PKG_VERSION} -ge ${COMP_ALG_HZU_FIRST_VERSION} ];then
		return
    fi
	AllDiskPoolId=`(diagsh --attach="app_data_12" --cmd="pmgr showdp") | grep 0x|awk '{print substr($0,0,12)}'`
	touch poolCheckCompAlgSwitch
	for dpid in $AllDiskPoolId
	do {
		diagsh --attach=*_12 --cmd="pmgr showFsDataCompressType -d $dpid" > "poolCheckCompAlgSwitch"
		str=$(sed -n '/Has been switched/'p poolCheckCompAlgSwitch | grep -a -i "1")
	
		if [ "$str" ]; then
			isSwitched=1
			break
		fi
	} 
	done
	rm -f poolCheckCompAlgSwitch
}

checkHotpatch
if [ $isSwitched -eq 0 ]; then
	# check pass
	echo "True"
else
	# check fail
	echo "False"
fi
exit 0
