#!/bin/bash
MEM_4M_MIN_NUM=""
MEM_4M_TOTAL_NUM=0
EXP_SAS=PANGEA_V6R1C00_JBOD_SAS_EXP
EXP_PALM=PANGEA_V6R1C00_JBOF_PALM_EXP
PANGEA_LINK=`cat /proc/osp/bsp | awk '/Product/ {print $4}'`

function get_4m_mem_min_num()
{
    MEM_4M_MIN_NUM=16
    if [[ $PANGEA_LINK == $EXP_SAS || $PANGEA_LINK == $EXP_PALM ]] ; then
        MEM_4M_MIN_NUM=4
    fi
    OS_echo "eth_tool_mem_check.sh 4m mem need at least ${MEM_4M_MIN_NUM}"
}

function calu_num()
{
    val=$1
    num=$2
    let "res1=${val}*2**${num}" # 7*2**3 = 7*8 = 56
    echo $res1
}

# 获取4M连续内存的个数
function get_greater_4m_mem_num()
{
    MEM_4M_TOTAL_NUM=0
    node_num=$(cat /proc/buddyinfo | awk -F"Normal|DMA32" '{print $2}'|awk '{print NF}'|wc -l)
    max=$(cat /proc/buddyinfo | awk -F"Normal|DMA32" '{print $2}'|awk '{print NF}'|awk 'NR==1{print}')
    start=10 # 从4M的连续内存开始统计
    end=$(echo "${max}" - "${start}" | bc)
    buddy_values=$(cat /proc/buddyinfo | awk -F"Normal|DMA32" '{print $2}')
    OS_echo "$buddy_values"

    array2=(${buddy_values})
    for ((i=0; i<${node_num}; i++)); do
        row=$(echo "${array2[@]:$((start+i*$max)):${end}}")
        count=0
        final_vvv=0
        for value in $(echo "${row[@]}"); do
            vvv=$(calu_num ${value} ${count})
            count=$(echo "${count} +1 "|bc)
            final_vvv=$(echo "${final_vvv} + ${vvv}"|bc)
        done
        OS_echo "eth_tool_mem_check.sh 4m mem part$i is ${final_vvv}"
        MEM_4M_TOTAL_NUM=$((${MEM_4M_TOTAL_NUM} + ${final_vvv}))
    done

    OS_echo "eth_tool_mem_check.sh 4m mem total num is ${MEM_4M_TOTAL_NUM}"
}

function is_4m_mem_enough()
{
	local loop
	for ((loop=0; loop<3; loop++)); do
		get_greater_4m_mem_num
		if [ ${MEM_4M_TOTAL_NUM} -gt ${MEM_4M_MIN_NUM} ]; then
			OS_echo "eth_tool_mem_check.sh 4m mem check ok, ${MEM_4M_TOTAL_NUM} more than ${MEM_4M_MIN_NUM}."
		else
			OS_echo "eth_tool_mem_check.sh 4m mem not enough, ${MEM_4M_TOTAL_NUM} less than ${MEM_4M_MIN_NUM}."
			return 1
		fi
		sleep 1
	done
	return 0
}

function check_version()
{
    local versions=$(readlink /startup_disk/image/pkg_cur | awk -F '/' '{print $1}')
    local apollo_version=$(readlink /startup_disk/image/pkg_cur/apollo)
    OS_echo "eth tool mem check cur version is ${versions}"

    # 当前apollo版本不是A0/A1包，那么就一定不会有问题
    if [[ "${apollo_version}" != "apollo-1.0.0.1" && "${apollo_version}" != "apollo-1.1.1.0" ]]; then
        OS_echo "apollo_version:${apollo_version}"
        return 0
    fi

    # 当前版本是6.0.1/6.1.0/6.1.2/6.1.3才进行检查补丁
    # 编号和版本对应关系：7600506206 => 6.1.2; 7600503265 => 6.1.0; 7600302133 => 6.0.1; 7600509200 => 6.1.3
    if [[ "${versions}" != "7600506206" && "${versions}" != "7600503265" && "${versions}" != "7600302133" && "${versions}" != "7600509200" ]]; then
        return 0
    fi

    # 当前版本是6.0.1，如果是补丁版本为SPH31及以上则返回通过，否则继续检查
    # 当前版本是6.1.0，如果是补丁版本为SPH25及以上则返回通过，否则继续检查
    # 当前版本是6.1.2，如果是补丁版本为SPH16及以上则返回通过，否则继续检查
    # 当前版本是6.1.3，如果是补丁版本为SPH10及以上则返回通过，否则继续检查
    OS_echo "eth tool mem check patch."
    if [ -f "/startup_disk/image/${versions}/hotpatch/patch_cur/patch.yml" ]; then
        sphver=$(cat /startup_disk/image/${versions}/hotpatch/patch_cur/patch.yml | grep "patch_version" | awk -F "SPH" '{print $2}')
        OS_echo "mem check patch versions:${versions} sphver:$sphver"
        if [ -n "${sphver}" ]; then
            if [ "${versions}" == "7600506206" ]; then
                if [ ${sphver} -ge 16 ]; then
                    return 0
                fi
            elif [ "${versions}" == "7600503265" ]; then
                if [ ${sphver} -ge 25 ]; then
                    return 0
                fi
            elif [ "${versions}" == "7600302133" ]; then
                if [ ${sphver} -ge 31 ]; then
                    return 0
                fi
            else 
                if [ ${sphver} -ge 10 ]; then
                    return 0
                fi
            fi
        fi
    fi
    return 1
}

function check_4m_mem()
{
    check_version
    if [ $? != 0 ]; then
        get_4m_mem_min_num
        is_4m_mem_enough
        if [ $? != 0 ]; then
            OS_echo "eth_tool_mem_check.sh 4m mem need to repair."
            echo "False"
            exit 0
        fi
        OS_echo "eth_tool_mem_check.sh 4m check ok."
    fi
    echo "True"
    exit 0
}

check_4m_mem

