#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2018-2022. All rights reserved.


class CmdExecError(Exception):
    """
    命令执行异常
    """
    def __init__(self, cmd):
        self.cmd = cmd
        super(CmdExecError, self).__init__()
        return

    def __str__(self):
        return "An error occurred when running the command(%s)." % self.cmd


class UnExpectValueError(Exception):
    """
    返回值为不期望的值，比如阵列名称为空
    """
    def __str__(self):
        return "The return value is not within the expected range."
