#!/bin/bash
BSP_FILE="/proc/osp/bsp"
RPM_INSTALL_DIRECTORY_POLICY="/OSM/script/rpm_install_directory_policy.sh"

#x86环境没有产品背板型号，跳过该检查项
environment=$(uname -m)
if [ ${environment} == "x86_64" ]; then
  OS_echo "This is x86 environment."
  echo "True"
  exit 0
fi

#获取产品背板型号
G_PRODUCT_TYPE=$(grep "Model of products is:" $BSP_FILE | cut -d':' -f2)
if [ ${G_PRODUCT_TYPE} == "2200_16G_T" -o ${G_PRODUCT_TYPE} == "2220_16G_T" ]; then
  if [ ! -f $RPM_INSTALL_DIRECTORY_POLICY ]; then
    OS_echo "$RPM_INSTALL_DIRECTORY_POLICY is not existed."
    echo "False"
    exit 1
  fi
  echo "True"
  exit 0
fi

echo "True"
exit 0
