#!/usr/bin/python
# -*- coding: utf-8 -*-
import logging
import os
import sys
import subprocess
import shlex

USER_EXIST = r'id -u admin > /dev/null 2>&1'
USER_CMD = r"cat /etc/passwd | grep '/ISM/cli/ismcli' | grep ':0:root:'"
USER_LOGIN_CMD = "/ISM/cli/ismcli -u {0}"
TIMEOUT = 5 * 60

logging.basicConfig(level=logging.INFO,
                    filename="/OSM/log/cur_debug/messages",
                    format='[%(asctime)s][%(levelname)s][%(message)s][%(filename)s, %(lineno)d]',
                    datefmt='%Y-%m-%d %H:%M:%S')
BAY_CONFIG_DIR = "/OSM/conf/bay_config.ini"


def cli(command):
    sub_cmds = command.split(" | ")
    process = None
    for sub_cmd in sub_cmds:
        if process:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdin=process.stdout, stdout=subprocess.PIPE)
        else:
            process = subprocess.Popen(shlex.split(sub_cmd.strip()), stdout=subprocess.PIPE)
    out = process.communicate(timeout=TIMEOUT)
    return out[0].decode("utf-8")


def get_user_name():
    ret = os.system(USER_EXIST)
    if not ret:
        return 'admin'
    else:
        output = cli(USER_CMD)
        if not output:
            logging.warning("Get user failed")
            return ''
        return output.strip().split(':')[0]


def net_get_scout_type():
    scoutType = 2  # 默认为无效值2

    with open(BAY_CONFIG_DIR, "r") as f:
        lines = f.readlines()
        for line in lines:
            pos = line.find("ScaleOutType")
            if pos == -1:
                continue
            record = line.split("=", 1)
            scoutType = record[1].strip()
            break
    return scoutType


def net_get_product_version():
    user_name = get_user_name()
    if not user_name:
        logging.warning("NET_CHECK_SCALE_OUT: Get user failed.")
        return "NULL"
    cli_login_str = USER_LOGIN_CMD.format(user_name)
    version = "NULL"
    cmd_exec_dis_output_file_path = "/tmp/netgetproductversion"

    # 构造cli命令
    cli_cmd_str = "echo -e 'show system general' | " + cli_login_str + r" > " + cmd_exec_dis_output_file_path
    ret = os.system(cli_cmd_str)
    if ret:
        logging.warning("Cmd(%s) exec failed, ret %d.", cli_cmd_str, ret)
        # 删除临时文件
        shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
        os.system(shell_cmd_str)
        return "NULL"

    with open(cmd_exec_dis_output_file_path) as f:
        lines = f.readlines()
        for line in lines:
            pos = line.find("Product Version")
            if pos == -1:
                continue
            record = line.split(":", 1)
            version = record[1].strip()
            break
    shell_cmd_str = "rm -f " + cmd_exec_dis_output_file_path
    os.system(shell_cmd_str)
    return version


def main():
    try:
        logging.info("Start to check scale-out switch.")
        # 获取组网类型
        scoutType = net_get_scout_type()
        # 不是交换机组网直接返回
        if scoutType != "1":
            logging.info("Check scale-out switch success, scale-out type %s." % scoutType)
            print("True")
            return 0
        # 获取系统版本号
        version = net_get_product_version()
        version_list = ["6.1.0.SPH%d" % i for i in range(1, 9)]
        # 出错或者是指定检查的版本，则返回检查不通过
        is_v610_version = (version == "6.1.0") or (version[0:7] == "6.1.RC3")
        is_version_valid = (version in version_list) or (version == "NULL")
        if is_v610_version or is_version_valid:
            logging.info("Check scale-out switch success, version %s." % version)
            print("False")
            return 0
        print("True")
        logging.info("Check scale-out switch success, scale-out type %s, version %s." % (scoutType, version))
        return 0

    except Exception as e:
        logging.exception("Check scale-out switch failed: %s", e)
        print("False")
        return 1


if __name__ == '__main__':
    sys.exit(main())
