#!/bin/bash
# ********************************************** *****************************#
# File Name: pangea_patch_precheck.sh
# Description: PANGEA补丁包升级前检查
# Input: sh pangea_patch_precheck.sh       
# Output: TRUE/FALSE
# Author: PANGEA developer
# Created: 2019-12-17
# Function List： 升级前检查通过，允许打补丁，返回TRUE，否则返回FALSE
# For OceanStor Dorado V6 (TR5 only) Version :
# Name:  Enterprise storage product software
# Description:  Enterprise storage product software
# ReleaseTime:  20191030043038
# SYS:
# Version:  7600300365
# CompatibleVersionList:  "3300110000-5600209999"
# BlackVersionList:  "1200100000-3300109999"
# SpcVersion: 6.0.RC1
# VRCVersion: V600R003C00
# Components: 

# ****************************************************************************#
# 检查通过了不要设置result值，仅在检查不通过设置
result="TRUE"

# ***********************iSCSI*******************************#
# 该补丁仅需在Dorado V6 TR5 版本做升级前检查
wrong_oem_name="iqn.2006-08.com.huawei"
right_oem_name="oceanstor"
session_ininame=`echo -e "drvisi showremottgtinfo\nexit\n" |diagnose --auto |grep IniName |sed -n 1p`
seg1=`echo $session_ininame |awk -F : '{print $2}'`
seg2=`echo $session_ininame |awk -F : '{print $3}'`
if [ "$seg1" == "$seg2" ] && [ "$seg1" != "" ] ; then
	result="FALSE"
fi
# ***********************iSCSI*******************************#

echo $result
