#!/bin/bash
##pool后台均衡任务计数是否不为0,可能导致均衡挂住##
checkFlag=0
oneDpFlag=0
# Get all dpid
AllDiskPoolId=`(diagsh --attach="app_data_12" --cmd="pmgr showdp") | grep 0x|awk '{print substr($0,0,12)}'`
starttime=`date +'%Y-%m-%d %H:%M:%S'`
start_seconds=$(date --date="$starttime" +%s)
#check rebuildTask io count is zero
function checkTaskIoCount()
{
    num1=`diagsh --attach="app_data_12" --cmd="zone rebuild task io -p $1" | grep REB_DEL_DISKTASK|awk -F ':' '{print $7}'`
    num2=`diagsh --attach="app_data_12" --cmd="zone rebuild task io -p $1" | grep REB_DEL_REBTASK|awk -F ':' '{print $7}'`
    if [ -n "$num1" -a -n "$num2" ];then
        if [ $num1 -ne 0 -o $num2 -ne 0 ];then
            checkFlag=1
        else
            checkFlag=0
        fi
    fi
}

function checkOneDpCondition()
{
    #如果非0,则检查1min,直到检查到为0才退出，否则检查不通过,超时时间80s
    for ((i=0;i<60;i++))
    do {
        checkTaskIoCount $1
        if [ $checkFlag -eq 0 ]; then
            break
        fi
        sleep 1s
        curtime=`date +'%Y-%m-%d %H:%M:%S'`
        curtime_seconds=$(date --date="$curtime" +%s)
        let costime=$curtime_seconds-$start_seconds
        if [ $costime -gt 80 ]; then
            echo "False"
            exit 0
        fi
    }
    done
}


#遍历所有diskpool,如果有一个diskpool不满足,则检查不通过
for dpid in $AllDiskPoolId
do {
    checkOneDpCondition $dpid
    if [ $checkFlag -eq 1 ]; then
        oneDpFlag=1
        break
    fi
}
done


if [ $oneDpFlag -eq 1 ]; then
    # check fail
    echo "False"
else
    # check pass
    echo "True"
fi

exit 0


