#!/bin/bash

function check_version()
{
    local cur_version=$(head /startup_disk/image/pkg_cur/manifest.yml | grep " Version:"| sed s/[[:space:]]//g)
    cur_version=${cur_version##*:}
	# 当前版本是612才进行检测
    if [ "${cur_version}" != "7600506206" ]; then
        echo "True"
        exit 0
    fi
	# 当前补丁版本小于SPH52才进行检测
	if [ -f "/startup_disk/image/7600506206/hotpatch/patch_cur/patch.yml" ]; then
        sphver=$(cat /startup_disk/image/7600506206/hotpatch/patch_cur/patch.yml | grep "patch_version" | awk -F "SPH" '{print $2}')
        OS_echo "versions:${versions} sphver:$sphver"
        if [ -n "${sphver}" ]; then
            if [ ${sphver} -lt 52 ]; then
                echo "True"
                exit 0
            fi
        fi
    else
        echo "True"
        exit 0
    fi
    local dst_version=$(head /startup_disk/image/pkg_upd/manifest.yml | grep " Version:")
    dst_version=${dst_version##* }
    # 目标升级版本是615才进行检测
    if [ "${dst_version}" != "7600511219" ]; then
        echo "True"
        exit 0
    fi
    # 目标补丁版本小于SPH18检查不通过，否则通过
	if [ -f "/startup_disk/image/7600511219/hotpatch/patch_cur/patch.yml" ]; then
        sphver=$(cat /startup_disk/image/7600511219/hotpatch/patch_cur/patch.yml | grep "patch_version" | awk -F "SPH" '{print $2}')
        OS_echo "versions:${versions} sphver:$sphver"
        if [ -n "${sphver}" ]; then
            if [ ${sphver} -lt 18 ]; then
                echo "False"
                exit 1
            fi
        fi
    else
        echo "False"
        exit 1
    fi
}

check_version
echo "True"
exit 0
