#!/bin/bash
G_RET_SUCC=0
G_RET_FAIL=1

G_powerTemp=0
RESULT_STR=""


function PSU_echo()
{
    local loop=0
    while ((${loop}<10)); do
        if [ -S "/dev/log" ]; then
            OS_echo "$1"
            # echo "$1"
            break
        fi
        sleep 1
        let loop+=1
    done
}

function check_cur_version()
{
    local cur_pkg_ver=""
    
    # 获取当前版本
    if [ -f "/startup_disk/image/pkg_cur/manifest.yml" ]; then
        cur_pkg_ver=$(grep -iaE 'SpcVersion' /startup_disk/image/pkg_cur/manifest.yml |awk -F ": " '{print $2}')
    fi
    if [[ "x${cur_pkg_ver}" = "x6.0.1" ]]; then
        return ${G_RET_FAIL}
    fi
    
    return ${G_RET_SUCC} # 不检查
}

function literal_11_to_float()
{
    local value=$1
    local y=0
    local exp=$((${value} >> 11))
    G_powerTemp=0

    bit10=$((${value} & 0x0400))
    if [ ${bit10} -gt 0 ]; then
        y=$((${value} | 0xF800))
    else
        y=$((${value} & 0x07FF))
    fi

    bit4=$((${exp} & 0x10)) # 取符号位
    if [ ${bit4} -gt 0 ]; then
        G_powerTemp=$((${y} / (1 << (0x20 - ${exp})))) # 负数
    else
        G_powerTemp=$((${y} * (1 << ${exp}))) # 正数
    fi
    
    return
}

function check_power_health()
{
    RESULT_STR=""
    local PSU_02312HGY="30 32 33 31 32 48 47 59" # 电源编码
    local PSU_02312YKR="30 32 33 31 32 59 4b 52" # 电源编码
    local powerNum=2
    local retCheck=0
    frameType=$(grep -i "Product Name" /proc/osp/bsp |awk -F "is" '{print $2}')
    if [[ "${frameType}" =~ "HI1620_4U4C" ]]; then
        powerNum=4
    fi
    
    for ((fruID=0; fruID<powerNum; fruID++)); do
        psu_code=$(sudo ipmitool raw 0x32 0xbb ${fruID} 0x10 0 0 0x59 2>&1)
        psu_code=${psu_code:1:23}
        PSU_echo "[PangeaPowerProcessCheck]psu_info PSU${fruID}:${psu_code}"
        if [[ "x${psu_code}" != "x${PSU_02312HGY}" ]] && [[ "x${psu_code}" != "x${PSU_02312YKR}" ]]; then
            continue
        fi

        psu_temp=$(sudo ipmitool raw 0x32 0xbb ${fruID} 0x10 0 0 0x7a 0x8d 0x02 2>&1)
        cmd_ret=$?
        if [ "x${cmd_ret}" == "x0" ]; then
            data_l=$(echo $psu_temp|awk -F " " '{print$1}')
            data_h=$(echo $psu_temp|awk -F " " '{print$2}')
            literal_11_to_float 0x${data_h}${data_l}
            if [ ${G_powerTemp} -gt 75 ]; then
                retCheck=1
                if [[ "${RESULT_STR}" != "" ]]; then
                    RESULT_STR="${RESULT_STR}, "
                fi
                RESULT_STR="${RESULT_STR}PSU${fruID}"
            fi
        fi
    done
    
    return ${retCheck}
}

function psu_main()
{
    local retCode=0
    check_cur_version
    retCode=$?
    if [ ${retCode} -eq ${G_RET_SUCC} ]; then
        return ${G_RET_SUCC}
    fi
    check_power_health
    retCode=$?
    if [ ${retCode} -eq ${G_RET_SUCC} ]; then
        return ${G_RET_SUCC}
    fi
    return ${G_RET_FAIL}
}
psu_main
ret=$?
if [[ ${ret} -eq ${G_RET_SUCC} ]]; then # 相等
    echo "True"
    exit 0 
fi

echo "False"
echo "11001"
echo "Abnormal Power: ${RESULT_STR}"
exit 0

