#!/bin/bash

source /OSM/script/net_intf.sh
script_name=$(basename $0)
# **************************************************************************** #
# Function Name: check_remote_heart_beat_connect
# Description: 对端心跳检查
# Parameter:
# Return: 0表示成功，1表示失败
# **************************************************************************** #
function check_remote_heart_beat_connect()
{
    local remote_tmp_ip=$(OS_GetRemoteIBCIP)
    # 使用 read 命令将字符串按空格分割，并将结果存储到变量 ip1 和 ip2 中
    read ip1 ip2 <<< "$remote_tmp_ip"

    # 输出结果
    OS_echo "[${script_name}]:IP 1: $ip1"
    /OSM/script/os_get_file.sh "${ip1}" /OSM/conf/manifest.yml /tmp/
    ret=$?
    rm -f /tmp/manifest.yml
    if [ ${ret} -ne 0 ] ;then
      OS_echo "[${script_name}]:IP 2: $ip2"
      /OSM/script/os_get_file.sh "${ip2}" /OSM/conf/manifest.yml /tmp/
      ret=$?
      rm -f /tmp/manifest.yml
        if [ ${ret} -ne 0 ] ;then
        OS_echo "[${script_name}]:check heart beat failed"
        return 1
        fi
    fi
    return 0
}

# **************************************************************************** #
# Function Name: check_ccdb_status
# Description: CCDB状态检查
# Parameter:
# Return: 0表示成功，1表示失败
# **************************************************************************** #
function check_ccdb_status()
{
    /OSM/script/ccdb.sh -c showhealthy |grep -w normal >/dev/null
    ret=$?
    if [ ${ret} -ne 0 ];then
      OS_echo "[${script_name}]:ccdb showhealthy abnormal"
      return 1
    fi

    OS_echo "[${script_name}]:ccdb showhealthy normal"
    return 0
}

check_remote_heart_beat_connect
result_heart=$?
check_ccdb_status
result_ccdb=$?
sh /OSM/coffer_bin/upg_check/check_item/sysdisk_status_swm_check.sh
swm_result=$?

if [ ${result_heart} -eq 0 ] && [ ${result_ccdb} -eq 0 ] && [ ${swm_result} -eq 0 ]; then
    echo "True"
else
    echo "False"
fi
exit 0