# -*- coding: UTF-8 -*-
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.util import CheckTypeMsg
from cbb.frame.util import checkUtils


# 执行入口
def execute(dataDict, checkItemName):
    dataDict['checkType'] = "PRECHECK"
    resource = dataDict.get("resource")
    logger = dataDict.get("logger")
    lang = contextUtil.getLang(dataDict)
    flowchoiceNum = dataDict.get('flowchoice')
    CheckTypeMsg.checkTypeMsg(dataDict)
    checkItemName = str(checkItemName)

    curItemName = resource.getString(checkItemName)
    if curItemName == None or curItemName == '--':
        curItemName = baseUtil.getMsg(lang, checkItemName)
    if curItemName == None or curItemName == '--':
        curItemName = checkItemName

    # 选择忽略直接通过检查
    if 1 == flowchoiceNum:
        checkUtils.updateMsgAferIgnore(dataDict, checkItemName)
    else:
        # 更新上次显示信息
        checkUtils.updateMsgAferRetry(dataDict, checkItemName)
        # 刷新检查项界面
        updateUi(dataDict, checkItemName)
    logger.info(
        "[" + checkItemName + "] flowchoice[" + str(flowchoiceNum) + "," + str(dataDict.get("flowchoice")) + "]")
    return checkUtils.isIngnoreItemPassed(dataDict, dataDict['UI_PRECHCK_UPDATE_MSG'], "precheck", curItemName)


def updateUi(dataDict, checkItemName):
    lang = contextUtil.getLang(dataDict)
    resource = dataDict.get("resource")
    dev = dataDict.get("dev")
    uiObserver = dataDict.get("uiObserver")
    UI_PRECHCK_UPDATE_MSG = dataDict['UI_PRECHCK_UPDATE_MSG']

    itemName = checkUtils.getItemName(checkItemName, lang, resource)
    suggession = checkUtils.getPassMsg(checkItemName, "notpass", lang, resource)

    itemMsg = {
        "id": 0,
        ##检查项名称，类型String
        "name": itemName,
        ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        "status": 4,
        "ctrl": "ALL",
        ##修复建议
        "suggession": suggession,
        # 检查项暂停可进行的操作,7代表暂停+忽略+终止（不包含重试）
        "operate": 7,
    }

    UI_PRECHCK_UPDATE_MSG.get("checkitems").append(itemMsg)

    uiObserver.postMsg(dev, UI_PRECHCK_UPDATE_MSG)
