# -*- coding: UTF-8 -*-

import time

from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tool.protocol.tlv.exception import TLVException
from java.lang import Exception as JException

from cbb.frame.base import baseUtil, constants
from cbb.frame.rest import restData
from cbb.frame.rest.restUtil import Tlv2Rest
from cbb.frame.util import CheckTypeMsg
from cbb.frame.util import checkUtils
from cbb.frame.context import contextUtil


# 执行入口
def execute(dataDict):
    return InstallPatchCheck().execute(dataDict)


class InstallPatchCheck():

    def __init__(self):
        pass

    def execute(self, dataDict):
        dataDict['checkType'] = "POSTCHECK"
        CheckTypeMsg.checkTypeMsg(dataDict)

        dev = dataDict.get("dev")
        supportUpgPatch = dev.isSupportUpgradingPatch()
        upgPatchPath = dev.getUpgradeSetInfo().getUpgPatchPackageFile().getPath()
        if not supportUpgPatch or upgPatchPath == None or upgPatchPath == "":
            return (True, "")
        ##执行升级后检查
        checkUtils.updateItemProgress(dataDict, "InstallPatchProgresCheck", 1)
        result = self.progressCheck(dataDict)
        checkUtils.updateItemProgress(dataDict, "InstallPatchProgresCheck", 100)
        # 删除上次显示的进度条信息
        checkUtils.updateMsgAferRetry(dataDict, "InstallPatchProgresCheck")
        self.updateUi(result, dataDict)
        return checkUtils.isAllItemsPassed(dataDict, dataDict['UI_POSTCHCK_UPDATE_MSG'], "postcheck")

    """
        查询升级检查项，并更新界面
    """

    def updateUi(self, rec, dataDict):
        resource = dataDict.get("resource")
        dev = dataDict.get("dev")
        uiObserver = dataDict.get("uiObserver")
        logger = dataDict.get("logger")
        UI_POSTCHCK_UPDATE_MSG = dataDict['UI_POSTCHCK_UPDATE_MSG']

        resState = rec[0]
        suggession = rec[1]
        logger.info("install patch result:%s" % (resState))

        if resState == True:
            # 补丁安装成功
            itemState = 3
            suggession = resource.getString("InstallPatchProgresCheck.pass")
        else:
            # 执行出错
            itemState = 4

        itemMsg = {
            "id": 0,
            ##检查项名称，类型String
            "name": resource.getString("InstallPatchProgresCheck"),
            ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
            "status": itemState,
            "ctrl": "ALL",
            ##修复建议
            "suggession": suggession
        }

        UI_POSTCHCK_UPDATE_MSG.get("checkitems").append(itemMsg)

        uiObserver.postMsg(dev, UI_POSTCHCK_UPDATE_MSG)

    def checkUpgradeStatusIsNomarl(self, status):
        """
        功能说明：检查升级中的状态是不是正常的
        输入：升级状态
        输出：bool检查结果False/True
        """
        ###检查升级状态是不是处于回退阶段
        if constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_ROLLBACKING == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_ROLLBACK_SUCCESS == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_ROLLBACK_FAIL == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_FAIL == status:
            return False

        return True

    def checkUpgradeStatusIsUpgrade(self, status):
        """
        功能说明：检查升级中的状态是不是升级中和升级成功
        输入：升级状态
        输出：bool检查结果False/True
        """
        ###检查升级状态是否处于升级中和升级成功
        if constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPDING == status or constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_SUCCESS == status:
            return True
        return False

    """
        执行升级前检查，并更新界面
    """

    def progressCheck(self, dataDict):
        resource = dataDict.get("resource")
        logger = dataDict.get("logger")
        rest = contextUtil.getRest(dataDict)

        dev = dataDict.get("dev")
        hotPathPkgVersion = dev.getUpgradeSetInfo().getUpgPatchPkgVersion()
        logger.info("hotPathPkgVersion:" + str(hotPathPkgVersion))
        errMsg = ''
        errorInfo = ''

        DEVEICE_UP_FALLD_BASE_VALUE = 0  # 轮询计数器

        # 在线升级类型都为在线升级
        modelNum = 0
        # 升级包类型为热补丁
        msgType = constants.TLV_PACKAGE_TYPE.HOT_PATCH_PKG
        params = []
        param0 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_MSGTYPE, UnsignedInt32(msgType))
        param1 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_NIDLIST, "")
        param2 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_ACTIVETYPE, UnsignedInt32(modelNum))
        params.extend([param0, param1, param2])

        status = None
        # 查询是否启动安装补丁（2分钟超时）
        BEFORE_PATCH_BASE_VALUE = 0
        while True:
            # 查询升级进度
            BEFORE_PATCH_BASE_VALUE = BEFORE_PATCH_BASE_VALUE + 1
            if BEFORE_PATCH_BASE_VALUE > constants.BEFORE_PATCH_POLL_TIMES:
                logger.info("check patch start is timeout, the time:%s." % str(BEFORE_PATCH_BASE_VALUE))
                return (False, resource.getString("install.hotpatch.failed"))  # 安装补丁失败

            recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_LST_SYS_PROGRESS, params)
            rec = recs[0]
            if (None != rec):
                logger.info("upgrade process:" + str(rec))
                status = Tlv2Rest.getRecordValue(rec, restData.Upgrade.UpdLstSysProgress.CMO_UPD_SYS_STEP_TASK_STATUS)
            if status == constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPDING:
                break
            if status == constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_SUCCESS:
                # 查询补丁版本是否为最新的
                flag, hotPatchCurVersion = self.getHotPatchVer(rest)
                if hotPathPkgVersion == hotPatchCurVersion:
                    return (True, "")
            baseUtil.safeSleep(constants.BEFORE_PATCH_POLL_INTERVAL)
            checkUtils.updateItemProgressNoDelay(dataDict, "InstallPatchProgresCheck", BEFORE_PATCH_BASE_VALUE)

        checkUtils.updateItemProgress(dataDict, "InstallPatchProgresCheck", 20)

        while (constants.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_UPD_SUCCESS != status):
            try:
                DEVEICE_UP_FALLD_BASE_VALUE = DEVEICE_UP_FALLD_BASE_VALUE + 1
                if DEVEICE_UP_FALLD_BASE_VALUE > constants.UPGRADE_PACKAGE_POLL_TIMES:
                    logger.info("Upgrade patch is timeout, the time:%s." % str(DEVEICE_UP_FALLD_BASE_VALUE))
                    return (False, resource.getString("install.hotpatch.failed"))
                # 查询升级进度
                recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_LST_SYS_PROGRESS, params)
                rec = recs[0]
                if (None != rec):
                    logger.info("upgrade process:" + str(rec))
                    status = Tlv2Rest.getRecordValue(rec,
                                                     restData.Upgrade.UpdLstSysProgress.CMO_UPD_SYS_STEP_TASK_STATUS)
                    process = Tlv2Rest.getRecordValue(rec,
                                                      restData.Upgrade.UpdLstSysProgress.CMO_UPD_SYS_STEP_STEP_PERCENT)
                    checkUtils.updateItemProgressNoDelay(dataDict, "InstallPatchProgresCheck", process)
                ###升级状态检查
                if not self.checkUpgradeStatusIsUpgrade(status):
                    ##查询升级详情
                    logger.info("system status is not in upgrading, status is:" + str(status))
                    if not self.checkUpgradeStatusIsNomarl(status):
                        logger.info("system status is not normal.")
                    ##查询升级详细信息
                    recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_LIST_DETAILINFO, params=[])
                    itemNum = len(recs)
                    for index in range(0, itemNum):
                        rec = recs[index]
                        nameKey = Tlv2Rest.getRecordValue(rec, restData.Upgrade.UpdListDetaiInfo.NAME_KEY)
                        errorKey = Tlv2Rest.getRecordValue(rec, restData.Upgrade.UpdListDetaiInfo.ERROY_KEY)
                        itemState = Tlv2Rest.getRecordValue(rec, restData.Upgrade.UpdListDetaiInfo.ITEM_STATE)
                        errorKeyList = errorKey.split(":")
                        errorKeyListLen = len(errorKeyList)

                        if "1" != itemState:  # 表示没有失败
                            continue
                        try:
                            if errorKeyListLen >= 2:
                                firstCommaLoc = errorKey.find(":")  # 第一个冒号前为key值，后面为错误详情参数，此方法避免参数中存在冒号
                                msgKey = errorKey[:firstCommaLoc]
                                errParam = errorKey[firstCommaLoc + 1:]  # 冒号之后为错误参数信息
                                parseErrorInfoRet = self.parseAtomInfo(errParam)
                                logger.info("msgKey: %s parseErrorInfoRet:%s" % (msgKey, parseErrorInfoRet))
                                errorInfo = resource.getString(msgKey) % parseErrorInfoRet
                            else:
                                errorInfo = resource.getString(errorKey)
                            errMsg = errorInfo + '\n' + resource.getString("install.hotpatch.failed")
                            return (False, errMsg)
                        except:
                            logger.info("parse atom info failed:%s" % errorInfo)
                            errMsg = resource.getString("install.hotpatch.failed")
                            return (False, errMsg)
                baseUtil.safeSleep(constants.UPGRADE_PACKAGE_POLL_INTERVAL)
            except Exception as e:
                logger.error("device upgrade query progress error" + str(e))
                # 第一个原子执行时间较长，会抛出该错误码，继续执行查询
                if isinstance(e, TLVException):
                    if constants.OM_OPERATE_FAIL_CODE == e.getErrorId():
                        continue
                if not self.checkDevReboot(dataDict):
                    errMsg = resource.getString("upgrade.rebooterr.2")
                    return (False, errMsg)
                else:
                    continue

        # 查询补丁版本是否为最新的
        flag, hotPatchCurVersion = self.getHotPatchVer(rest)
        if hotPathPkgVersion != hotPatchCurVersion:
            return (False, resource.getString("install.hotpatch.failed"))
        return (True, "")

    def getHotPatchVer(self, rest):
        params = []
        msgParam0 = (restData.Upgrade.LstVer.CMO_VER_PACKAGE_TYPE, UnsignedInt32(3))
        params.append(msgParam0)

        recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_LST_VER, params)
        rec = recs[0]
        hotPatchVersion = Tlv2Rest.getRecordValue(rec, restData.Upgrade.LstVer.CMO_VER_CUR_VERSION)
        if not hotPatchVersion:
            return (True, '--')
        return (True, hotPatchVersion)

    def checkDevReboot(self, dataDict):
        """
        功能说明：等待设备重启完成后，服务正常启动，重新建立连接
        输入：工具上下文
        输出：bool连接结果False/True
        """
        # 使用cli命令打开TLV连接通道。
        logger = dataDict.get("logger")

        startTime = time.clock()
        for times in range(0, constants.UPGRADE_REBOOT_AFTER_CONNECT_TIMES):
            try:
                contextUtil.getRest(dataDict)
                logger.info('reboot device successfully.')
                return True
            except (Exception, JException), e:
                logger.error(
                    'Connect device exception:%s. used time:%s.' % (unicode(e), unicode(time.clock() - startTime)))
                baseUtil.safeSleep(constants.UPGRADE_REBOOT_AFTER_CONNECT_INTERVAL)

        logger.info('reboot device failed.')
        return False

    def parseAtomInfo(self, errParam):
        """
                描述：转换升级原子信息
                原子错误信息格式：参数1,参数2
                参数之间用逗号隔开
                参数：errParam：错误信息字符串
                返回：解析后的错误信息参数元组
        """
        errDetailParas = errParam.split(",")
        return tuple(errDetailParas)
