# -*- coding: UTF-8 -*-
from cbb.frame.cli import cliUtil
from cbb.frame.ruleConfig import common

import traceback
from cbb.frame.cli.execute_on_all_controllers import (
    ExecuteOnAllControllers,
    ResultType,
    FuncResult,
    ExeOnAllCtrlException,
)


class CheckDeamonProcess:
    def __init__(self, context, logger, lang, cli):
        self.all_ret_list = list()
        self.error_msg_list = list()
        self.logger = logger
        self.lang = lang
        self.cli = cli
        self.exec_context = context

    def execute_check(self):
        """
        @summary:	系统daemon进程检查
        @param cli: CLI连接
        @return: (通过标识, CLI回显信息, 错误信息) as (boolean, string, string)
        """

        try:
            fun_result = self.check_daemon(self.exec_context)
            self.all_ret_list = fun_result.cli_ret
            if fun_result.result_type == ResultType.SUCCESS:
                return fun_result.result_type, ""
            elif fun_result.result_type == ResultType.NOT_FINISHED:
                return fun_result.result_type, fun_result.err_msg
            self.logger.info(
                "err node list:{}".format(
                    ",".join(self.exec_context._err_msg_list)
                )
            )
            err_controller_list = self.get_err_meg_controller()

            self.logger.info(
                "err Controller List:{}".format(",".join(err_controller_list))
            )
            err_msg = common.getMsg(
                self.lang,
                "daemon.process.check.not.pass",
                ",".join(err_controller_list),
            )
            return fun_result.result_type, err_msg
            # 查询产品型号
        except ExeOnAllCtrlException as e:
            if "PwdCLIOverrunException" in e.exception_msg:
                return ResultType.NOT_FINISHED, "login.clis.overrun.info"
            return ResultType.NOT_FINISHED, ""
        except Exception:
            self.logger.error(str(traceback.format_exc()))
            return ResultType.NOT_FINISHED, ""

    @staticmethod
    @ExecuteOnAllControllers
    def check_daemon(exec_context):
        current_ctrl_id = exec_context.cur_ctrl_id
        cli = exec_context.dev_info.cli
        lang = exec_context.lang
        try:
            flag, cli_ret, err_msg = cliUtil.enterDeveloperMode(cli, lang)
            exec_context._cli_ret_list.append(cli_ret)
            if not flag:
                err_msg = err_msg if err_msg else cliUtil.getMsg(lang, "cannot.enter.to.developer.model.network")
                return FuncResult(ResultType.NOT_FINISHED, "", err_msg, False)
            cmd = "ps -C daemon"
            flag, cli_ret, err_msg = cliUtil.excuteCmdInMinisystemModel(
                cli, cmd, lang
            )
            exec_context._cli_ret_list.append(cli_ret)
            if flag is not True:
                return FuncResult(ResultType.NOT_FINISHED, "", err_msg, False)
            daemon_info = "\n".join(list(filter(
                lambda x: "ps -C daemon" not in x,
                cli_ret.splitlines()
            )))
            if "daemon" not in daemon_info:
                exec_context._err_msg_list.append(current_ctrl_id)
                return FuncResult(ResultType.FAILED, "", "")
            return FuncResult(ResultType.SUCCESS, "", "")
        except Exception:
            # 如果执行命令过程发生异常，则此次查询忽略
            exec_context.logger.error(str(traceback.format_exc()))
        finally:
            cliUtil.enterCliModeFromSomeModel(cli, lang)

    def build_controller_map(self):
        """
        控制器名称为
        构建controller名称
        :return:
        """
        node_and_controller_map = dict()
        is_qry_succ, present_node_id_list = self.get_engine_node_id_list()
        check_ret = cliUtil.getControllerIdList(self.cli, self.lang)
        if is_qry_succ is True and check_ret[0] is True:
            node_and_controller_map = dict(
                zip(present_node_id_list, check_ret[1])
            )
            return True, node_and_controller_map
        else:
            return False, node_and_controller_map

    def get_err_meg_controller(self):
        error_controller_list = list()
        flag, node_and_controller_map = self.build_controller_map()
        self.logger.info(
            "node_and_controller_map:{}".format(node_and_controller_map)
        )
        err_node_list = filter(None, self.exec_context._err_msg_list)
        for node_id in err_node_list:
            error_controller_list.append(
                node_and_controller_map.get(node_id, "--")
            )
        return error_controller_list

    def get_engine_node_id_list(self):
        """
        @summary: 获取当前引擎的全部健康节点信息，当前节点信息。
        @param cli: cli连接
        @return: current_engine_ctrl_id_list)
            current_engine_ctrl_id_list: 当前引擎的全部健康节点信息
        """
        # 获取当前节点信息，当前引擎的全部节点信息。
        cmd = "sys showcls"
        # 当前节点
        current_engine_ctrl_id_list = []
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(
            self.cli, cmd, True, self.lang
        )
        if flag is not True:
            self.logger.info("get node info Failed. errMsg: %s" % errMsg)
            return False, current_engine_ctrl_id_list

        engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

        for engineInfo in engineInfoDictList:
            ctrlNodeId = engineInfo.get("id", "")
            if ctrlNodeId == "":
                continue
            current_engine_ctrl_id_list.append(ctrlNodeId)
        return True, current_engine_ctrl_id_list
