# coding: utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import time

import com.huawei.ism.tool.obase.entity.DevNode as DevNode


def get_java_dev(dest_ip, dev):
    """
    将连接设备的信息封装为java的DevNode对象
    :param dest_ip: 目标IP
    :param dev: 原始dev
    :return: 变更了SN的新dev
    """
    java_dev = DevNode()
    java_dev.setPort(dev.getPort())
    java_dev.setSshForwardList(dev.getSshForwardList())
    java_dev.setSocks5Proxy(dev.getSocks5Proxy())
    java_dev.setLoginUser(dev.getLoginUser())
    device_sn = dev.getDeviceSerialNumber()
    # 此SN只是用来作为框架识别不同的SSH连接，不是真实的设备SN
    device_sn = device_sn + str(time.time())
    java_dev.setDeviceSerialNumber(device_sn)
    java_dev.setIp(dest_ip)
    return java_dev


def build_conn(ip_str, dev_obj):
    """
    @summary: building new SSh  connection to destination
    @warning:  only 4 connections at most  exists at the same time!
    @return:  status, sshCon(None if not exists!)
    :param ip_str: 目标IP地址
    :param dev_obj: 上下文，取devnode
    :return:  ssh连接
    """
    context = dev_obj.get("context")
    if not context:
        return None
    return dev_obj.get("sshManager").getSshConnection(get_java_dev(ip_str, dev_obj.get("devNode")))