# -*- coding: UTF-8 -*-

from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil
from cbb.business.operate.expansion import common
from cbb.business.operate.expansion.common import \
    get_expansion_config_data, delete_temp_config_data
from cbb.business.operate.expansion.scm import check_expand_scm
from cbb.business.operate.expansion import config


def saveData(context, param):
    """
    本步骤完成时的回调，用于校验和保存数据
    :param context: 上下文
    :param param: 回调参数
    :return: None
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    logger.logInfo("param={}".format(param))
    delete_temp_config_data(logger, "expansionSCM.dat")
    cli = contextUtil.getCli(context)

    all_scm_disks = context[
        "allInput_selectExpandScm_selectScmTab"]
    selected_disk_locations = get_selected_scm_locations(all_scm_disks)
    logger.logInfo("selected_disk_locations:{}".format(selected_disk_locations))

    if not selected_disk_locations:
        contextUtil.handleFailure(
            context, common.get_error_result(lang, "expand.cache.no.select.disk"))
        return
    flag, _, err_msg = check_expand_scm.execute(
        cli, lang, logger, context, free_disk_list=selected_disk_locations,
        check_type="select_disk")
    logger.logInfo("flag={}, err_msg={}".format(flag, err_msg))
    if not flag:
        contextUtil.handleFailure(
            context, {"flag": False, "errMsg": err_msg, "suggestion": ""})
        return
    contextUtil.setItem(
        context, "scm_disk_locations", ",".join(selected_disk_locations))
    contextUtil.handleSuccess(context)
    logger.logPass()
    return


def get_selected_scm_locations(all_datas):
    """
    :param all_datas: 表格所有数据
    :return: 所有选择的硬盘的locations
    """
    all_disks = common.jsonArray2DictList(all_datas)
    if all_datas is None:
        return []
    scm_disk_locations = []
    for disk in all_disks:
        if disk.get("_self_marked", "") == "true":
            scm_disk_locations.append(disk["location"])
    return scm_disk_locations


def get_disk_from_file(logger):
    """
    从评估步骤记录的配置文件中获取选择的硬盘Locations
    :param logger: logger
    :return: disk locations
    """
    select_scm_info = get_expansion_config_data(logger, "expansionSCM.dat")
    logger.logInfo("select_scm_info={}".format(select_scm_info))

    location = select_scm_info.get("disk_location") \
        if select_scm_info else None
    if location:
        return location.split(",")
    return []


def initData(context, param):
    """
    表格初始化回调方法
    :param context: 上下文
    :param param: 回调参数
    :return: None
    """
    logger = common.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    logger.logInfo("param={}".format(param))
    try:
        cli = contextUtil.getCli(context)
        flag, pool_id, _, _ \
            = cliUtil.get_smart_cache_pool_for_nas(
                cli, lang, context.get("logger"))

        if pool_id == "-1":
            contextUtil.handleFailure(
                context, common.get_error_result(
                    lang, "expand.cache.no.cache.pool"))
            return

        flag, disk_info_list, _, _ = \
            cliUtil.get_free_scm_disk(cli, lang, context.get("logger"))

        if not disk_info_list:
            contextUtil.handleFailure(
                context, common.get_error_result(
                    lang, "expand.cache.no.scm.disk"))
            return

        contextUtil.setItem(context, "smart_cache_pool_id", pool_id)
        init_table_data(context, disk_info_list, lang, logger)
        contextUtil.handleSuccess(context)
        logger.logPass()
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return


def init_table_data(context, disk_info_list, lang, logger):
    scene = contextUtil.getSceneArgStrValue(
        context, config.SCENE_EXPAND_KEY)
    select_disks = []
    if scene == config.SCENE_EXPAND_SCM:
        select_disks = get_disk_from_file(logger)
    logger.logInfo("select disks={}".format(select_disks))
    scm_disks = [{
        "location": disk.get("location"),
        "marked": "true" if disk.get("location") in select_disks else "false",
        "healthStatus": disk.get("healthStatus"),
        "runningStatus": disk.get("runningStatus"),
        "diskType": disk.get("type"),
        "capacity": disk.get("capacity")
    } for disk in disk_info_list]
    context["retData_selectScmTab"] = common.dictList2JsonArray(scm_disks)
    if not scm_disks:
        context["#retMsg_selectScmTab"] \
            = {"no.data": "bizpackage.info.no.scm.disk"}
