# -*- coding: UTF-8 -*-
from BaseFactory import *

'''
Description: 通用类：Tlv结果值定义类：从数字到字符串
Create Date: 2014-02-26
'''


class TlvStr():
    ________TEST_ZONE________ = None

    '''
    Function: 模块测试入口，供TestFactory调用
    '''

    @staticmethod
    def testEntrance(context):
        log.debug(context, "enter sub test function.")

        return

    ________FUNC_ZONE________ = None

    '''
    Function: 据数值获取TlvStr中的枚举字符串
    Params:
        lang: 语言类型，包括两种取值：zh,en
        enum: 枚举字典
        keyId: 待获取字符串的key
        defaultReturn: 如果keyId不存在时的返回值
    Return: 
        enum[keyId]=正常返回值
        "ERR: Invalid Input Parametors!"=异常返回值：参数错误
        defaultReturn=异常返回值：keyId在enum中找不到
    '''

    @staticmethod
    def getStrByLang(lang, enum, keyId, defaultReturn='--'):
        # 参数校验：若enum不为字典，或keyId不为数值，则直接返回
        if type(enum) != dict or type(keyId) != int:
            return "ERR: Invalid enum or keyId Parametor!"
        if "zh" != lang and "en" != lang:
            return "ERR: Invalid language Parametor!"
        # 初始化返回值为默认值
        retValue = defaultReturn
        # 若keyId存在，则按key获取字符串并分割为中英文
        langVals = []
        if keyId in enum:
            langVals = str(enum[keyId]).split('||')
            # 返回指定语言描述
            if "en" == lang:  # 英文
                retValue = langVals[0]
            else:  # 中文
                retValue = langVals[1]  # "xyz中文123"#
        # 编码转换并返回
        '''
        140303-Question-Python字符编码原理：
        1、python3以下的版本中，非英文（含中文）字符编码间的转换需要使用unicode作为中间过渡编码类型，
                             即若源编码为utf-8，目标编码为gbk，则需先使用decode函数将utf-8编码转换为unicode编码，再通过encode函数转为gbk编码。
        2、在本文件中，文件头部的注释内容指定了本文件内容的编码格式为utf-8，即下面的枚举定义也为utf-8，为了UI上能正确识别和显示，必须将其转换为unicode编码。 
        '''
        retValue = retValue.decode('utf-8')
        return retValue

    @staticmethod
    def getStrEn(enum, keyId, defaultReturn='--'):
        return TlvStr.getStrByLang("en", enum, keyId, defaultReturn)

    @staticmethod
    def getStrZh(enum, keyId, defaultReturn='--'):
        return TlvStr.getStrByLang("zh", enum, keyId, defaultReturn)

    '''
    Function: 据数值获取TlvStr中的枚举字符串
    Params:
        enum: 枚举字典
        keyId: 待获取字符串的key
        lang: 语言类型，包括两种取值：zh,en
        defaultReturn: 如果keyId不存在时的返回值
    Return: 
        enum[keyId]=正常返回值
        "ERR: Invalid Input Parametors!"=异常返回值：参数错误
        defaultReturn=异常返回值：keyId在enum中找不到
    '''

    @staticmethod
    def getStr(context, enum, keyId, defaultReturn='--'):
        return TlvStr.getStrByLang(context.get('lan'), enum, keyId, defaultReturn)

    '''
    Function: 获取命令字的描述信息
    '''

    @staticmethod
    def getCmdStr(intCmdId, defaultReturn='???'):
        if intCmdId in TlvStr.Cmd:
            return TlvStr.Cmd[intCmdId]
        else:
            return defaultReturn

    ______ZONE_STANDARD_STR_DEFINE______ = None

    # warning: the definition as following can not be modified.

    Cmd = {
        55834591232: 'CREATE',  # 创建对象
        55834583040: 'MODIFY',  # 修改对象
        55834574848: 'GET',  # 查询单个对象
        55834624000: 'GET_BATCH_NEXT',  # 批量查询对象
        55834599424: 'DELETE',  # 删除对象
        55834632192: 'COUNT',  # 查询对象的数量
        55834615808: 'ASSOCIATE',  # 关联查询对象
        55834595328: 'CREATE_ASSOCIATE',  # 建立关联
        55834603520: 'REMOVE_ASSOCIATE',  # 移除关联
        55834583049: 'START',  # 开始任务
        55834583050: 'STOP',  # 停止任务
        55834583051: 'PAUSE',  # 暂停任务
        55834583052: 'CONTINUE',  # 继续任务
        55834583053: 'GET_NEXT_AVAILABLE_ID',  # 查询下一个可用的ID号
        57176752129: 'CLI_CMD_START',  # CLI专用命令字起始位置
        57176752129: 'CLI_CMD_END',  # CLI专用命令字结束位置（框架不允许使用）
        55849058305: 'SYNCHRONIZE_CONSISTENCY_GROUP',  # 同步一致性组
        55849058306: 'SWITCH_GROUP_ROLE',  # 一致性组主从切换
        55849058307: 'DO_SWITCHROLE_GROUP',  # 一致性组强制主从切换
        55849058308: 'ADD_MIRROR',  # 向一致性组添加远程复制
        55849058309: 'DEL_MIRROR',  # 删除一致性组中的远程复制
        55849058310: 'DO_DEL_MIRROR',  # 强制删除一致性组中的远程复制
        55849058311: 'SPLIT_CONSISTENCY_GROUP',  # 分裂一致性组
        55849058312: 'START_VERIFY',  # 接口中有该操作，但是目前代码中并不会用到，请东哥确认是否需要该命令字
        55848271873: 'INTF_MODULE_POWER_ON',  # 上电
        55848271874: 'INTF_MODULE_POWER_OFF',  # 下电
        55849648129: 'MODIYF_IOCLASS_SWITCH',  # 修改IO分类开关
        55850500097: 'CONNECT_ISCSI_TARGET',  # 连接iSCSI链路
        55850500098: 'DISCONNECT_ISCSI_TARGET',  # 断开iSCSI链路
        55850500099: 'CREATE_AND_CONNECT',  # 创建并连接iSCSI TGT
        55850500100: 'DISCONNECT_AND_DELETE',  # 断开并删除iSCSI TGT
        55850500101: 'GET_BATCH_NEXT_ISCSI_TGT',  # 查询所有iSCSI链路目标器详细信息
        55850500102: 'GET_ISCSI_TGT',  # 查询iSCSI链路目标器详细信息
        55850500103: 'MODIFY_ISCSI_TGT',  # 修改iSCSI链路目标器信息
        55849320449: 'ADD_FCLINK_TO_REMOTE_DEVICE',  # 将FC链路添加给远端设备
        55849320450: 'REMOVE_FCLINK_FROM_REMOTE_DEVICE',  # 从远端设备移除FC链路
        55848927233: 'STOP_HYPERCOPY',  # 停止LUN拷贝
        55848927234: 'PAUSE_HYPERCOPY',  # 暂停LUN拷贝
        55848927235: 'CONTINUE_HYPERCOPY',  # 继续LUN拷贝
        55848927236: 'MARK_HYPERCOPY',  # 给增量LUN拷贝打标签
        55848927237: 'ADD_TGT_LUN',  # 增加目标LUN
        55848927238: 'START_HYPERCOPY',  # 启动LUN拷贝
        55849451521: 'GET_LUNCOPY_MEMBERLUN',  # 查询LUN Copy 成员LUN信息
        55849451522: 'GET_BATCH_NEXT_LUNCOPY_MEMBERLUN',  # 批量查询LUN拷贝成员LUN信息(GETBATCH)
        55849451523: 'REMOVE_LUNCOPY_MEMBERLUN',  # 删除LUN Copy 成员LUN
        55849451524: 'GET_HYPERCOPY_MEMLUN_INFO',  # 查询成员LUN信息
        55849451525: 'GET_BATCH_NEXT_HYPERCOPY_MEMLUN_INFO',  # 批量查询LUN拷贝成员LUN信息(GETBATCH)
        55849451526: 'GET_BATCH_NEXT_AVAILABLE_LUNS',  # 批量查询LUNCopy候选成员LUN
        55849451527: 'GET_BATCH_NEXT_AVAILABLE_LUNS_BY_SOURCELUN',  # 批量查询LUNCopy候选成员LUN
        55836409857: 'GET_NEXT_FITTING_MIRROR',  # 查询符合条件加入一致性组的远程复制(NEXT)
        55849385985: 'SPLIT_HYPERMIRROR',  # 分裂
        55849385986: 'SYNCRONIZE_HYPERMIRROR',  # 同步
        55849385987: 'SWITCHROLE_HYPERMIRROR',  # 主从切换
        55849385988: 'DO_SWITCHROLE_HYPERMIRROR',  # 强制主从切换
        55849385989: 'MODIFY_REMOTE_REPLICATION_MEMBER_LUN',  # 修改远程复制成员LUN属性
        55849385990: 'GET_REMOTE_REPLICATION_MEMBER_LUN',  # 查询远程复制成员LUN的详细信息
        55849385991: 'GET_BATCH_NEXT_REMOTE_REPLICATION_MEMBER_LUN',  # 批量查询远程复制成员LUN的详细信息
        55849385992: 'GET_BATCH_NEXT_MIRROR_LUN_CANUSE',  # 查询可以用来创建远程复制LUN(NEXT)/查询可以用来加入一致性组的Pair
        55849385993: 'GET_BATCH_NEXT_MIRROR_LUN_DETAIL',  # 查询远程复制成员LUN的详细信息信息
        55849385994: 'ADD_SECONDARY_LUN',  # 增加远程复制从LUN
        55849385995: 'REMOVE_SENCONDARY_LUN',  # 删除远程复制从LUN
        55849385996: 'DO_REMOVE_SENCONDARY_LUN',  # 强制删除远程复制从LUN
        55849385997: 'START_VERIFY_SENCONDARY_LUN_CONF',  # 接口中有该操作，但是目前代码中并不会用到，请东哥确认是否需要该命令字
        55836344321: 'CREATE_HYPERIMAGE_COPY',  # 创建虚拟快照副本
        55836344322: 'ENABLE_HYPERIMAGE',  # 重建虚拟快照
        55836344323: 'DISABLE_HYPERIMAGE',  # 停用虚拟快照
        55836344324: 'ACTIVE_HYPERIMAGE',  # 激活虚拟快照
        55836344325: 'ROLLBACK_HYPERIMAGE',  # 回滚虚拟快照
        55836344326: 'CANCEL_ROLLBACK_HYPERIMAGE',  # 取消回滚虚拟快照
        55848730625: 'GET_GLOBLE_MIGRATE_LEVEL',  # 查询全局迁移速率
        55848730626: 'SET_GLOBLE_MIGRATE_LEVEL',  # 设置全局迁移速率
        55848730627: 'ADD_ALL_REMAIN_DISK_TO_POOL',  # 添加所有剩余磁盘到pool中
        55848730628: 'EXPAND_POOL',  # POOL扩展磁盘
        55848730629: 'MODIFY_MIGRATIONMODE',  # 修改迁移模式
        55848730630: 'MODIFY_MIGRATIONTIME',  # 修改迁移时刻表
        55848730631: 'OPEN_OR_CLOSE_MIGRATION',  # 开启或关闭立即迁移
        55848730632: 'PAUSE_OR_RESUME_MIGRATION',  # 暂停/恢复迁移
        55848730633: 'SHOW_POOL_ANALYSIS_DEFAULT_PROPERTY',  # 显示Pool的预测分析默认属性
        55850565633: 'GET_INACTIVE_LICENSE_HEAD',  # 查询未激活License文件头信息
        55850565634: 'GET_LICENSE_HEAD',  # 查询已激活License文件头信息
        55850565635: 'GET_INACTIVE_LICENSE',  # 查询未激活License信息
        55850565636: 'GET_LICENSE',  # 查询已激活License信息
        55850565637: 'GET_LICENSE_FUNC',  # 批量查询License功能配置项
        55850565638: 'GET_INACTIVE_LICENSE_FUNC',  # 批量查询未激活License功能配置项
        55850565639: 'GET_LICENSE_RESOURCE',  # 批量查询License资源配置项
        55850565640: 'GET_INACTIVE_LICENSE_RESOURCE',  # 批量查询未激活License资源配置项
        55850565641: 'GET_LICENSE_INFO',  # 单个查询License使用情况
        55850565642: 'GETBATCH_LICENSE_INFO',  # 批量查询License使用情况
        55850565643: 'USER_IMPORT_LICENSE',  # 激活License
        55850565644: 'OM_MSG_OP_GET_LICENSE_PATH',  # 查询License导入路径
        55850565645: 'GET_LICENSE_EXPORT_PATH',  # 查询License导出路径
        55847747585: 'GET_BATCH_ROUTE',  # 查询端口的路由信息
        55847747586: 'ADD_ROUTE',  # 增加路由
        55847747587: 'REMOVE_ROUTE',  # 移除路由
        55847747588: 'SET_ISCSI_DEVICE_NAME',  # 设置iSCSI设备名称
        55847747589: 'GET_ISCSI_DEVICE_NAME',  # 查询iSCSI设备名称
        55847747590: 'GET_ISNS_SERVER',  # 查询iSNS服务
        55847747591: 'SET_ISNS_SERVER',  # 设置iSNS服务地址
        55847747592: 'CONFIG_POOL_ANALYSIS',  # 配置Pool的预测分析功能
        55847747593: 'SHOW_POOL_ANALYSIS_RESULT',  # 显示Pool的预测分析结果
        55847747594: 'SHOW_POOL_ANALYSIS_PROPERTY',  # 显示Pool的预测分析属性
        55847747595: 'GET_POOL_TASK',  # 查询指定POOL的后台任务
        55847747596: 'GET_POOL_TASK_BATCH_NEXT',  # 批量查询POOL后台任务
        55847747597: 'CLEAR_ERROR_CODE',  # 清除误码
        55847747598: 'GET_FC_ERROR_CODE',  # 查询FC误码
        55847747599: 'GET_ISCSI_ERROR_CODE',  # 查询ISCSI误码
        55847747600: 'GET_SAS_ERROR_CODE',  # 查询SAS误码
        55847747601: 'IMPORT_DB_CONFIG_DIR',  # 获取导入配置文件路径
        55847747602: 'IMPORT_DB_CONFIG',  # 导入配置文件
        55847747603: 'EXPORT_DB_CONFIG',  # 导出配置文件
        55847747604: 'CLEAR_EXPORT_DATA',  # 清除导出数据
        55847747605: 'GET_SYSTEM_CONFIG',  # 导出运行数据
        55847747606: 'PACKAGE_ALARM_OR_LOG',  # 打包设备数据
        55847747607: 'OM_MSG_OP_EXPORT_ALARM_OR_LOG',  # 获取收集信息导出路径
        55847747608: 'GET_SYS_UTC_TIME',  # 查询系统本地时间
        55847747609: 'SET_SYS_UTC_TIME',  # 设置系统本地时间
        55847747610: 'GET_SYS_DST',  # 查询系统中指定时区的夏令时配置
        55847747611: 'SET_SYS_DST',  # 设置系统中指定时区的夏令时配置
        55847747612: 'GET_SYS_NTP_CLNT_CONF',  # 查询系统NTP客户端配置
        55847747613: 'SET_SYS_NTP_CLNT_CONF',  # 设置系统NTP客户端配置
        55847747614: 'GET_SFTP_USER',  # SFTP用户信息
        55847747615: 'SET_ALARM_RESTORE_ENABLE',  # SET_ALARM_RESTORE_ENABLE
        55847747616: 'SET_ALARM_RESTORE_ADDRESS',  # SET_ALARM_RESTORE_ADDRESS
        55847747617: 'GET_ALARM_RESTORE_ADDRESS',  # GET_ALARM_RESTORE_ADDRESS
        55847747618: 'SET_STATISTIC_STRATEGY',  # SET_STATISTIC_STRATEGY
        55847747619: 'GET_STATISTIC_STRATEGY',  # GET_STATISTIC_STRATEGY
        55847747620: 'SET_STATISTIC_RESTORE_INFO',  # 设置性能统计数据自动转储信息
        55847747621: 'OM_MSG_OP_SET_THRESHOLD',  # 设置性能告警阈值
        55847747622: 'OM_MSG_OP_GET_THRESHOLD',  # 查询性能告警阈值
        55847747623: 'OM_MSG_OP_GETBATCH_THRESHOLD',  # 查询所有性能告警阈值
        55847747624: 'RECOVER_ALARM_THRESHOLD',  # 恢复性能统计默认告警阈值
        55847747625: 'EXPORT_STATISTIC_DATA',  # EXPORT_STATISTIC_DATA
        55847747626: 'GET_STATISTIC_OBJECT_DATA_MAP',  # GET_STATISTIC_OBJECT_DATA_MAP
        55847747627: 'GET_STATISTIC_TIME_SPAN',  # GET_STATISTIC_TIME_SPAN
        55847747628: 'SET_PERFORMANCE_SWITCH',  # SET_PERFORMANCE_SWITCH
        55847747629: 'GET_CUR_STATISTIC_DATA',  # GET_CUR_STATISTIC_DATA
        55847747630: 'GET_HIS_STATISTIC_DATA',  # GET_HIS_STATISTIC_DATA
        55847747631: 'DEL_STATISTIC_DATA_FILE',  # DEL_STATISTIC_DATA_FILE
        55847747632: 'GET_STATISTIC_DATA_FILE',  # GET_STATISTIC_DATA_FILE
        55847747633: 'GET_PERFORMANCE_SWITCH',  # GET_PERFORMANCE_SWITCH
        55847747634: 'START_NOTIFY',  # 通知上报
        55847747635: 'STOP_NOTIFY',  # 停止上报
        55847747636: 'NOTIFY_CREATE',  # 组件添加
        55847747637: 'NOTIFY_CHANGE',  # 组件属性变化
        55847747638: 'NOTIFY_DELETE',  # 组件删除
        55847747639: 'SET_EMAIL_INFO',  # 配置告警Email
        55847747640: 'GET_EMAIL_INFO',  # 查询告警Email配置
        55847747641: 'SET_SMS_INFO',  # 配置告警短信
        55847747642: 'GET_SMS_INFO',  # 查询告警短信配置
        55847747643: 'SET_ALARM_CONFIG',  # 设置远程告警发送
        55847747644: 'GET_ALARM_CONFIG',  # 查询远程告警发送
        55847747645: 'GET_CLIENT_INFO',  # GET_CLIENT_INFO
        55847747646: 'SET_CLIENT_INFO',  # SET_CLIENT_INFO
        55847747647: 'REPORT_ALARM',  # 上报告警
        55847747648: 'GET_CURRENT_ALARM',  # 查询当前告警
        55847747649: 'GET_HISTORY_ALARM',  # 查询所有事件（GETBATCH）
        55847747650: 'CLEAR_ALARM',  # 清除告警
        55847747651: 'GET_SYS_TIMEZONE',  # 查询系统时区配置
        55847747652: 'SET_SYS_TIME_ZONE',  # 设置系统时区配置
        55847747653: 'SEND_TEST_EMAIL',  # 发送测试Email
        55847747654: 'SEND_TEST_SMS',  # 发送测试短信
        55847747655: 'SEND_TEST_TRAPMSG',  # 发送测试TRAP消息
        55847747656: 'OM_MSG_OP_SET_ALARM_SYSLOG_CFG',  # 设置syslog配置
        55847747657: 'OM_MSG_OP_GET_ALARM_SYSLOG_CFG',  # 查询syslog配置
        55847747658: 'REBOOT',  # 设备重启
        55847747659: 'POWEROFF',  # 设备下电
        55847747660: 'GET_STATISTIC_RESTORE_INFO',  # 查询性能统计数据自动转储信息
        55847747661: 'GET_SNMP_CONFIG',  # 查询SNMP配置信息
        55847747662: 'MODIFY_SNMP_ENGINEBOOTS',  # 修改SNMP引擎重启次数
        55847747663: 'GET_OEM_MANUFACTORY',  # 查询OEM厂商信息
        55847747664: 'SET_OEM_MANUFACTORY',  # 设置OEM厂商信息
        55847747665: 'MODIFY_CONFIG_ITEM',  # 修改系统配置项
        55847747666: 'SET_DHA_POLICY',  # 设置DHA策略
        55847747667: 'GET_DHA_POLICY',  # 查询DHA策略
        55847747668: 'SET_DHA_SERVICE_STATES',  # 设置DHA服务状态
        55847747669: 'GET_DHA_SERVICE_STATES',  # 查询DHA服务状态
        55847747670: 'SET_DHA_EXPORT',  # 导出DHA信息
        55847747671: 'GET_DISKSCANCONF',  # 查询DiskScanConf
        55847747672: 'MODIFY_DISKSCANCONF',  # 修改DiskScanConf
        55847747673: 'GET_SERVICE_STATUS',  # 查指定节点agent状态
        55847747674: 'GET_SERVICE_STATUS_BATCH_NEXT',  # 查所有节点agent状态
        55847747675: 'START_SERVICE',  # 启动agent
        55847747676: 'STOP_SERVICE',  # 停止agent
        55847747677: 'DELETE_ISNS_SERVER',  # 删除ISNS SERVER配置
        55847747678: 'CLEAR_DB',  # 清除DB
        55847747679: 'GET_BACK_DB_INFO',  # 查询DB备份信息
        55847747680: 'BACKUP_DB',  # 备份DB
        55847747681: 'RESTORE_DB',  # 恢复DB
        55847747682: 'GET_DB_VERSION',  # 查询DB版本
        55847747683: 'SET_DHA_SINGLE_TASK_SWITCH',  # 设置DHA singletask开关
        55847747684: 'GET_DHA_LAST_RESULT',  # 查询DHA last result
        55847747685: 'GET_POWER_CONSUMPTION',  # 查询系统能耗
        55847747686: 'GET_REPAIRVERIFYCONF',  # 查询RepairVerifyConf
        55847747687: 'MODIFY_REPAIRVERIFYCONF',  # 修改RepairVerifyConf
        55847747688: 'GET_BSTCONF',  # 查询BSTConf
        55847747689: 'MODIFY_BSTCONF',  # 修改BSTConf
        55847747690: 'GET_CHUNKISOLATECONF',  # 查询ChunkIsolateConf
        55847747691: 'MODIFY_CHUNKISOLATECONF',  # 修改ChunkIsolateConf
        55847747692: 'FORCE_REBOOT',  # 强制重启
        55847747693: 'GET_POWERON_INFO',  # 获取指定节点或本节点上电结果
        55847747694: 'GET_NEXT_BATCH_POWERON_RESULT',  # 获取所有节点上电结果
        55847747695: 'VERIFY_VEIW_PASSWD',  # 验证视图密码
        55847747696: 'CHANGE_VIEW_PASSWD',  # 修改视图密码
        55847747697: 'RETSET_VIEW_PASSWD',  # 重置视图密码
        55847747698: 'GETBATCH_ENUM_INFO',  # 查询某个枚举定义详情
        8596488204: 'INTEGRATIVE_QUERY',  # 查询NAS引擎的用户名和密码
        55847747700: 'INTEGRATIVE_SET_IP',  # 设置NAS引擎的机头IP
        55847747701: 'INTEGRATIVE_SET_USERINFO',  # 设置NAS引擎的用户名和密码
        55847747702: 'INTEGRATIVE_DEL',  # 重置NAS用户名和密码、IP
        55847747703: 'INTEGRATIVE_SHOW',  # 显示DB中存的NAS引擎的所有用户名和密码
        55847747704: 'GET_FILE_DATA',  # 获取文件数据
        55847747705: 'GET_CURRENT_NODE_STATUS',  # 查当前节点状态
        55847747706: 'GET_SYSTEM_STATUS',  # 查系统状态
        55847747707: 'SPA_OPCODE_QUERY_ROOT_CKGID',  # 查询指定Pool的rootckg0 ID
        55847747708: 'SPA_OPCODE_EXPORT_ROOT_CKG',  # 导出指定CKG上的元数据
        55847747709: 'SPA_OPCODE_EXPORT_BTREE',  # 导出指定节点上的元数据
        55847747710: 'SPA_OPCODE_IMPORT_ROOT_CKG',  # 导入指定CKG上的元数据
        55847747711: 'SPA_OPCODE_IMPORT_BTREE',  # 导入指定节点上的元数据
        55847747712: 'GET_FILE_META',  # 获取文件描述信息
        55847747713: 'UPLOAD_FILE_DATA',  # 上传文件数据
        55847747714: 'SPA_OPCODE_BTREE_SMO_CHECK_BEGIN',  # 启动元数据校验
        55847747715: 'SPA_OPCODE_BTREE_SMO_CHECK_QUERY',  # 查询元数据校验结果
        55847747716: 'NOTIFY_NEW_FILE_CREATE',  # 通知新的文件产生
        55847747717: 'GET_ALARM_COUNT',  # 查询告警数量
        55847747718: 'show_dps_statistic',  # 查询备份软件统计信息
        55847747719: 'show_processor_statistic',  # 查询备份服务器统计信息
        55847747720: 'query_progress',  # 进度查询
        55847747721: 'query_bacth_service',  # 查询批量系统服务
        55847747722: 'start_service',  # 启动系统服务
        55847747723: 'stop_service',  # 停止系统服务
        55847747724: 'restart_service',  # 重启系统服务
        55847747725: 'start_backup',  # 手动执行备份任务
        55847747726: 'activate_policy',  # 激活策略
        55847747727: 'import_backupset',  # 导入备份集
        55847747728: 'expired_backupset',  # 立即过期备份集
        55847747729: 'query_storage_unit_capacity',  # 查询存储单元容量
        55847747730: 'del_license',  # 删除license
        55847747731: 'EXPORT_ALARM',  # 导出告警
        55847747732: 'NOTIFY_CMD_EXECUTE',  # 命令执行上报
        55847747733: 'CLEAR_LICENSE_FILE',  # 清除License文件
        55847747734: 'GET_HISTORY_ALARM_COUNT',  # 查询历史告警数量
        55847747735: 'CONFIRM_ALARM',  # 告警确认
        55847747736: 'GET_DISKPOOL_TASK',  # 查询指定DISKPOOL的后台任务
        55847747737: 'SCAN_AND_CREATE_HOST',  # 自动扫描并创建主机
        55847747738: 'TEST_NTP_COMM',  # 测试NTP服务通信
        55835295745: 'SWITCH_WORKING_CONTROLLER',  # 切换LUN的归属控制器
        55835295746: 'LUN_TRANSFERM',  # Thin LUN与Fat LUN之间的相互转换
        55835295747: 'EXPAND_LUN_CAPACITY',  # LUN的扩容
        55835295748: 'GET_BATCH_NEXT_SNAPSHOT_LUN_CANUSE',  # 查询可创建快照的LUN
        55835295749: 'SET_WORM_STATE',  # 设置WORM状态
        55835295750: 'SET_SYS_WORM_SW',  # 设置全局WORM开关
        55835295751: 'GET_SYS_WORM_SW',  # 查询全局WORM开关
        55835295752: 'ADD_LUN_BY_WWN',  # 根据WWN添加LUN到映射视图
        55835295753: 'REMOVE_LUN_BY_WWN',  # 根据WWN移除LUN从映射视图
        55835295754: 'GET_BATCH_NEXT_LUN_FOR_MIGRATION',  # 查询LUN迁移的源LUN或目标LUN
        55835295755: 'COUNT_LUN_FOR_MIGRATION',  # 查询LUN迁移的源LUN或目标LUN的总数
        55849123841: 'REMOVE_iSCSI_FROM_HOST',  # 将iSCSI启动器从HOST移除
        55849189377: 'REMOVE_FC_FROM_HOST',  # 将FC启动器从HOST移除
        55847813121: 'USER_LOGIN',  # 用户登陆
        55847813122: 'USER_LOGOUT',  # 用户注销
        55847813123: 'OFFLINE_USER',  # 踢除用户
        55847813124: 'INITIALIZE_USER_PWD',  # 初始化密码
        55847813125: 'HANDSHAKE',  # 用户握手
        55837327366: 'LOCK_USER',  # 锁定用户
        55837327367: 'UNLOCK_USER',  # 解锁用户
        55837327368: 'REQUEST_TOKEN',  # 获取一次性登陆令牌
        55837327369: 'UNLOCK_IP',  # 解锁IP
        55850172417: 'GET_DEFAULT_LDAP_CONFIG',  # 查询LDAP的默认属性
        55850041345: 'GET_IPRULE_SWITCH',  # 查询ip规则开关状态
        55850041346: 'MODIFY_IPRULE_SWITCH',  # 设置IP规则
        55849517057: 'ADD_HYPERCLONE_SLAVE',  # 添加从Lun
        55849517058: 'DELETE_HYPERCLONE_SLAVE_LUN',  # 删除从Lun
        55849517059: 'SPLIT_HYPERCLONE_SLAVE',  # 分裂从Lun
        55849517060: 'SYNCHRONIZE_HYPERCLONE_SLAVE',  # 同步从Lun
        55849517061: 'REVERSE_SYCH_HYPERCLONE_SLAVE',  # 反向同步从Lun
        55849517062: 'GET_BATCH_NEXT_HYPERCLONE_LUN_CANUSE',  # 查询创建分裂镜像时需要的LUN
        55849517063: 'GET_HYPERCLONE_LUN_DETAILS',  # 查询分裂镜像的LUN
        55849517064: 'GET_BATCH_NEXT_HYPERCLONE_LUN_INFO',  # 批量查询分裂镜像的LUN（NEXT）
        55849517065: 'SPLIT_MULTI_HYPERCLONE_SLAVE',  # 分类多个从Lun
        55835230209: 'DISK_POWER_ON',  # 硬盘上电
        55835230210: 'DISK_POWER_OFF',  # 硬盘下电
        55835230211: 'DISK_RESET',  # DISK_RESET
        55835230212: 'GET_DISK_NCQ_SWITCH',  # GET_DISK_NCQ_SWITCH
        55835230213: 'SET_DISK_NCQ_SWITCH',  # SET_DISK_NCQ_SWITCH
        55835230214: 'GET_DISK_UNPLUG',  # GET_DISK_UNPLUG
        55835230215: 'SET_DISK_UNPLUG',  # SET_DISK_UNPLUG
        55835230216: 'GET_DISK_WRITECACHESW',  # GET_DISK_WRITECACHESW
        55835230217: 'SET_DISK_WRITECACHESW',  # SET_DISK_WRITECACHESW
        55835230218: 'GET_DISK_PRECOPYSW',  # GET_DISK_PRECOPYSW
        55835230219: 'SET_DISK_PRECOPYSW',  # SET_DISK_PRECOPYSW
        55835230220: 'GET_DISK_BST',  # GET_DISK_BST
        55835230221: 'CLEAR_DISK_BST',  # CLEAR_DISK_BST
        55835230222: 'SET_DISK_LITHTSW',  # 硬盘定位灯开启/关闭
        55835230223: 'FORCE_READ_DISK',  # 强制接入硬盘并使用它对其它硬盘进行重构
        55835230224: 'START_DISK_PRECOPY',  # 启动预拷贝
        55835230225: 'GET_DISK_ROUTINE_TEST',  # 获取硬盘例测周期
        55848140801: 'SWAP_CONTROLLER',  # 主从切换控制器
        55848140802: 'REBOOT_CONTROLLER',  # 重启控制器
        55848140803: 'GET_INITIATOR_NAME',  # 查询控制器作为启动器的名称
        55848140804: 'SET_INITIATOR_NAME',  # 设置控制器作为启动器的名称
        55848140805: 'GET_FRONT_END_CONCURRENT',  # 获取前端并发
        55848140806: 'GET_BACK_END_CONCURRENT',  # 获取后端并发
        55848140807: 'OFFLINE_CONTROLLER',  # 离线控制器
        55848140808: 'OFFLINE_CONTROLLER_SERVICE',  # 切换控制器业务
        55848140809: 'ONLINE_CONTROLLER_SERVICE',  # 切回控制器业务
        55835623425: 'GET_FREQUENCYSWITCH',  # 查询调频开关
        55835623426: 'SET_FREQUENCYSWITCH',  # 设置调频开关
        55848075265: 'POWERON_ENCLOSURE',  # 框上电
        55849254913: 'CREATE_REMOTE_DEVICE',  # 创建远端设备
        55850958849: 'SCAN_REMOTE_LUN',  # 手动扫描Remote LUN
        55848009729: 'GET_EXPANSION_BAY_ID',  # 获取待扩容柜id
        55848009730: 'CAPACITY_EXPAND',  # 扩容系统柜
        55848009731: 'CANCEL_CAPACITY_EXPAND',  # 取消系统柜扩容
        56911134721: 'SET_FILELEVEL_PRIORITIES',  # 设置SNAS分级存储策略优先级
        56911134722: 'GET_FILELEVEL_PRIORITIES',  # 查询SNAS分级存储策略优先级
        56911134742: 'TEST_SWITCH_COMM',  # 测试交换机SNMP通信
        8599109754: 'OM_MSG_OP_GET_PACKAGE_UPLOADPATH',  # 查询升级包上传路径
        8599117947: 'OM_MSG_OP_NOTIFY_PACKAGE_PATH',  # 通知软件包上传完成
        8599109756: 'OM_MSG_OP_UPD_LST_PACKAGE_INFO',  # 查询升级包信息
        8599150994: 'OM_MSG_OP_UPD_LST_ACTIVEMODE',  # 查询激活方式
        8599150995: 'OM_MSG_OP_UPD_LST_DETAILINFO',  # 查询升级详细信息
        8599118950: 'OM_MSG_OP_EXC_HOTPATCH_DELETE',  # 删除热补丁
        8599117938: 'OM_MSG_OP_UPD_DISK_FIRMWARE',  # 升级硬盘
        8599117939: 'OM_MSG_OP_UPD_GET_DISK_RESULT',  # 获取硬盘升级状态
        8599117975: 'OM_MSG_OP_UPD_GET_MGTBOARD_RESULT',  # 获取管理板升级状态
        8599109735: 'OM_MSG_OP_LST_VER',  # 查询版本信息
        8599117931: 'OM_MSG_OP_UPD_EXECUTE',  # 通知执行一个升级流程
        8599109744: 'OM_MSG_OP_UPD_LST_SYS_PROGRESS',  # 查询整体升级状态
        56908316673: 'OM_MSG_OP_LST_SYS_UPSTAT',  # 查询集群总体以及各节点升级状态
        56908316674: 'OM_MSG_OP_UPD_NODE_REPORT',  # 查询集群各节点升级报告
        56908316675: 'OM_MSG_OP_UPD_SYS_REPORT',  # 查询集群整体升级报告
        56908316676: 'OM_MSG_OP_UPD_PRE_TEST',  # 集群升级预检测
        56908316677: 'OM_MSG_OP_LST_DLD_VERPKG',  # 通知节点下载软件升级包
        56911134721: 'SET_FILELEVEL_PRIORITIES',  # 设置SNAS分级存储策略优先级
        56911134722: 'GET_FILELEVEL_PRIORITIES',  # 查询SNAS分级存储策略优先级
        56911134742: 'TEST_SWITCH_COMM',  # 测试交换机SNMP通信
        59592671232: 'query_backupset_import_info',  # 查询导入备份集信息
        59592671233: 'query_backuoset_import_log',  # 查询导入备份集日志
        59592671234: 'sync_vm',  # 同生产端同步虚拟机
        59592671235: 'backup_task_cancel',  # 备份任务取消
        59592671236: 'sync_backup_server_ip',  # 同步服务器的IP信息
        59592671237: 'get_config_file',  # 查询告警配置文件、错误码配置文件
        59592671238: 'get_storage_usage_top',  # 查询存储单元TOP5
        59592671239: 'get_backup_server_status',  # 强制刷新备份服务器状态
        59592671240: 'repair_storage_unit',  # 修复存储单元
        59592671241: 'PRO_SYS_TIME_MANUAL_SYNC',  # 在processor上手动同步系统时间
        59592671242: 'get_local_role',  # 获取本地服务器角色
        59592671243: 'DELETE_SHNAPSHOT',  # 删除快照
        59592671244: 'get_single_CBT',  # 查询单个备份服务器CBT状态
        59592671245: 'set_local_CBT',  # 设置本地CBT状态
        59592671246: 'set_vm_CBT',  # 设置虚拟机CBT状态
        59592671247: 'DELETE_BITMAP',  # 删除位图卷
        59592671248: 'QUERY_BITMAP',  # 查询位图卷
        59592671249: 'DELET_SNAPSHOT_PROCESS',  # 查询删除快照进度
        59592671250: 'QUERY_SNAPSHOT_INFO',  # 查询快照信息
        59592671251: 'get_single_transMode',  # 查询单个备份服务器传输模式
        59592671252: 'set_local_transMode',  # 设置本地传输模式
        57176883201: 'GET_INTF_MODULE_STATUS',  # 获取接口卡状态信息，专用于更换IP scale-out接口卡
        57176883202: 'GET_ALL_PORTS_BY_INTF_SLOT',  # 获取接口卡下的所有端口信息，专用于更换IP scale-out接口卡
        55847747759: 'CHECK_SAS_CARD_LINK_STATUS',  # 获取接口卡下所连接的所有硬盘中是否存在链路不完整的硬盘
    }

    '''
    '''
    OM_OBJ_E = {
        2: 'Array||阵列',  # key=ARRAY
        3: 'Front Controller||前端控制器',  # key=FRONT_CONTROLLER
        4: 'Unify Controller||前后端合一控制器',  # key=UNIFY_CONTROLLER
        5: 'Back Controller||后端控制器',  # key=BACK_CONTROLLER
        6: 'Front Port||前端端口',  # key=FRONT_PORT
        7: 'Back Port||后端端口',  # key=BACK_PORT
        8: 'Volume||卷',  # key=VOLUME
        9: 'Scope||范围',  # key=SCOPE
        12: 'Remote Mirror Group||远程镜像组',  # key=REMOTE_MIRRORGROUP
        13: 'Remote Link||远程连接链路',  # key=REMOTE_LINK
        15: 'RAID||RAID',  # key=RAID
        17: 'Replication Bandwidth||复制带宽',  # key=REPLICATION_BANDWIDTH
        18: 'Snapshot Consistent Group||快照一致性组',  # key=SNAPSHOT_CONSISTENTGROUP
        19: 'Volume Consistent Group||一致性卷组',  # key=VOLUME_CONSISTENTGROUP
        20: 'Disk Group||磁盘组',  # key=DISKGROUP
        24: 'CPU Core||CPU核心',  # key=CPU_CORE
        25: 'Node||节点',  # key=NODE
        26: 'Fan Enclosure||风扇框',  # key=FAN_ENCLOSURE
        29: 'Remote LUN Copy||远程LUN拷贝',  # key=REMOTE_LUNCOPY
        30: 'Thin Pool||Thin pool(精简池)',  # key=THINPOOL
        32: 'Hyper Clone Consistent Group||分裂镜像一致性组',  # key=COM_HYPER_CLONE_CG
        33: 'NFS Share||NFS共享',  # key=NFS_Share
        34: 'NFS Server||NFS服务器',  # key=NFS_Server
        35: 'CIFS Share||CIFS共享',  # key=CIFS_Share
        36: 'CIFS Server||CIFS服务器',  # key=CIFS_Server
        37: 'FTP||FTP',  # key=FTP
        38: 'HTTP||HTTP',  # key=HTTP
        39: 'Replication||远程复制',  # key=Replication
        40: 'FileSystem||文件系统',  # key=FileSystem
        41: 'Pool||文件存储池',  # key=Pool
        42: 'User||用户',  # key=User
        43: 'Wi-Fi||Wi-Fi',  # key=Wi-Fi
        44: 'Cloud Backup||云备份',  # key=Cloud Backup
        45: 'File System Tier||文件系统分层',  # key=FileSystemTier
        46: 'NFS Client||NFS客户端',  # key=NFSClient
        47: 'User Security Policy||用户安全策略',  # key=USER_SECURITY_POLICY
        10: 'Disk||硬盘',  # key=DISK
        11: 'LUN||LUN',  # key=LUN
        14: 'Host Group||主机组',  # key=HOSTGROUP
        16: 'CPU||CPU',  # key=CPU
        21: 'Host||主机',  # key=HOST
        23: 'Power||电源模块',  # key=POWER
        27: 'Snapshot||快照',  # key=SNAPSHOT
        28: 'Remote Replication||远程复制',  # key=REMOTEREPLICATION
        29: 'File System Snapshot||文件系统快照',  # key=FSSNAPSHOT
        199: 'SystemLicense||SystemLicense',  # key=SystemLicense
        200: 'CommonData||通用数据存储',  # key=CommonData
        201: 'System||系统',  # key=SYSTEM
        202: 'User||用户',  # key=USER
        203: 'Domain||域',  # key=DOMAIN
        204: 'Domain Member||域成员',  # key=DOMAINMEMBER
        205: 'Bay||柜',  # key=BAY
        206: 'Enclosure||框',  # key=ENCLOSURE
        207: 'Controller||控制器',  # key=CONTROLLER
        208: 'Expand Board||级联板',  # key=EXPBOARD
        209: 'Interface Module||接口模块',  # key=INTF_MODULE
        210: 'Backup Power||BBU模块',  # key=BACKUP_POWER
        211: 'Fan||风扇模块',  # key=FAN
        212: 'FC Port||FC端口',  # key=FC_PORT
        16500: 'IB Port||IB端口',  # key=IB_PORT
        213: 'Ethernet Port||以太网口',  # key=ETH_PORT
        214: 'SAS Port||SAS端口',  # key=SAS_PORT
        215: 'Serial Port||串口',  # key=SERIAL_PORT
        216: 'Storage Pool||存储池',  # key=STORAGEPOOL
        217: 'Storage Tier||存储层',  # key=STORAGETIER
        218: 'SmartCache||SmartCache',  # key=SMARTCACHE
        219: 'LUN Copy||LUN拷贝',  # key=LUNCOPY
        220: 'Split Mirror||分裂镜像',  # key=SPLITMIRROR
        221: 'Consistent Group||一致性组',  # key=CONSISTENTGROUP
        222: 'iSCSI Initiator||iSCSI启动器',  # key=ISCSI_INITIATOR
        223: 'FC Initiator||FC启动器',  # key=FC_INITIATOR
        224: 'Remote Device||远端设备',  # key=REMOTE_DEVICE
        225: 'FC Link||FC远端链路',  # key=FC_LINK
        226: 'Remote Replication Member LUN||远程复制成员LUN',  # key=REMOTEREPLICATIONMEMBERLUN
        227: 'LUN Copy Member LUN||LUN拷贝成员LUN',  # key=LUNCOPYMEMBERLUN
        228: 'Split Mirror Target LUN||分裂镜像从LUN',  # key=SPLITMIRRORTARGETLUN
        229: 'iSCSI Session||iSCSI会话',  # key=ISCSI_SESSION
        230: 'IO Class||IO分类',  # key=IOCLASS
        231: 'UPS||UPS',  # key=UPS
        232: 'PCIE Data Switch||PCIE数据交换机',  # key=PCIE_DATA_SWITCH
        233: 'PCIE Data Switch Port||PCIE端口',  # key=PCIE_PORT
        234: 'SFP optical transceiver||光模块',  # key=SFP_OPTICAL_TRANSCEIVER
        235: 'bond port||绑定端口',  # key=BOND_PORT
        236: 'IPRule||安全规则',  # key=IPRule
        237: 'Memory||内存',  # key=MEMORY
        238: 'LDAP configuraion||ldap配置',  # key=LDAPConfig
        239: 'LDAP User Map||ldap用户映射',  # key=LDAP_USER_MAP
        240: 'SNMP Trap Address||SNMP Trap地址',  # key=SNMP_TRAP_ADDR
        241: 'SNMP Community||SNMP 团体字',  # key=SNMP_COMMUNITY
        242: 'SNMP USM||基于用户的安全模型',  # key=SNMP_USM
        243: 'iSCSI Link||iSCSI远端链路',  # key=iSCSI_LINK
        244: 'License||License',  # key=License
        245: 'Mapping View||映射视图',  # key=MAPPINGVIEW
        246: 'Schedule||时刻表',  # key=SCHEDULE
        247: 'iSCSI Session Settings||iSCSI会话初始参数信息（即连接会话时的协商参数）',  # key=iSCSI_SESSION_SETTING
        248: 'iSCSI Target Node||iSCSI目标器节点',  # key=iSCSI_TGT_NODE
        249: 'iSCSI Target Port||iSCSI目标器端口',  # key=iSCSI_TGT_PORT
        250: 'Remote LUN||远端lun',  # key=REMOTE_LUN
        251: 'Monitor Board||监控板',  # key=MONITOR_BOARD
        252: 'FCoE Port||FCoE端口',  # key=FCoE_PORT
        253: 'LUN Migration Task||LUN迁移任务',  # key=LUN_Migration_Task
        254: 'Clone Group||克隆组',  # key=CloneGroup
        255: 'Host Link||主机链路',  # key=HOST_LINK
        256: 'LUN Group||LUN组',  # key=LUNGroup
        257: 'Port Group||Port组',  # key=PortGroup
        258: 'Subnet||子网段',  # key=Subnet
        259: 'NetGroup||网络组',  # key=NetGroup
        260: 'DNS Server||DNS服务器',  # key=DNS_Server
        261: 'IP LINK||IP链路',  # key=IP_LINK
        262: 'User Group||用户组',  # key=UserGroup
        263: 'REPLICATION PAIR||远程复制pair',  # key=REPLICATIONPAIR
        264: 'Slow disk policy||慢盘检测',  # key=Slow_disk_policy
        265: 'LUNBackgroudTask||LUN后台任务',  # key=LUNBackgroudTask
        266: 'DiskPool||硬盘域',  # key=DiskPool
        267: 'StorageEngine||存储引擎',  # key=StorageEngine
        268: 'CachePartition||Cache分区',  # key=CachePartition
        269: 'IOCLASSTemplate||IO分类模板',  # key=IOCLASSTemplate
        270: 'LUNDestroyData||LUN数据消毁',  # key=LUNDestroyData
        271: 'DiskDestroyData||Disk数据消毁',  # key=DiskDestroyData
        272: 'LUNPriorityStatistic||LUN优先级统计',  # key=LUNPriorityStatistic
        273: 'SmartCachePartition||SmartCache分区',  # key=SmartCachePartition
        274: 'DISK_SCAN_TASK||Disk扫描任务',  # key=DISK_SCAN_TASK
        20480: 'CLI_COMMON||专用于CLI公共部分，CLI新增的特殊命令字可以挂接在此对象下，仅供CLI使用，框架不允许使用此处新增的对象或命令字',  # key=CLI_COMMON
        32768: 'SAS_Card||SAS卡',  # key=SAS_Card
        32769: 'Raid_Card||Raid卡',  # key=Raid_Card
        32770: 'Memory||内存信息',  # key=Memory
        32771: 'Server_FileSystem||服务器文件系统',  # key=Server_FileSystem
        32772: 'RaidCard_Raid||RaidCard_Raid',  # key=RaidCard_Raid
        32773: 'RaidCard_LUN||RaidCard_LUN',  # key=RaidCard_LUN
        32774: 'RaidCard_LogicDisk||RaidCard_LogicDisk',  # key=RaidCard_LogicDisk
        32775: 'SmartData_Raid||SmartData_Raid',  # key=SmartData_Raid
        32776: 'SmartData_LUN||SmartData_LUN',  # key=SmartData_LUN
        32777: 'SmartData_LogicDisk||SmartData_LogicDisk',  # key=SmartData_LogicDisk
        16384: 'SNAS_SYSTEM||Scale out NAS系统',  # key=SNAS_SYSTEM
        16385: 'Scale out NAS NODE||SNAS集群系统节点',  # key=SNAS_NODE
        16386: 'Protocol cluster||SNAS协议集群',  # key=PROTOCOL_CLUSTER
        16387: 'Protocol cluster node||SNAS协议集群节点',  # key=PROTOCOL_CLUSTER_NODE
        16388: 'Protocol cluster zone||SNAS协议集群分区',  # key=PROTOCOL_CLUSTER_ZONE
        16389: 'Public ip pool||动态IP池',  # key=SNAS_IP_POOL
        16390: 'NAS client||SNAS系统客户端',  # key=SNAS_CLIENT
        16391: 'DNS configuration||SNAS DNS 配置',  # key=SNAS_DNS_CONFIG
        16392: 'local user||本地用户',  # key=SNAS_LOCAL_USER
        16393: 'local group||本地用户组',  # key=SNAS_LOCAL_GROUP
        16394: 'user&group relationship||用户组和用户关系',  # key=SNAS_USERANDGROUP
        16395: 'ID MAPPING||SNAS ID MAPPING',  # key=SNAS_IDMAP_CONFIG
        16396: 'Root user password setting||SNAS节点root用户',  # key=SNAS_ROOT_USER
        16397: 'FS service running on node||SNAS节点文件系统服务',  # key=SNAS_NODE_FS_SERV
        16398: 'NAS service running on node||SNAS节点协议共享服务',  # key=SNAS_NODE_SHARE_SERV
        16399: 'CIFS service configuration||SNAS CIFS 服务',  # key=SNAS_CIFS_SERVICE
        16400: 'SNAS file object||SNAS 文件',  # key=SNAS_FILE
        16401: 'NFS share of file||SNAS NFS共享',  # key=SNAS_NFS_SHARE
        16402: 'CIFS share of file||SNAS CIFS 共享',  # key=SNAS_CIFS_SHARE
        16403: 'SNAS user quota||SNAS用户配额',  # key=SNAS_USER_QUOTA
        16404: 'CIFS client permission of file||SNAS CIFS用户共享',  # key=SNAS_CIFS_SHARE_AUTH_CLIENT
        16405: 'Data recovery schedule||数据恢复计划',  # key=DATA_RECOVER_SCHEDULE
        16406: 'back task||SNAS任务',  # key=SNAS_TASK
        16407: 'key-value store||SNAS KV存储接口',  # key=SNAS_KEY_VALUE_STORE
        16408: 'SNAS file quota||SNAS文件配额',  # key=SNAS_FILE_QUOTA
        16409: 'NFS client permission of file||SNAS NFS 客户端共享',  # key=SNAS_NFS_SHARE_AUTH_CLIENT
        16410: 'ACL||协议 ACL策略',  # key=SNAS_ACL_STRATEGY
        16411: 'Local authority configuration||本地认证源',  # key=SNAS_LOCAL_AUTH
        16412: 'NIS configuration||NIS认证源',  # key=SNAS_NIS_CONFIG
        16413: 'LDAP configuration||LDAP认证源',  # key=SNAS_LDAP_CONFIG
        16414: 'AD domain||AD域认证源',  # key=SNAS_AD_CONFIG
        16415: 'SNAS node water level||SNAS性能节点数据迁移水位',  # key=SNAS_SYS_WATERLEVEL
        16416: 'energy saving||SNAS系统节能开关',  # key=SNAS_SYS_ENERGY_SAVING
        16417: 'alarm void setting||SNAS告警声音设置',  # key=SNAS_ALARM_VOICE
        16418: 'admin user security policies||SNAS 系统安全策略',  # key=SNAS_SECURITY_POLICY
        16419: 'connection heart beat||心跳',  # key=SNAS_HEARTBEAT
        16420: 'connection hand shake||握手接口',  # key=SNAS_HANDSHAKE
        16421: 'check snas main mrg node||管理节点',  # key=SNAS_MGR_NODE
        16422: 'snas node performance||集群节点性能接口',  # key=SNAS_NODE_PERFORMANCE
        16423: 'snas super user pwd reset||SNAS SMTP配置',  # key=SNAS_SECURITY_SMTP
        16424: 'snas alarm threshold||SNAS告警阈值',  # key=SNAS_ALARM_THRESHOLD
        16425: 'snas AD domain||SNAS AD域',  # key=SNAS_AD_SOURCE
        16426: 'snas storage Tier||SNAS 分级存储',  # key=SNAS_SYS_TIER
        16427: 'snas file level policy||SNAS_FILE_LEVEL_POLICY',  # key=SNAS_FILE_LEVEL_POLICY
        16428: 'snas file level policy item||SNAS_FILE_LEVEL_POLICY_ITEM',  # key=SNAS_FILE_LEVEL_POLICY_ITEM
        16429: 'snas file io statistic||SNAS_SYS_IO_TEMP',  # key=SNAS_SYS_IO_TEMP
        16430: 'snas nis auth source||SNAS_NIS_SOURCE',  # key=SNAS_NIS_SOURCE
        16431: 'snas ldap auth source||SNAS_LDAP_SOURCE',  # key=SNAS_LDAP_SOURCE
        16432: 'snas file access time||SNAS_FILE_ATIME',  # key=SNAS_FILE_ATIME
        16433: 'snas encrypte key||AES对称加密密钥128位',  # key=SNAS_ENCRYPT_KEY
        16434: 'snas sms modem||SNAS_DEVICE_SMSMODEM',  # key=SNAS_DEVICE_SMSMODEM
        16435: 'snas_alarm_level||告警定义配置',  # key=SNAS_ALARM_DEFINITION
        16436: 'snas_cmd_opinfo||命令操作提示信息接口',  # key=SNAS_CMD_OPINFO
        16437: 'snas dns service||SNAS_EXTERNAL_DNS',  # key=SNAS_EXTERNAL_DNS
        16438: 'snas ip switch||SNAS_IP_SWITCH',  # key=SNAS_IP_SWITCH
        16439: 'snas ip switch port||SNAS_IP_SWITCH_PORT',  # key=SNAS_IP_SWITCH_PORT
        16440: 'snas snmp discovery config||SNAS_DISCOVERY_SNMP',  # key=SNAS_DISCOVERY_SNMP
        16441: 'IPZone||IPZone',  # key=IPZone
        16442: 'vStore||虚拟存储（多租户）',  # key=vStore
        16443: 'WormUser||WORM管理员',  # key=WormUser
        16444: 'CommConfigure||通用配置（目前VMware使用）',  # key=CommConfigure
        16445: 'QUOTATREE||QUOTATREE',  # key=QUOTATREE
        16446: 'LOCAL_RESUSER||本地资源用户（统一存储使用）',  # key=LOCAL_RESUSER
        16447: 'LOCAL_RESGROUP||本地资源用户组（统一存储使用）',  # key=LOCAL_RESGROUP
        16448: 'HTTPOnlineLink||HTTP的在线连接',  # key=HTTPOnlineLink
        16449: 'FTPOnlineLink||FTP的在线连接',  # key=FTPOnlineLink
        16450: 'HTTPSERVICE||HTTP服务',  # key=HTTPSERVICE
        16451: 'FTPSERVICE||FTP服务',  # key=FTPSERVICE
        16452: 'NFSSERVICE||NFS服务',  # key=NFSSERVICE
        16453: 'CIFSSERVICE||CIFS服务',  # key=CIFSSERVICE
        16454: 'SNAS_FTP_SHARE_AUTH_CLIENT||FTP共享权限',  # key=SNAS_FTP_SHARE_AUTH_CLIENT
        16455: 'SNAS_HTTP_SHARE_AUTH_CLIENT||HTTP共享权限',  # key=SNAS_HTTP_SHARE_AUTH_CLIENT
        16456: 'SNAS_HTTP_SHARE||HTTP共享',  # key=SNAS_HTTP_SHARE
        16457: 'Homedir||用户主目录',  # key=Homedir
        16458: 'Quota||配额',  # key=Quota
        16459: 'snas capacity collection||集群对象容量数据采集',  # key=SNAS_CAPACITY_STATISTIC
        49152: 'ISM||ISM',
        53248: 'NOFS||NOFS',  # key=NOFS
        57344: 'task||任务',  # key=TASK
        57345: 'backup server||备份服务器',  # key=BACKUP_SERVER
        57346: 'VRM||虚拟资源管理节点（VRM）',  # key=VRM
        57347: 'cluster||集群',  # key=CLUSTER
        57348: 'CAN||计算节点代理（CNA）',  # key=CAN
        57349: 'datastore||数据存储',  # key=DATASTORE
        57350: 'virtual machine||虚拟机',  # key=VIRTUAL_MACHINE
        57351: 'virtualdisk||VDI虚拟磁盘',  # key=VDI_DISK
        57352: 'backup policy||备份策略',  # key=BACKUP_POLICY
        57353: 'Storage Unit||存储单元',  # key=STORAGE_UNIT
        57354: 'Restore Policy||恢复策略',  # key=RESTORE_POLICY
        57355: 'Backup Set||备份集'  # key=BACKUP_SET
    }

    '''
    '''
    STATISTIC_DATA_ID = {
        1: 'Total I/O Count||总I/O数量',  # key=TotalIOCount
        2: 'Read I/O Ratio||读I/O比率',  # key=ReadIORatio
        3: 'Write I/O Ratio||写I/O比率',  # key=WriteIORatio
        4: 'Current Bandwidth (MB/s)||当前带宽 （MB/s）',  # key=CurrentBandWidth
        5: 'Max. Bandwidth (MB/s)||最大带宽 （MB/s）',  # key=MaxBandWidth
        6: 'Current IOPS||当前IOPS',  # key=CurrentIOPS
        7: 'Max IOPS(IO/s)||最大IOPS（IO/s）',  # key=MaxIOPS
        8: 'Max Latency||最大延迟',  # key=MaxLatency
        9: 'Average Latency||平均延迟',  # key=AverageLatency
        10: 'Cache Hit (%)||Cache命中率（%）',  # key=CacheHit
        11: 'Local Write Cache Ratio||本地写Cache利用率',  # key=LocalWriteCacheRatio
        12: 'Mirror Write Cache Ratio||镜像写Cache利用率',  # key=MirrorWriteCacheRatio
        13: 'Read I/O Traffic||读I/O流量',  # key=ReadIOTraffic
        14: 'Write I/O Traffic||写I/O流量',  # key=WriteIOTraffic
        15: 'Max Power Consumption||最大功耗',  # key=MaxPowerConsume
        16: 'Average Power Consumption||平均功耗',  # key=AvgPowerConsume
        17: 'Min Power Consumption||最小功耗',  # key=MinPowerConsume
        18: 'Usage Ratio (%)||利用率 （%）',  # key=Usage
        19: 'Queue Length||队列长度 （个）',  # key=QueueSize
        20: 'Response Time (ms)||响应时间 （ms）',  # key=ResponseTime
        21: 'Bandwidth (MB/s)||带宽 （MB/s）',  # key=BandWidth
        22: 'Throughput(IOPS) (IO/s)||吞吐量（IOPS）（IO/s）',  # key=Throughput
        23: 'Read Bandwidth (MB/s)||读带宽 （MB/s）',  # key=ReadBandWidth
        24: 'Average Read I/O Size (KB)||读I/O平均大小 （KB）',  # key=AverageReadIO
        25: 'Read Throughput(IOPS) (IO/s)||读吞吐量（IOPS）（IO/s）',  # key=ReadThroughput
        26: 'Write Bandwidth (MB/s)||写带宽（MB/s）',  # key=WriteBandWidth
        27: 'Average Write I/O Size (KB)||写I/O平均大小 （KB）',  # key=AverageWriteIO
        28: 'Write Throughput(IOPS) (IO/s)||写吞吐量（IOPS）（IO/s）',  # key=WirteThroughput
        29: 'Service Time (Excluding Queue Time) (ms)||服务时间(不包括队列排队时间) （ms）',  # key=ServiceTime
        30: 'Read I/O distribution: 512 B||读IO分布：512B',  # key=ReadIOStatistics512B
        31: 'Read I/O distribution: 1 KB||读IO分布：1KB',  # key=ReadIOStatistics1KB
        32: 'Read I/O distribution: 2 KB||读IO分布：2KB',  # key=ReadIOStatistics2KB
        33: 'Read I/O distribution: 4 KB||读IO分布：4KB',  # key=ReadIOStatistics4K
        34: 'Read I/O distribution: 8 KB||读IO分布：8KB',  # key=ReadIOStatistics8KB
        35: 'Read I/O distribution: 16 KB||读IO分布：16KB',  # key=ReadIOStatistics16KB
        36: 'Read I/O distribution: 32 KB||读IO分布：32KB',  # key=ReadIOStatistics32KB
        37: 'Read I/O distribution: 64 KB||读IO分布：64KB',  # key=ReadIOStatistics64KB
        38: 'Read I/O distribution: 128 KB||读IO分布：128KB',  # key=ReadIOStatistics128KB
        39: 'Read I/O distribution: 256 KB||读IO分布：256KB',  # key=ReadIOStatistics256KB
        40: 'Read I/O distribution: 512 KB||读IO分布：512KB',  # key=ReadIOStatistics512KB
        41: 'Write I/O distribution: 512 B||写IO分布：512B',  # key=WriteIOStatistics512B
        42: 'Write I/O distribution: 1 KB||写IO分布：1KB',  # key=WriteIOStatistics1KB
        43: 'Write I/O distribution: 2 KB||写IO分布：2KB',  # key=WriteIOStatistics2KB
        44: 'Write I/O distribution: 4 KB||写IO分布：4KB',  # key=WriteIOStatistics4KB
        45: 'Write I/O distribution: 8 KB||写IO分布：8KB',  # key=WriteIOStatistics8KB
        46: 'Write I/O distribution: 16 KB||写IO分布：16KB',  # key=WriteIOStatistics16KB
        47: 'Write I/O distribution: 32 KB||写IO分布：32KB',  # key=WriteIOStatistics32KB
        48: 'Write I/O distribution: 64 KB||写IO分布：64KB',  # key=WriteIOStatistics64KB
        49: 'Write I/O distribution: 128 KB||写IO分布：128KB',  # key=WriteIOStatistics128KB
        50: 'Write I/O distribution: 256 KB||写IO分布：256KB',  # key=WriteIOStatistics256KB
        51: 'Write I/O distribution: 512 KB||写IO分布：512KB',  # key=WriteIOStatistics512KB
        52: 'Read and write I/O distribution: 512 B||读写IO分布：512B',  # key=ReadWriteIOStatistics512B
        53: 'Read and write I/O distribution: 1 KB||读写IO分布：1KB',  # key=ReadWriteIOStatistics1KB
        54: 'Read and write I/O distribution: 2 KB||读写IO分布：2KB',  # key=ReadWriteIOStatistics2KB
        55: 'Read and write I/O distribution: 4 KB||读写IO分布：4KB',  # key=ReadWriteIOStatistics4KB
        56: 'Read and write I/O distribution: 8 KB||读写IO分布：8KB',  # key=ReadWriteIOStatistics8KB
        57: 'Read and write I/O distribution: 16 KB||读写IO分布：16KB',  # key=ReadWriteIOStatistics16KB
        58: 'Read and write I/O distribution: 32 KB||读写IO分布：32KB',  # key=ReadWriteIOStatistics32KB
        59: 'Read and write I/O distribution: 64 KB||读写IO分布：64KB',  # key=ReadWriteIOStatistics64KB
        60: 'Total Write I/O Count||周期内写I/O总数',  # key=CycleWriteIOCnt
        61: 'Total Read I/O Count||周期内读I/O总数',  # key=CycleReadIOCnt
        62: 'Read and write I/O distribution: 512 KB||读写IO分布：512KB',  # key=ReadWriteIOStatistics512KB
        63: 'Total Write I/O during Periods||周期内写I/O总数',  # key=WriteIOInPeriod
        64: 'Total Read I/O during Periods||周期内读I/O总数',  # key=ReadIOInPeriod
        65: 'Random Sequence Ratio||随机顺序比例',  # key=RandomSequenceRatio
        66: 'Usage Ratio||使用率',  # key=Usage2
        67: 'Read Bandwidth Usage||带宽使用率',  # key=ReadBandWidthUsage
        68: 'CPU Usage (%)||CPU利用率 （%）',  # key=CPUUsage
        69: 'Memory Usage (%)||内存占用率 （%）',  # key=MemoryUsage
        70: 'Swap Usage||交换分区占用率',  # key=SwapUsage
        71: 'Network Read Traffic||网络当前读流量',  # key=NetReadTraffic
        72: 'Network Write Traffic||网络当前写流量',  # key=NetWriteTraffic
        73: 'Network Inbound Packages||网络当前进包数量',  # key=NetInPackage
        74: 'Network Outbound Packages||网络当前出包数量',  # key=NetOutPackage
        75: 'Operating Temperature||工作温度',  # key=WorkTemperture
        76: 'Power Consumption||功耗',  # key=PowerConsume
        77: 'Voltage||电压',  # key=Voltage
        78: 'Average I/O Latency (ms)||平均I/O响应时间 （ms）',  # key=AverageIOResponseTime
        79: 'Max. I/O Latency (ms)||最大I/O响应时间 （ms）',  # key=MaxIOResponseTime
        80: 'Dirty Page Percentage (%)||脏页比例 （%）',  # key=DirtyPageRatio
        81: 'Percentage of Cache Flushes to Write Requests (%)||刷Cache和写请求的比例 （%）',
        # key=RefreshCacheDivideWriteRequest
        82: 'Cache Flushing Bandwidth (MB/s)||刷Cache的带宽 （MB/s）',  # key=RefreshCacheBandWidth
        83: 'Cache Flushes Caused by the High Water Level (times)||高水位导致的刷Cache次数 （次）',
        # key=RefreshCacheBecauseHightWater
        84: 'Cache Flushes Caused by the Timer||定时器导致的刷Cache次数',  # key=RefreshCacheBecauseScheduleTimer
        85: 'Low Water Level Reaching Times (times)||Cache触及低水位次数（次）',  # key=CacheLowWater
        86: 'Full-stripe Write Request||全条带写请求',  # key=MaxBandWidthWrite
        87: 'Prefetch Traffic (MB/s)||预取流量 （MB/s）',  # key=FetchFlux
        88: 'Prefetch Rate (%)||预取效率 （%）',  # key=FetchRatio
        89: 'Read Cache Hits (times/s)||读Cache命中次数（次/秒）',  # key=ReadCacheHit
        90: 'Read Cache Not Hit Times (times/s)||读Cache未命中的次数（次/秒）',  # key=ReadCacheNotHit
        91: 'Read Cache Hits by Writes||读在写Cache命中的次数',  # key=ReadCacheHitWhenWrite
        92: 'Read Cache Hits by Reads||读在读Cache命中的次数',  # key=ReadCacheHitWhenRead
        93: 'Read Cache Hit Ratio (%)||读Cache命中率 （%）',  # key=ReadCacheRatio
        94: 'Read Cache Rehit Ratio||读Cache重命中率',  # key=ReadCacheReHitRatio
        95: 'Write Cache Hit Ratio||写Cache命中率',  # key=WriteCacheHitRatio
        96: 'Write Cache Rehit Ratio||写Cache重命中率',  # key=WriteCacheReHitRatio
        97: 'Write Cache Hits||写Cache命中次数',  # key=WriteCacheHit
        98: 'Write Cache Misses||写Cache未命中次数',  # key=WriteCacheNotHit
        99: 'Time Since Last Synchronization (s)||距上次同步的时间间隔 （s）',  # key=AsyncTime
        100: 'Unsynchronized Data Amount (MB)||未同步的数据量 （MB）',  # key=AsyncData
        101: 'Read Requests to the Snapshot Volume||快照卷上的读请求个数',  # key=ReadeRequestCntFromSnapshot
        102: 'Read Requests to the Source LUN||源LUN上的读请求个数',  # key=ReadeRequestCntFromSourceLUN
        103: 'Write Requests to the Source LUN||源LUN上的写请求个数',  # key=WriteRequestCntFromSourceLUN
        104: 'Snapshot Pool Read Requests||快照资源池中的读请求个数',  # key=ReadRequestCntSnapshotPool
        105: 'Snapshot Pool Write Requests||快照资源池中的写请求个数',  # key=WriteRequestCntSnapshotPool
        106: 'Writes Requests Exceeding the Chunk Size||大于Chunk大小的写请求个数',  # key=WriteRequestCntMorethanChunk
        107: 'Chunks Used by the Snapshot Copy||快照拷贝中所使用的Chunk的个数',  # key=ChunkCntUsedBySnapshotCopy
        108: 'Local Cache Usage (%)||本地Cache利用率（%）',  # key=LocalCacheUsage
        109: 'Mirror Cache Usage (%)||镜像Cache利用率 （%）',  # key=MirrorCacheUsage
        110: 'Cache Read Usage (%)||Cache读利用率 （%）',  # key=ReadCacheUsage
        111: 'Time for Host to Send Data (ms)||主机下发数据的耗时（ms）',  # key=Time for Host to Send Data (ms)
        112: 'Time for Saving Write Data (ms)||设备保存写数据的耗时（ms）',  # key=Time for Saving Write Data (ms)
        113: 'Time for Releasing Write Request Resources (ms)||释放写请求资源的耗时（ms）',
        # key=Time for Releasing Write Request Resources (ms)
        114: 'Time for Executing a Write Request (ms)||执行读请求的耗时（ms）',
        # key=Time for Executing a Write Request (ms)
        115: 'Time for Releasing Read Request Resources (ms)||释放读请求资源的耗时（ms）',
        # key=Time for Releasing Read Request Resources (ms)
        116: 'Cache Read I/O Latency (ms)||Cache读IO响应时间（ms）',  # key=Cache Read I/O Latency (ms)
        117: 'Cache Write I/O Latency (ms)||Cache写IO响应时间（ms）',  # key=Cache Write I/O Latency (ms)
        118: 'Cache Mirror I/O Latency (ms)||Cache镜像IO响应时间（ms）',  # key=Cache Mirror I/O Latency (ms)
        119: 'Time for Allocating Memory to a Write Request (ms)||写请求申请内存的耗时（ms）',
        # key=Time for Allocating Memory to a Write Request (ms)
        120: 'Cache Write Usage (%)||Cache写利用率（%）',  # key=Cache Write Usage (%)
        121: 'Number of Cache Data Flush I/Os||Cache写盘IO数（个）',  # key=Number of Cache Data Flush I/Os
        122: 'Number of Cache Data Flush Pages||Cache写盘页面数(个)',  # key=Number of Cache Data Flush Pages
        123: 'Read Bandwidth (KB/s)||读带宽（KB/s）',  # key=Read Bandwidth (KB/s)
        124: 'Write Bandwidth (KB/s)||写带宽 (KB/s)',  # key=Write Bandwidth (KB/s)
        125: 'Average Read I/O Size (Controller A) (KB)||读IO平均大小（A控）（KB）',
        # key=Average Read I/O (Controller A)
        126: 'Average Write I/O Size (Controller A) (KB)||写IO平均大小（A控）（KB）',
        # key=Average Write I/O (Controller A)
        127: 'Max. I/O Latency (Controller A) (ms)||最大IO响应时间（A控）（ms）',  # key=Max. I/O Latency (Controller A)
        128: 'Average I/O Latency (Controller A) (ms)||平均IO响应时间（A控）（ms）',
        # key=Average I/O Latency (Controller A)
        129: 'Usage Ratio (Controller A) (%)||利用率（A控）（%）',  # key=Usage Ratio (Controller A)
        130: 'Queue Length (Controller A)||队列长度（A控）（个）',  # key=Queue Length (Controller A)
        131: 'Service Time (Excluding Queue Time) (Controller A) (ms)||服务时间（A控）（ms）',
        # key=Service Time (Excluding Queue Time) (Controller A)
        132: 'Number of Combined Read I/Os per Second (Controller A)||每秒合并读IO的个数（A控）（个/秒）',
        # key=Number of Combined Read I/Os per Second (Controller A)
        133: 'Number of Combined Write I/Os per Second (Controller A)||每秒合并写IO的个数（A控）（个/秒）',
        # key=Number of Combined Write I/Os per Second (Controller A)
        134: 'Read Waiting Time (Controller A) (ms)||读等待时间（A控）（ms）',
        # key=Read Waiting Time (Controller A) (ms)
        135: 'Write Waiting Time (Controller A) (ms)||写等待时间（A控）（ms）',
        # key=Write Waiting Time (Controller A) (ms)
        136: 'Average I/O Size (Controller A)  (sector)||IO平均大小（A控）(sector)',
        # key=Average I/O Size (Controller A)  (sector)
        137: 'Average Read I/O Size (Controller B) (KB)||读IO平均大小（B控）（KB）',
        # key=Average Read I/O (Controller B)
        138: 'Average Write I/O Size (Controller B) (KB)||写IO平均大小（B控）（KB）',
        # key=Average Write I/O (Controller B)
        139: 'Max. I/O Latency (Controller B) (ms)||最大IO响应时间（B控）（ms）',  # key=Max. I/O Latency (Controller B)
        140: 'Average I/O Latency (Controller B) (ms)||平均IO响应时间（B控）（ms）',
        # key=Average I/O Latency (Controller B)
        141: 'Usage Ratio (Controller B) (%)||利用率（B控）（%）',  # key=Usage Ratio (Controller B)
        142: 'Queue Length (Controller B)||队列长度（B控）（个）',  # key=Queue Length (Controller B)
        143: 'Service Time (Excluding Queue Time) (Controller B) (ms)||服务时间（B控）（ms）',
        # key=Service Time (Excluding Queue Time) (Controller B)
        144: 'Number of Combined Read I/Os per Second (Controller B)||每秒合并读IO的个数（B控）（个/秒）',
        # key=Number of Combined Read I/Os per Second (Controller B)
        145: 'Number of Combined Write I/Os per Second (Controller B)||每秒合并写IO的个数（个/秒）',
        # key=Number of Combined Write I/Os per Second (Controller B)
        146: 'Read Waiting Time (Controller B) (ms)||读等待时间（B控）（ms）',
        # key=Read Waiting Time (Controller B) (ms)
        147: 'Write Waiting Time (Controller B) (ms)||写等待时间（B控）（ms）',
        # key=Write Waiting Time (Controller B) (ms)
        148: 'Average I/O Size (Controller B)  (sector)||IO平均大小（B控）(sector)',
        # key=Average I/O Size (Controller B)  (sector)
        149: 'Read I/O Granularity Distribution: [0K,4K) (%)||读IO粒度分布：[0K,4K) （%）',
        # key=Read I/O Granularity Distribution: [0K,4K) (%)
        150: 'Read I/O Granularity Distribution: [4K,8K) (%)||读IO粒度分布：[4K,8K) （%）',
        # key=Read I/O Granularity Distribution: [4K,8K) (%)
        151: 'Read I/O Granularity Distribution: [8K,16K) (%)||读IO粒度分布：[8K,16K) （%）',
        # key=Read I/O Granularity Distribution: [8K,16K) (%)
        152: 'Read I/O Granularity Distribution: [16K,32K) (%)||读IO粒度分布：[16K,32K) （%）',
        # key=Read I/O Granularity Distribution: [16K,32K) (%)
        153: 'Read I/O Granularity Distribution: [32K,64K) (%)||读IO粒度分布：[32K,64K) （%）',
        # key=Read I/O Granularity Distribution: [32K,64K) (%)
        154: 'Read I/O Granularity Distribution: [64K,128K) (%)||读IO粒度分布：[64K,128K) （%）',
        # key=Read I/O Granularity Distribution: [64K,128K) (%)
        155: 'Read I/O Granularity Distribution: [128K,256K) (%)||读IO粒度分布：[128K,256K) （%）',
        # key=Read I/O Granularity Distribution: [128K,256K) (%)
        156: 'Read I/O Granularity Distribution: [256K,512K) (%)||读IO粒度分布：[256K,512K) （%）',
        # key=Read I/O Granularity Distribution: [256K,512K) (%)
        157: 'Read I/O Granularity Distribution: [512K,1M) (%)||读IO粒度分布：[512K,1M)（%）',
        # key=Read I/O Granularity Distribution: [512K,1M) (%)
        158: 'Read I/O Granularity Distribution: [1M,2M) (%)||读IO粒度分布：[1M,2M) （%）',
        # key=Read I/O Granularity Distribution: [1M,2M) (%)
        159: 'Read I/O Granularity Distribution: [2M,+∞) (%)||读IO粒度分布：[2M,+∞) （%）',
        # key=Read I/O Granularity Distribution: [2M,+∞) (%)
        160: 'Write I/O Granularity Distribution: [0K,4K) (%)||写IO粒度分布：[0K,4K) （%）',
        # key=Write I/O Granularity Distribution: [0K,4K) (%)
        161: 'Write I/O Granularity Distribution: [4K,8K) (%)||写IO粒度分布：[4K,8K) （%）',
        # key=Write I/O Granularity Distribution: [4K,8K) (%)
        162: 'Write I/O Granularity Distribution: [8K,16K) (%)||写IO粒度分布：[8K,16K) （%）',
        # key=Write I/O Granularity Distribution: [8K,16K) (%)
        163: 'Write I/O Granularity Distribution: [16K,32K) (%)||写IO粒度分布：[16K,32K) （%）',
        # key=Write I/O Granularity Distribution: [16K,32K) (%)
        164: 'Write I/O Granularity Distribution: [32K,64K) (%)||写IO粒度分布：[32K,64K) （%）',
        # key=Write I/O Granularity Distribution: [32K,64K) (%)
        165: 'Write I/O Granularity Distribution: [64K,128K) (%)||写IO粒度分布：[64K,128K) （%）',
        # key=Write I/O Granularity Distribution: [64K,128K) (%)
        166: 'Write I/O Granularity Distribution: [128K,256K) (%)||写IO粒度分布：[128K,256K) （%）',
        # key=Write I/O Granularity Distribution: [128K,256K) (%)
        167: 'Write I/O Granularity Distribution: [256K,512K) (%)||写IO粒度分布：[256K,512K) （%）',
        # key=Write I/O Granularity Distribution: [256K,512K) (%)
        168: 'Write I/O Granularity Distribution: [512K,1M) (%)||写IO粒度分布：[512K,1M) （%）',
        # key=Write I/O Granularity Distribution: [512K,1M) (%)
        169: 'Write I/O Granularity Distribution: [1M,2M) (%)||写IO粒度分布：[1M,2M) （%）',
        # key=Write I/O Granularity Distribution: [1M,2M) (%)
        170: 'Write I/O Granularity Distribution: [2M,+∞) (%)||写IO粒度分布：[2M,+∞) （%）',
        # key=Write I/O Granularity Distribution: [2M,+∞) (%)
        171: 'Read and Write I/O Granularity Distribution: [0K,4K) (%)||读写IO粒度分布：[0K,4K) （%）',
        # key=Read and Write I/O Granularity Distribution: [0K,4K) (%)
        172: 'Read and Write I/O Granularity Distribution: [4K,8K) (%)||读写IO粒度分布：[4K,8K) （%）',
        # key=Read and Write I/O Granularity Distribution: [4K,8K) (%)
        173: 'Read and Write I/O Granularity Distribution: [8K,16K) (%)||读写IO粒度分布：[8K,16K) （%）',
        # key=Read and Write I/O Granularity Distribution: [8K,16K) (%)
        174: 'Read and Write I/O Granularity Distribution: [16K,32K) (%)||读写IO粒度分布：[16K,32K) （%）',
        # key=Read and Write I/O Granularity Distribution: [16K,32K) (%)
        175: 'Read and Write I/O Granularity Distribution: [32K,64K) (%)||读写IO粒度分布：[32K,64K) （%）',
        # key=Read and Write I/O Granularity Distribution: [32K,64K) (%)
        176: 'Read and Write I/O Granularity Distribution: [64K,128K) (%)||读写IO粒度分布：[64K,128K) （%）',
        # key=Read and Write I/O Granularity Distribution: [64K,128K) (%)
        177: 'Read and Write I/O Granularity Distribution: [128K,256K) (%)||读写IO粒度分布：[128K,256K) （%）',
        # key=Read and Write I/O Granularity Distribution: [128K,256K) (%)
        178: 'Read and Write I/O Granularity Distribution: [256K,512K) (%)||读写IO粒度分布：[256K,512K) （%）',
        # key=Read and Write I/O Granularity Distribution: [256K,512K) (%)
        179: 'Read and Write I/O Granularity Distribution: ≤ [512K,1M) (%)||读写IO粒度分布：[512K,1M) （%）',
        # key=Read and Write I/O Granularity Distribution: ≤ [512K,1M) (%)
        180: 'Read and Write I/O Granularity Distribution: [1M,2M) (%)||读写IO粒度分布：[1M,2M) （%）',
        # key=Read and Write I/O Granularity Distribution: [1M,2M) (%)
        181: 'Read and Write I/O Granularity Distribution: [2M,+∞) (%)||读写IO粒度分布：[2M,+∞) （%）',
        # key=Read and Write I/O Granularity Distribution: [2M,+∞) (%)
        182: 'OPS||OPS',  # key=OPS
        183: 'Number of Online User||在线用户数',  # key=Number of Online User
        184: 'File Space Hard Quota||硬配额空间容量',  # key=File Space Hard Quota
        185: 'Used Capacity||已用容量',  # key=Used Capacity
        186: 'Total Capacity||总容量',  # key=Total Capacity
        187: 'Dedupe Rate||重删率',  # key=Dedupe Rate
        188: 'Packets Transmitted Rate(Packets/s)||包传输速率(Packets/s)',  # key=Packets Transmitted Rate
        189: 'Packets Dropped Ratio(%)||丢包率(%)',  # key=Packets Dropped Ratio
        190: 'Packets Errors Ratio(%)||错误包率(%)',  # key=Packets Errors Ratio
        191: 'Packets Overruns Ratio(%)||包溢出率(%)',  # key=Packets Overruns Ratio
        192: 'Disk Busy Ratio(%)||磁盘繁忙度(%)',  # key=Disk Busy Ratio
        193: 'Packages Rate(%)||包吞吐率(%)',  # key=Packages Rate
        194: 'Remote Replicated Bandwidth（KB/S）||远程复制带宽（KB/s）',  # key=ATTR_REMOTE_REP_BAND
        195: 'Max Read I/O Latency||最大读IO响应时间（ms）',  # key=Max Read I/O Latency
        196: 'Max Write I/O Latency||最大写IO响应时间（ms）',  # key=Max Write I/O Latency
        197: 'Average Read I/O Latency||平均读IO响应时间（ms）',  # key=Average Read I/O Latency
        198: 'Average Write I/O Latency||平均写IO响应时间（ms）',  # key=Average Write I/O Latency
        199: 'Read I/O Latency Distribution: [0ms,10ms) (%)||读IO响应时间分布：[0ms,10ms) (%)',
        # key=Read I/O Latency Distribution: [0ms,10ms) (%)
        200: 'Read I/O Latency Distribution: [10ms,20ms) (%)||读IO响应时间分布：[10ms,20ms) (%)',
        # key=Read I/O Latency Distribution: [10ms,20ms) (%)
        201: 'Read I/O Latency Distribution: [20ms,50ms) (%)||读IO响应时间分布：[20ms,50ms) (%)',
        # key=Read I/O Latency Distribution: [20ms,50ms) (%)
        202: 'Read I/O Latency Distribution: [50ms,100ms) (%)||读IO响应时间分布：[50ms,100ms) (%)',
        # key=Read I/O Latency Distribution: [50ms,100ms) (%)
        203: 'Read I/O Latency Distribution: [100ms,200ms) (%)||读IO响应时间分布：[100ms,200ms) (%)',
        # key=Read I/O Latency Distribution: [100ms,200ms) (%)
        204: 'Read I/O Latency Distribution: [200ms,+∞) (%)||读IO响应时间分布：[200ms,+∞) (%)',
        # key=Read I/O Latency Distribution: [200ms,+∞) (%)
        205: 'Write I/O Latency Distribution: [0ms,10ms) (%)||写IO响应时间分布：[0ms,10ms) (%)',
        # key=Write I/O Latency Distribution: [0ms,10ms) (%)
        206: 'Write I/O Latency Distribution: [10ms,20ms) (%)||写IO响应时间分布：[10ms,20ms) (%)',
        # key=Write I/O Latency Distribution: [10ms,20ms) (%)
        207: 'Write I/O Latency Distribution: [20ms,50ms) (%)||写IO响应时间分布：[20ms,50ms) (%)',
        # key=Write I/O Latency Distribution: [20ms,50ms) (%)
        208: 'Write I/O Latency Distribution: [50ms,100ms) (%)||写IO响应时间分布：[50ms,100ms) (%)',
        # key=Write I/O Latency Distribution: [50ms,100ms) (%)
        209: 'Write I/O Latency Distribution: [100ms,200ms) (%)||写IO响应时间分布：[100ms,200ms) (%)',
        # key=Write I/O Latency Distribution: [100ms,200ms) (%)
        210: 'Write I/O Latency Distribution: [200ms,+∞) (%)||写IO响应时间分布：[200ms,+∞) (%)',
        # key=Write I/O Latency Distribution: [200ms,+∞) (%)
        211: 'Read and Write I/O Latency Distribution: [0ms,10ms) (%)||读写IO响应时间分布：[0ms,10ms) (%)',
        # key=Read and Write I/O Latency Distribution: [0ms,10ms) (%)
        212: 'Read and Write I/O Latency Distribution: [10ms,20ms) (%)||读写IO响应时间分布：[10ms,20ms) (%)',
        # key=Read and Write I/O Latency Distribution: [10ms,20ms) (%)
        213: 'Read and Write I/O Latency Distribution: [20ms,50ms) (%)||读写IO响应时间分布：[20ms,50ms) (%)',
        # key=Read and Write I/O Latency Distribution: [20ms,50ms) (%)
        214: 'Read and Write I/O Latency Distribution: [50ms,100ms) (%)||读写IO响应时间分布：[50ms,100ms) (%)',
        # key=Read and Write I/O Latency Distribution: [50ms,100ms) (%)
        215: 'Read and Write I/O Latency Distribution: [100ms,200ms) (%)||读写IO响应时间分布：[100ms,200ms) (%)',
        # key=Read and Write I/O Latency Distribution: [100ms,200ms) (%)
        216: 'Read and Write I/O Latency Distribution: [200ms,+∞) (%)||读写IO响应时间分布：[200ms,+∞) (%)',
        # key=Read and Write I/O Latency Distribution: [200ms,+∞) (%)
        217: 'Max CPU Usage||最大CPU利用率（%）',  # key=Max CPU Usage
        218: 'Max Memory Usage||最大内存利用率（%）',  # key=Max Memory Usage
        219: 'NFS Bandwidth||NFS带宽（MB/s）',  # key=NFS Bandwidth
        220: 'NFS In Bandwidth||in NFS带宽（MB/s）',  # key=NFS In Bandwidth
        221: 'NFS Out Bandwidth||out NFS带宽（MB/s）',  # key=NFS Out Bandwidth
        222: 'CIFS Bandwidth||CIFS带宽（MB/s）',  # key=CIFS Bandwidth
        223: 'CIFS In Bandwidth||in CIFS带宽（MB/s）',  # key=CIFS In Bandwidth
        224: 'CIFS Out Bandwidth||out CIFS带宽（MB/s）',  # key=CIFS Out Bandwidth
        225: 'Connected Client Count||已连接客户端个数（个）',  # key=Connected Client Count
        226: 'Connected NFS Client Count||NFS已连接客户端个数（个）',  # key=Connected NFS Client Count
        227: 'Connected CIFS Client Count||CIFS已连接客户端个数（个）',  # key=Connected CIFS Client Count
        228: 'Average IO Size||平均IO大小（KB）',  # key=Average IO Size
        229: 'Network Packet Rate||网络包流速（个/s）',  # key=Network Packet Rate
        230: 'Network Inbound Packet Rate||in网络包流速（个/s）',  # key=Network Inbound Packet Rate
        231: 'Network Outbound Packet Rate||out网络包流速（个/s）',  # key=Network Outbound Packet Rate
        232: 'Read OPS||每秒平均得到处理的读请求个数（个/s）',  # key=Read OPS
        233: 'Write OPS||每秒平均得到处理的写请求个数（个/s）',  # key=Write OPS
        234: 'Read Average IO Size||读平均IO大小（KB）',  # key=Average IO Size
        235: 'Write Average IO Size||写平均IO大小（KB）',  # key=Average IO Size
        236: 'Band Width（KB/s)||带宽（KB/s)',  # key=Band Width
        237: 'Read L2Cache Hit||读L2Cache命中次数（次/秒）',  # key=Read L2Cache Hit
        238: 'Read L2Cache NotHit||读L2Cache未命中次数（次/秒）',  # key=Read L2Cache NotHit
        239: 'Read L2Cache HitRatio||读L2Cache命中率（%）',  # key=Read L2Cache HitRatio
        240: 'Average QueueSize||平均队列深度',  # key=Average QueueSize
        241: 'Complete SCSI commands per second||每秒磁盘完成的总SCSI命令',  # key=Complete SCSI commands per second
        242: 'Verify commands per second||每秒Verify命令次数',  # key=Verify commands per second
        243: 'Disk Total capacity||磁盘的总容量（GB）',  # key=Disk Total capacity
        244: 'Disk alloced capacity||磁盘的已用容量（GB）',  # key=Disk alloced capacity
        245: 'Disk alloced Usage||已用容量百分比',  # key=Disk alloced Usage
        246: 'Disk Free Usage||空闲容量百分比',  # key=Disk Free Usage
        247: 'WP Count||脏数据页面数',  # key=WP Count
        248: 'WP Limit||脏数据页面限制',  # key=WP Limit
        249: '% WP Utilization||脏数据页面占页面的百分比',  # key=% WP Utilization
        250: '% Cache Used||已经使用的cache百分比',  # key=% Cache Used
        251: 'Host Hits/sec||每秒主机发送的读写IO能够立即在cache中找到的数目',  # key=Host Hits/sec
        252: 'Host Read Hits/sec||每秒主机发送的读IO能够立即在cache中找到的数目',  # key=Host Read Hits/sec
        253: 'Host Write Hits/sec||每秒主机发送的写IO能够立即在cache中找到的数目',  # key=Host Write Hits/sec
        254: 'Host Misses/sec||每秒主机发送的读写IO在cache中不能立即找到的数目',  # key=Host Misses/sec
        255: 'Host Read Misses/sec||每秒主机发送的读IO在cache中不能立即找到的数目',  # key=Host Read Misses/sec
        256: 'Host Write Misses/sec||每秒主机发送的写IO在cache中不能立即找到的数目',  # key=Host Write Misses/sec
        257: 'BE Reqs/sec||后端从磁盘到cache完成的读写请求数',  # key=BE Reqs/sec
        258: 'BE Read Reqs/sec||后端从磁盘到cache完成的读请求数',  # key=BE Read Reqs/sec
        259: 'BE Write Reqs/sec||后端从磁盘到cache完成的写请求数',  # key=BE Write Reqs/sec
        260: 'BE MBs transferred/sec||每秒的后端流量',  # key=BE MBs transferred/sec
        261: 'BE MBs Read/sec||每秒的后端读流量',  # key=BE MBs Read/sec
        262: 'BE MBs Written/sec||每秒的后端写流量',  # key=BE MBs Written/sec
        263: 'Read Miss Response Time (ms)||读丢失响应时间',  # key=Read Miss Response Time (ms)
        264: 'Write Miss Response Time (ms)||写丢失响应时间',  # key=Write Miss Response Time (ms)
        265: '% Read||读IO占总IO的百分比',  # key=% Read
        266: '% Write||写IO占总IO的百分比',  # key=% Write
        267: '% Read Hit||读IO占总读IO的百分比',  # key=% Read Hit
        268: '% Write Hit||写IO占总写IO的百分比',  # key=% Write Hit
        269: '% Read Miss||读丢失百分比',  # key=% Read Miss
        270: '% Write Miss||写丢失百分比',  # key=% Write Miss
        271: 'BE Read Request Time (ms)||后端读请求时间（从磁盘端口到cache）',  # key=BE Read Request Time (ms)
        272: 'BE Disk Read Response Time (ms)||后端读响应时间（从磁盘端口到cache）',  # key=BE Disk Read Response Time (ms)
        273: 'BE Read Task Time (ms)||后端读请求排队时间',  # key=BE Read Task Time (ms)
        274: 'BE Read Response Time (ms)||后端读响应时间（ms）',  # key=BE Read Response Time (ms)
        275: 'BE Write Response Time (ms)||后端写响应时间（ms）',  # key=BE Write Response Time (ms)
        276: 'BE Avg Response Time (ms)||后端平均响应时间（ms）',  # key=BE Avg Response Time (ms)
        277: 'BE % Reads||后端读请求百分比',  # key=BE % Reads
        278: 'BE % Writes||后端写请求百分比',  # key=BE % Writes
        279: 'Reqs/sec||前端端口到cache之间的数据传输请求数',  # key=Reqs/sec
        280: 'Read Reqs/sec||前端端口到cache之间的数据传输读请求数',  # key=Read Reqs/sec
        281: 'Write Reqs/sec||前端端口到cache之间的数据传输写请求数',  # key=Write Reqs/sec
        282: 'Read Hit Reqs/sec||每秒种所有前端端口发送的读请求直接命中数',  # key=Read Hit Reqs/sec
        283: 'Write Hit Reqs/sec||每秒种所有前端端口发送的写请求直接命中数',  # key=Write Hit Reqs/sec
        284: 'Miss Req/sec||每秒的请求丢失数',  # key=Miss Req/sec
        285: 'Read Miss Reqs/sec||每秒所有的前端端口丢失的总读请求数',  # key=Read Miss Reqs/sec
        286: 'Write Miss Reqs/sec||每秒所有的前端端口丢失的总写请求数',  # key=Write Miss Reqs/sec
        287: '% Read Reqs||读请求数占总请求数的百分比',  # key=% Read Reqs
        288: '% Write Reqs||写请求数占总请求数的百分比',  # key=% Write Reqs
        289: '% Hit Reqs||读写请求的命中率百分比',  # key=% Hit Reqs
        290: '% Read Req Hit||读请求的命中率百分比',  # key=% Read Req Hit
        291: 'IOs/sec||后端到磁盘的每秒IO数',  # key=IOs/sec
        292: 'Reqs/sec||后端端口到cache之间的数据传输请求数',  # key=Reqs/sec
        293: 'Read Reqs/sec||后端端口到cache之间的数据传输读请求数',  # key=Read Reqs/sec
        294: 'Write Reqs/sec||后端端口到cache之间的数据传输写请求数',  # key=Write Reqs/sec
        295: 'MBs/sec||读写流量',  # key=MBs/sec
        296: 'Port MBs/sec||端口的读写流量',  # key=Port MBs/sec
        297: 'Port IOs/sec||端口的读写IOPS',  # key=Port IOs/sec
        298: 'MBs Read/sec||每秒的读流量',  # key=MBs Read/sec
        299: 'MBs Written/sec||每秒的写流量',  # key=MBs Written/sec
        300: 'Port Avg Req Size||通过端口的平均IO请求数',  # key=Port Avg Req Size
        301: 'Max WP Threshold||脏数据页面最大数',  # key=Max WP Threshold
        302: 'Random Hits/sec||每秒随机命中数',  # key=Random Hits/sec
        303: '% Hit||命中百分比',  # key=% Hit
        304: '% Miss||未命中率',  # key=% Miss
        305: '% Random Reads||随机读百分比',  # key=% Random Reads
        306: '% Random Writes||随机写百分比',  # key=% Random Writes
        307: 'Max IOPS(IO/s)||最大IOPS(个/秒)',  # key=Max IOPS(IO/s)
        308: 'Failed IOs||执行失败的总IO数（个）',  # key=Failed IOs
        309: 'Failed IOs/sec||每秒的失败IO数（个/秒）',  # key=Failed IOs/sec
        310: 'Failed IO Ratio (%)||故障的IO率（%）',  # key=Failed IO Ratio (%)
        311: 'Throughput(MB/s)||吞吐量（MB/s）',  # key=Throughput
        312: 'Read Throughput(MB/s)||读吞吐量（MB/s）',  # key=ReadThroughput
        313: 'Write Throughput(MB/s)||写吞吐量（MB/s）',  # key=WirteThroughput
        314: 'util%||磁盘活动时间百分比（百分比）',  # key=util%
        315: 'Extent fragmentation-smaller than 8blk||小于8blk的extent百分比',
        # key=Extent fragmentation-smaller than 8blk
        316: 'Extent fragmentation-smaller than 64blk||小于64blk的extent百分比',
        # key=Extent fragmentation-smaller than 64blk
        317: 'Extent fragmentation-larger than 64blk||大于64blk的extent百分比',
        # key=Extent fragmentation-larger than 64blk
        318: 'usr%||用户使用率（百分比）',  # key=usr%
        319: 'sys%||系统使用率（百分比）',  # key=sys%
        320: 'wait%||io-wait使用率（百分比）',  # key=wait%
        321: 'idle%||空闲率（百分比）',  # key=idle%
        322: 'hiq%||硬中断使用率 （百分比）',  # key=hiq%
        323: 'siq%||软中断使用率（百分比）',  # key=siq%
        324: 'Swap Use||交换分区使用量（MB）',  # key=Swap Use
        325: 'Swap Free||交换分区未使用量（MB）',  # key=Swap Free
        326: 'Memory Use||内存使用量（MB）',  # key=Memory Use
        327: 'Memory Buffer||内存写缓存（MB）',  # key=Memory Buffer
        328: 'Memory Cache||内存读缓存（MB）',  # key=Memory Cache
        329: 'Memory Free||内存剩余量（MB）',  # key=Memory Free
        330: 'Memory Dirty Page||脏内存量（MB）',  # key=Memory Dirty Page
        331: 'Network Error Inbound Packets||错误进包数（Packets/s）',  # key=Network Error Inbound Packets
        332: 'Network Error Outbound Packets||错误出包数（Packets/s）',  # key=Network Error Outbound Packets
        333: 'Cache Water(%)||Cache水位（百分比）',  # key=CacheWater
        334: 'Total read MBs in special period||指定时间段的读流量',  # key=Total MBs Read
        335: 'Total write MBs in special period||指定时间段的写流量'  # key=Total MBs Write
    }

    '''
    '''
    PRODUCT_MODE_E = {
        0: 'V1500||V1500',  # key=V1500
        1: 'V1800||V1800',  # key=V1800
        2: 'S2100||S2100',  # key=S2100
        3: 'S2300||S2300',  # key=S2300
        4: 'S5100||S5100',  # key=S5100
        5: 'S5300||S5300',  # key=S5300
        6: 'S5500||S5500',  # key=S5500
        7: 'S5600||S5600',  # key=S5600
        8: 'VIS||VIS',  # key=VIS
        9: 'S2600||S2600',  # key=S2600
        10: 'S6800E||S6800E',  # key=S6800E
        11: 'V1500N||V1500N',  # key=V1500N
        12: 'S2300E||S2300E',  # key=S2300E
        13: 'COMMON||COMMON(插框混用)',  # key=COMMON
        15: 'N8000||N8000',  # key=N8000
        16: 'S6900||S6900',  # key=S6900
        17: 'S3900||S3900',  # key=S3900
        18: 'S5500T||S5500T',  # key=S5500T
        19: 'S5600T||S5600T',  # key=S5600T
        20: 'S6800T||S6800T',  # key=S6800T
        21: 'S6900-M100||S6900-M100',  # key=S6900_M100
        22: 'S3900-M200||S3900-M200',  # key=S3900_M200
        23: 'S3900-M300||S3900-M300',  # key=S3900_M300
        24: 'S5900-M100||S5900-M100',  # key=S5900_M100
        25: 'S8100||S8100',  # key=S8100
        26: 'S5800T||S5800T',  # key=S5800T
        27: 'V1600N||V1600N',  # key=V1600N
        28: 'S5900-M200||S5900-M200',  # key=S5900_M200
        29: 'N8001||N8001',  # key=N8001
        30: 'S2600T||S2600T',  # key=S2600T
        31: 'S8000-I||S8000-I',  # key=S8000_I
        32: 'Dorado5100||Dorado5100',  # key=Dorado5100
        33: 'T3200||T3200',  # key=T3200
        34: 'T3500||T3500',  # key=T3500
        35: 'N8000-R710||N8000-R710',  # key=N8000-R710
        36: 'N8000-C2||N8000-C2',  # key=N8000-C2
        40: 'N8000-C2-SYMC||N8000-C2-SYMC',  # key=N8000-C2-SYMC
        41: 'VTL||VTL',  # key=VTL
        42: 'S2900||S2900',  # key=S2900
        43: 'S2200T||S2200T',  # key=S2200T
        44: 'Dorado2100 G2||Dorado2100 G2',  # key=Dorado2100 G2
        45: 'VIS 6000||VIS 6000',  # key=VIS 6000
        46: 'HVS85T||HVS85T',  # key=HVS85T
        47: 'HVS88T||HVS88T',  # key=HVS88T
        48: '9000||9000',  # key=N9000
        49: 'T3200 G2||T3200 G2',  # key=T3200 G2
        50: 'T3500 G2||T3500 G2',  # key=T3500 G2
        51: 'T3200 G3||T3200 G3',  # key=T3200 G3
        52: 'T3500 G3||T3500 G3',  # key=T3500 G3
        53: 'S5700||S5700',  # key=S5700
        54: 'CE6800||CE6800',  # key=CE6800
        55: 'CE12800||CE12800',  # key=CE12800
        56: '18800F||18800F',  # key=HVS_18800F
        57: '18500||18500',  # key=HVS_18500
        58: '18800||18800',  # key=HVS_18800
        60: 'SSS||SSS',  # key=SSS
        61: '6800V3||6800V3',  # key=6800V3
        62: '6900V3||6900V3',  # key=6900V3
        63: '5600V3||5600V3',  # key=5600V3
        64: '5800V3||5800V3',  # key=5800V3
        65: 'T3200||T3200',  # key=T3200 MINI
        66: 'WUSHAN_SQL||WUSHAN_SQL',  # key=WUSHAN_SQL
        67: 'WUSHAN_HD||WUSHAN_HD',  # key=WUSHAN_HD
        68: '5500V3||5500V3',  # key=5500V3
        69: '2600V3||2600V3',  # key=2600V3
        70: '5300V3||5300V3',  # key=5300V3
        71: '2800V3||2800V3',  # key=2800V3
        72: '18500V3',  # key=18500V3
        73: '18800V3',  # key=18800V3
        78: '2200V3||2200V3',  # key=2200V3
        79: '5100V3||5100V3',  # key=5100V3
        82: '2600V3 for Video||2600V3 for Video',  # key=2600 V3 for Video
        108: '2100V3||2100V3',  # key=2100V3
        116: '5110V5||5110V5',  # key=5110V5
        117: '5110FV5||5110FV5',
        118: '5210V5||5210V5',
        119: '5210FV5||5210FV5',
        401: 'N5000||N5000',  # key=N5000
        800: 'VIS8200||VIS8200',  # key=VIS8200
        801: 'VIS8400||VIS8400',  # key=VIS8400
        802: 'VIS8600||VIS8600',  # key=VIS8600
        803: 'VIS8800||VIS8800',  # key=VIS8800
        805: 'Dorado5000 V3||Dorado5000 V3',  # key=Dorado5000 V3
        806: 'Dorado6000 V3||Dorado6000 V3',  # key=Dorado6000 V3
        810: 'Dorado3000 V3||Dorado3000 V3',  # key=Dorado3000 V3
    }

    '''
    '''
    LICENSE_FEATURE_E = {
        0: 'LUN Mapping||支持LUN映射数',  # key=LUNMapping
        1: 'Member Disks||支持的磁盘数',  # key=MemberDisks
        2: 'HyperSnap||快照',  # key=HyperSnap
        3: 'HyperClone||克隆',  # key=HyperClone
        4: 'HyperCopy||LUN拷贝',  # key=HyperCopy
        5: 'LUN Migration||LUN迁移',  # key=LUNMigration
        6: 'Synchronous Remote Mirror||同步远程复制',  # key=SynchronousRemoteMirror
        7: 'Asynchronous Remote Mirror||异步远程复制',  # key=AsynchronousRemoteMirror
        8: 'Expanded Copy||扩展拷贝',  # key=ExpandedCopy
        9: 'SmartCache||智能数据缓存',  # key=SmartCache
        10: 'ThinProvisioning||精简配置',  # key=ThinProvisioning
        20: 'SmartTier||智能数据分级',  # key=SmartTier
        21: 'SmartMotion||智能数据迅移',  # key=SmartMotion
        22: 'SmartQoS||智能服务质量控制',  # key=SmartQoS
        23: 'SmartDedup||智能重复数据删除',  # key=SmartDedup
        24: 'HyperReplication||远程复制',  # key=HyperReplication
        25: 'SmartThin||智能精简配置',  # key=SmartThin
        27: 'XVE System||XVE系统软件',  # key=XVESystem
        28: 'Management Console||管理软件',  # key=ManagementConsole
        29: 'SmartVirtulication||智能异构虚拟化',  # key=SmartVirtualization
        30: 'Hyper software suite||增值套件',  # key=HyperSoftwareSuite
        31: 'SmartCache&SmartTier||智能分级与缓存',  # key=SmartCache-SmartTier
        32: 'SmartQuota||配额管理',  # key=SmartQuota
        33: 'LoadBalance||负载均衡',  # key=LoadBalance
        34: 'Wushan FileSystem||巫山文件系统',  # key=WFS
        35: 'HVS Basic,NL-SAS,1TB||HVS基础软件包，NL-SAS，默认容量许可：1TB',  # key=HVS_BASIC_NLSAS
        36: 'HVS Basic,SSD&SAS,1TB||HVS基础软件包，SSD&SAS，默认容量许可：1TB',  # key=HVS_BASIC_SSD_SAS
        37: 'HVS Advanced,NL-SAS,1TB||HVS高级软件包，NL-SAS，默认容量许可：1TB',  # key=HVS_ADVANCED_NLSAS
        38: 'HVS Advanced,SSD&SAS,1TB||HVS高级软件包，SSD&SAS，默认容量许可：1TB',  # key=HVS_ADVANCED_SSD_SAS
        39: 'SmartCompression||智能数据压缩',  # key=SmartCompression
        40: 'SmartPartition||智能缓存分区',  # key=SmartPartition
        41: 'HyperShredder||数据销毁',  # key=HyperShredder
        42: 'System Reporter||System Reporter'  # key=SystemReporter
    }

    '''
    '''
    HEALTH_STATUS_E = {
        0: '--||未知',  # key=UNKNOWN
        1: 'Normal||正常',  # key=NORMAL
        2: 'Fault||故障',  # key=FAULT
        3: 'Pre-Fail||即将故障',  # key=PRE_FAIL
        4: 'partially broken||部分损坏',  # key=PART_BROKEN
        5: 'Degraded||降级',  # key=DEGRADE
        6: 'Bad sectors found||有坏块',  # key=HAS_BAD_BLOCK
        7: 'Bit errors found||有误码',  # key=HAS_ERR_CODE
        8: 'Consistent||一致',  # key=CONSISTENT
        9: 'Inconsistent||不一致',  # key=INCONSISTENT
        10: 'Busy||繁忙',  # key=BUSY
        11: 'No input||无输入',  # key=POWER_NO_INPUT
        12: 'Low battery||电量不足',  # key=POWER_NOT_ENOUGH
        13: 'Single link fault||单链路故障',  # key=SINGLE_LINK_FAULT
        14: 'Invalid||失效',  # key=INVALID
        15: 'Write_protect||写保护',  # key=WRITE_PROTECT
        16: 'SingleLink||单链路',  # key=SINGLE_LINK
        17: 'No Redundant Link||无冗余路径'  # key=NO_REDUNDANT_LINK
    }

    '''
    '''
    RUNNING_STATUS_E = {
        0: '--||未知',  # key=UNKNOWN
        1: 'Normal||正常',  # key=NORMAL
        2: 'Running||运行',  # key=RUNNING
        3: 'Not running||未运行',  # key=NOT_RUNNING
        4: 'Not existed||不存在',  # key=NOT_EXIST
        5: 'Sleep in high temperature||高温休眠',  # key=HIGH_TEMPERATURE_SLEEP
        6: 'Starting||正在启动',  # key=STARTING
        7: 'Power failure protection||掉电保护',  # key=POWER_FAILURE_PROTECTING
        8: 'Spin down||休眠',  # key=SLEEPING
        9: 'Started||已启动',  # key=SPINGUP
        10: 'Link Up||已连接',  # key=LINK_UP
        11: 'Link Down||未连接',  # key=LINK_DOWN
        12: 'Powering on||正在上电',  # key=POWER_ON
        13: 'Powered off||已下电',  # key=POWER_OFF
        14: 'Precopy||预拷贝',  # key=PRE_COPY
        15: 'Copyback||回拷',  # key=COPYBACK
        16: 'Reconstruction||重构',  # key=RECONSTRUCTION
        17: 'Expansion||扩容',  # key=EXPANSION
        18: 'Unformatted||未格式化',  # key=NOT_FORMAT
        19: 'Formatting||正在格式化',  # key=FORMATTING
        20: 'Unmapped||未映射',  # key=UNMAPPING
        21: 'Initial synchronizing||正在初始同步',  # key=INITIAL_SYNCHRONIZING
        22: 'Consistent||数据一致',  # key=CONSISTENT
        23: 'Synchronizing||正在同步',  # key=SYNCHRONIZING
        24: 'Synchronized||已同步',  # key=SYNCHRONIZED
        25: 'Unsynchronized||未同步',  # key=NOT_SYNCHRONIZED
        26: 'Splited||已分裂',  # key=SPLIT
        27: 'Online||在线',  # key=ONLINE
        28: 'Offline||离线',  # key=OFFLINE
        29: 'Locked||已锁定',  # key=LOCKED
        30: 'Enabled||已启用',  # key=ENABLE
        31: 'Disabled||已禁用',  # key=DISABLED
        32: 'balancing||正在均衡',  # key=LEVELING
        33: 'To be recovered||待恢复',  # key=TO_BE_RECOVERD
        34: 'Interrupted||异常断开',  # key=INTERRUPTED
        35: 'Invalid||失效',  # key=INVALID
        36: 'Not start||新创建',  # key=NOSTART
        37: 'Queuing||正在排队',  # key=QUEUING
        38: 'Stopped||已停止',  # key=STOP
        39: 'Copying||正在拷贝',  # key=COPYING
        40: 'Completed||拷贝完成',  # key=COMPLETED
        41: 'Paused||暂停',  # key=PAUSE
        42: 'Reverse synchronizing||正在反向同步',  # key=REVSYNCHRONIZING
        43: 'Activated||已激活',  # key=ACTIVATED
        44: 'Restore||正在回滚',  # key=ROLLBACK
        45: 'Inactive||未激活',  # key=INACTIVATED
        46: 'Idle||等待',  # key=IDLE
        47: 'Powering off||正在下电',  # key=POWERING_OFF
        48: 'Charging||正在充电',  # key=CHARGING
        49: 'Charging completed||充电完成',  # key=CHARGED
        50: 'Discharging||正在放电',  # key=DISCHARGING
        51: 'Upgrading||正在升级',  # key=UPGRADING
        52: 'Power Lost||掉电中',  # key=POWER_LOST
        53: 'Initializing||初始化中',  # key=INITIALIZING
        54: 'Apply Change||正在应用变更',  # key=APPLY_CONFIG_CHANGE
        55: 'online disable||在线禁用',  # key=ONLINE_DISABLE
        56: 'Offline disable||离线禁用',  # key=OFFLINE_DISABLE
        57: 'online frozen||在线冻结',  # key=ONLINE_FROZEN
        58: 'offline frozen||离线冻结',  # key=OFFLINE_FROZEN
        59: 'closed||已关闭',  # key=CLOSED
        60: 'removing||(节点)删除中',  # key=REMOVING
        61: 'in service||服务中',  # key=INSERVICE
        62: 'out of service||退出服务',  # key=OUTOFSERVICE
        63: 'Running normal||正在销毁',  # key=ERASEMENT_RUNNING_NORMAL
        64: 'Running fail||销毁失败',  # key=ERASEMENT_RUNNING_FAIL
        65: 'Running success||销毁成功',  # key=ERASEMENT_RUNNING_SUCCESS
        66: 'Running success||任务执行成功',  # key=SUCCESS
        67: 'Running failed||任务执行失败',  # key=FAILED
        68: 'Waiting||任务正在等待',  # key=WAITING
        69: 'Cancelling||任务正在取消',  # key=CANCELLING
        70: 'Cancelled||任务已取消',  # key=CANCELLED
        71: 'About to synchronize||在线|即将灾备同步',  # key=RUNNING_PREPARE_SYNC
        72: 'Synchronizing data||在线|正在灾备同步',  # key=RUNNING_SYNCHRONINING
        73: 'Failed to synchronize||在线|灾备同步失败',  # key=RUNNING_SYNC_FAILED
        74: 'MIGRATION_FAULT||迁移故障',  # key=MIGRATION_FAULT
        75: 'MiGRATING||迁移中',  # key=MiGRATING
        76: 'MIGRATION_COMPLETED||迁移完成',  # key=MIGRATION_COMPLETED
        103: 'POWER_ON_FAILED||上电失败'  # key=POWER_ON_FAILED
    }

    '''
    '''
    EVENT_LEVEL_E = {
        2: 'Info||提示',  # key=Info
        3: 'Warning||警告',  # key=Warning
        5: 'Major||重要',  # key=Major
        6: 'Critical||紧急'  # key=Critical
    }

    '''
    '''
    LUN_ALLOC_TYPE_E = {
        0: 'Thick LUN||Thick LUN',  # key=FAT
        1: 'Thin LUN||Thin LUN'  # key=THIN
    }

    '''
    '''
    IO_TYPE_E = {
        0: 'Read I/O||读I/O',  # key=READ
        1: 'Write I/O||写I/O',  # key=WRITE
        2: 'Read I/O and Write I/O||读I/O和写I/O'  # key=READ_WRITE
    }

    '''
    '''
    IOCLASS_SCHEDULE_POLICY_E = {
        0: 'ONCE||调度一次',  # key=ONCE
        1: 'DAILY||每日调度',  # key=DAILY
        2: 'WEEKLY||按周调度'  # key=WEEKLY
    }

    '''
    '''
    IOCLASS_PRIORITY_E = {
        0: 'Normal||正常',  # key=NORMAL
        1: 'High||高'  # key=HIGH
    }

    '''
    '''
    SNAP_BELONG_E = {
        1: 'Public||公有快照',  # key=PUBLIC
        2: 'Private||私有快照'  # key=PRIVATE
    }

    '''
    '''
    SNAP_SPEED_E = {
        1: 'Low||低',  # key=SPEED_LEVEL_LOW
        2: 'Middle||中',  # key=SPEED_LEVEL_MIDDLE
        3: 'High||高',  # key=SPEED_LEVEL_HIGH
        4: 'Asap||最高'  # key=SPEED_LEVEL_ASAP
    }

    '''
    '''
    ENCLOSURE_MODEL_E = {
        0: 'CTRL_BMC||BMC控制框',  # key=CTRL_BMC
        1: 'CTRL_SAS2U_12||2U SAS 12盘主控框',  # key=CTRL_SAS2U_12
        2: 'CTRL_SAS2U_24||2U SAS 24盘主控框',  # key=CTRL_SAS2U_24
        16: 'EXPSAS2U_12||2U SAS 12盘级联框',  # key=EXPSAS2U_12
        17: 'EXPSAS2U_24||2U SAS 24盘级联框',  # key=EXPSAS2U_24
        18: 'EXPSAS4U||4U 6Gbit/s SAS 24盘位 3.5英寸 硬盘框',  # key=EXPSAS4U
        19: 'EXPFC||4U FC 24盘级联框',  # key=EXPFC
        20: 'DSW_PCIe1U||1U PCIe数据交换机',  # key=DSW_PCIe1U
        21: 'EXPSAS4U_75||4U SAS 75盘级联框',  # key=EXPSAS4U_75
        22: 'SVP Controller Enclosure||SVP',  # key=SVP
        97: 'CTRL_6U||6U 4控独立机头',  # key=CTRL_6U
        96: 'CTRL_3U||3U 2控独立机头',  # key=CTRL_3U
        24: 'EXPSAS2U_25||2U 6Gbit/s SAS 25盘位 2.5英寸 硬盘框',  # key=EXPSAS2U_25
        25: 'EXPSAS4U_24_NEW||4U SAS 24盘3.5寸磁盘框（新）',  # key=EXPSAS4U_24_NEW
        26: 'CTRL_12GSAS_2U25_EAR||2U 12GSAS 25盘主控框',  # key=CTRL_12GSAS_2U25_EAR
        23: 'CTRL_12GSAS_2U12_EAR||2U 12GSAS 12盘主控框',  # key=CTRL_12GSAS_2U12_EAR
        65: '2U 25 Slot 2.5 SSD Disks Enclosure||2U SSD 25盘2.5寸级联框',
        # key=ENCLOSURE_MODEL_EXPSAS2U_25_12GLINK
        66: '4U 12G 24 Slot 3.5 SAS Disks Enclosure||4U SSD 24盘3.5寸级联框',  # key=CTRL_12GSAS_4U24_EAR_12GLINK
        67: "EXP_SAS2U_25||2U SAS 25盘位 2.5英寸 硬盘框",
        69: "EXP_SAS4U_24||4U SAS 24盘位 3.5英寸 硬盘框",
        99: "CTRL_NVMe2U_24||2U NVMe 2.5寸主控框",
        101: "EXP2U_JBOF||2U JBOF硬盘框",
        112: "CTRL_4U_4C||4U 四控 控制框",
        113: "CTRL_SAS2U_2C_25_MID||中端 2U 双控 SAS 25盘位 2.5英寸 控制框",
        114: "CTRL_SAS2U_2C_12_MID||中端 2U 双控 SAS 12盘位 2.5英寸 控制框",
        115: "CTRL_NVMe2U_2C_36||2U 双控 NVMe 36盘位 控制框",
        116: "CTRL_SAS2U_2C_25_LOW||低端 2U 双控 SAS 25盘位 2.5英寸 控制框",
        117: "CTRL_SAS2U_2C_12_LOW||低端 2U 双控 SAS 12盘位 2.5英寸 控制框",
        118: "EXP_IPSAS_2U_25||2U IP SAS 25盘位 2.5英寸 硬盘框",
        119: "EXP_IPSAS_2U_12||2U IP SAS 12盘位 3.5英寸 硬盘框",
        120: "EXP_IPNVMe_2U_36||2U IP NVMe 36盘位 硬盘框",
    }

    '''
    '''
    ENCLOSURE_TYPE_E = {
        0: 'EXP||级联框（硬盘框）',  # key=EXP
        1: 'CTRL||控制框',  # key=CTRL
        2: 'DSW||数据交换机',  # key=DSW
        3: 'MSW||管理交换机',  # key=MSW
        4: 'SVP||管理服务器'  # key=SVP
    }

    '''
    '''
    INTF_MODEL_E = {
        1: '4x4G FC Interface Module||4x4G FC接口模块',  # key=FC_4X4G
        2: '2x4G FC Interface Module||2x4G FC接口模块',  # key=FC_2X4G
        3: '2xGE Electrical Interface Module||2xGE 电接口模块',  # key=GE_RJ45_2X
        4: '4xSAS I Interface Module||4xSAS I 接口模块',  # key=SASI_4X
        5: 'Swapped FC Interface Module||Swapped FC接口模块',  # key=FC_4X4G_EXPAND
        6: '2x10GE Optical Interface Module||2x10GE 光接口模块',  # key=ETH10G_2
        7: '1x8G FC Optical Interface Module||1x8G FC光接口模块',  # key=FC_1X8G
        8: '2x8G FC Optical Interface Module||2x8G FC光接口模块',  # key=FC_2X8G
        9: '2xSAS II Electrical Interface Module||2xSAS II电接口模块',  # key=SASII_2X
        10: '4xSAS II Electrical Interface Module||4xSAS II电接口模块',  # key=SASII_4X
        11: '2xFC+2xGE Interface Module||2xFC+2xGE 接口模块',  # key=Combo_2FCx2GE
        12: '4xGE Electrical Interface Module||4xGE 电接口模块',  # key=iSCSI_4X
        13: '4x8G FC Optical Interface Module||4x8G FC光接口模块',  # key=FC_4X8G
        16: '4x mini-SAS Interface Module||4xmini-SAS接口模块',  # key=MINISAS_4X
        21: '4x10G Optical Interface Module||4x10G FCoE光接口模块',  # key=FCoE_4X
        22: '2x6G SAS Interface Module||2x6G SAS接口模块',  # key=SAS_2X6G
        23: '2x6G SAS Interface Module||2x6G SAS接口模块',  # key=SAS_2X6G
        24: 'Management Board||管理板',  # key=ManagerBoard
        25: '4x10GE Interface Module||4x10GE接口模块',  # key=TOE
        26: '2x5Gbps PCIe Interface Module||2x5Gbps PCIe接口模块',  # key=PCIe_2X5G
        27: '2x10G Optical Interface Module||2x10G FCoE光接口模块',  # key=FCoE_2X
        28: '4xGE Optical Interface Module||4xGE光接口模块',  # key=iSCSI_4XGE
        29: '2x16G FC Optical Interface Module||2x16G FC光接口模块',  # key=FC_2X16G
        30: '4x12SAS QSFP Interface Module||4x12G SAS光电接口模块 ',  # key=SAS_4X12G
        31: '4x10GE Electrical Interface Module||4x10GE 电接口模块 ',  # key=iSCSI_4X10
        32: '2x40GE Infiniband Interface Module||2x40GE IB接口模块',
        33: '2 port 4*14Gb IB I/O Module||2端口 4*14Gb IB I/O模块',
        34: '4xGE Electrical Interface Module||4xGE 电接口模块',
        35: 'Smart ACC Module||智能加速模块',
        36: '4x10GE Electrical Interface Module||4x10GE 电接口模块',
        37: '4 port SmartIO I/O Module||4端口 SmartIO I/O模块',  # key=IOC_4XSMART
        38: '8x8G FC Optical Interface Module||8x8G FC光接口模块',
        39: '4x8G FC Optical Interface Module||4x8G FC光接口卡',
        40: '4x16G FC Optical Interface Module||4x16G FC光接口卡',
        41: '12 port 4*12Gb SAS Back-End Interconnect I/O Module||12端口4*12Gb SAS后端全互联IO模块',
        44: '2 port PCIe Interface Module||2接口PCIe接口模块',
        58: '8x16G FC Optical Interface Module||8x16G FC光接口卡',
        65: "4 port SmartIO2.0 I/O module(optical SFP+)X16||4 端口 SmartIO2.0 I/O模块（光口SFP+）X16",
        66: "4 port SmartIO2.0 I/O module(optical SFP+)X8||4 端口 SmartIO2.0 I/O模块（光口SFP+）X8",
        67: "2 port 100Gb ETH I/O module(QSFP28)X16||2 端口 100Gb ETH I/O模块（QSFP28）X16",
        68: "2 port 100Gb ETH I/O module(QSFP28)X8||2 端口 100Gb ETH I/O模块（QSFP28）X8",
        71: "4 ports 10Gb ETH I/O module||4端口 10Gb ETH I/O模块",
    }

    '''
    '''
    INI_OR_TGT_E = {
        2: 'INI||启动器',  # key=INI
        3: 'TGT||目标器',  # key=TGT
        4: 'INI_AND_TGT||启动器和目标器'  # key=INI_AND_TGT
    }

    '''
    '''
    DISK_TYPE_E = {
        0: 'FC||FC',  # key=FC
        1: 'SAS||SAS',  # key=SAS
        2: 'SATA||SATA',  # key=SATA
        3: 'SSD||SSD',  # key=SSD
        4: 'NL_SAS||NL_SAS',  # key=NL_SAS
        5: 'SLC SSD||SLC SSD',  # key=SLC_SSD
        6: 'MLC SSD||MLC SSD',  # key=MLC_SSD
        7: 'FC_SED||FC_SED',  # key=FC_SED
        8: 'SAS_SED||SAS_SED',  # key=SAS_SED
        9: 'SATA_SED||SATA_SED',  # key=SATA_SED
        10: 'SSD_SED||SSD_SED',  # key=SSD_SED
        11: 'NL_SAS_SED||NL_SAS_SED',  # key=NL_SAS_SED
        12: 'SLC_SSD_SED||SLC_SSD_SED',  # key=SLC_SSD_SED
        13: 'MLC_SSD_SED||MLC_SSD_SED',  # key=MLC_SSD_SED
        14: 'NVMe SSD||NVMe SSD',  # key=NVMe_SSD
        16: 'NVME_SSD_SED||NVME_SSD_SED',  # key=NVME_SSD_SED
        17: 'SCM||SCM',  # key=SCM
        18: 'SCM_SED||SCM_SED'  # key=SCM_SED
    }

    '''
    '''
    DISK_LIGHT_STATUS_E = {
        0: 'OFF||OFF',  # key=OFF
        1: 'ON||ON'  # key=ON
    }

    '''
    '''
    DISK_LOGIC_TYPE_E = {
        1: 'FREE||空闲盘',  # key=FREE
        2: 'MEMBER||成员盘',  # key=MEMBER
        3: 'SPARE||热备盘',  # key=SPARE
        4: 'CACHE||缓存盘'  # key=CACHE
    }

    '''
    '''
    POWER_TYPE_E = {
        0: 'DC||DC',  # key=DC
        1: 'AC||AC'  # key=AC
    }

    '''
    '''
    BACKUP_POWER_TYPE_E = {
        0: 'BBU||BBU'  # key=BBU
    }

    '''
    '''
    '''
     Question：脚本传到界面的中文字符串，在再次传回来时，其中的中文都将变为乱码，导致JSON字符串无法解析。
     Status: 想办法解决中文字符串的传递问题
     Effective String: 很多
     0:'HOST||主机端口/业务端口', #key=HOST
    '''
    PORT_LOGIC_TYPE_E = {
        0: 'HOST||主机端口/业务端口',  # key=HOST
        1: 'EXP||级联端口',  # key=EXP
        2: 'MNGT||管理端口',  # key=MNGT
        3: 'INNER||内部端口',  # key=INNER
        4: 'MAINTENANCE||维护端口',  # key=MAINTENANCE
        5: 'MNGT_SRV||管理/业务混合口',  # key=MNGT_SRV
        6: 'MAINTENANCE_SRV||维护/业务混合口',  # key=MAINTENANCE_SRV
        7: 'BACKUP_MGR||备份管理网口',  # key=BACKUP_MGR
        8: 'PRODUCT_STORAGE||生产存储网口',  # key=PRODUCT_STORAGE
        9: 'BACKUP_STORAGE||备份存储网口',  # key=BACKUP_STORAGE
        10: 'ETH_NOT_CONFIG||未配置角色网口'  # key=ETH_NOT_CONFIG
    }

    '''
    '''
    PORT_SFP_STATUS_E = {
        0: 'NO_NEED||端口没有光模块',  # key=NO_NEED
        1: 'OFFLINE||离线',  # key=OFFLINE
        2: 'ONLINE||在线'  # key=ONLINE
    }

    '''
    '''
    FC_PORT_MODE_E = {
        0: 'Fabric||Fabric',  # key=FABRIC
        1: 'FC-AL||FC-AL',  # key=LOOP
        2: 'P2P||P2P',  # key=POINT2POINT
        3: 'Auto||Auto'  # key=AUTO
    }

    '''
    '''
    ETH_PORT_DUPLEX_E = {
        1: 'HALF_DUPLEX||半双工',  # key=HALF_DUPLEX
        2: 'DUPLEX||全双工',  # key=DUPLEX
        3: 'AUTO||自协商'  # key=AUTO
    }

    '''
    '''
    FAN_LEVEL_E = {
        0: 'LOW||低',  # key=LOW
        1: 'NORMAL||正常',  # key=NORMAL
        2: 'HIGH||高'  # key=HIGH
    }

    '''
    '''
    USER_LEVEL_E = {
        1: 'SUPER_ADMIN||超级管理员',  # key=SUPER_ADMIN
        2: 'ADMIN||管理员',  # key=ADMIN
        3: 'READONLY||只读用户',  # key=READONLY
        4: 'RESOURCE_ADMIN||资源管理员',  # key=RESOURCE_ADMIN
        5: 'DEVICE_ADMIN||设备管理员',  # key=DEVICE_ADMIN
        6: 'TENENT_ADMIN||租户管理员'  # key=TENENT_ADMIN
    }

    '''
    '''
    USER_STATE_E = {
        0: 'OFF_LINE||离线',  # key=OFF_LINE
        1: 'ON_LINE||在线',  # key=ON_LINE
        2: 'LOCKED||用户被锁定',  # key=LOCKED
        3: 'PWD_EXPIRED||密码过期',  # key=PWD_EXPIRED
        4: 'PWD_INITIAL||用户密码处于初始化状态，需要修改',  # key=PWD_INITIAL
        5: 'PWD_EXPIRING||密码即将到期'  # key=PWD_EXPIRING
    }

    '''
    '''
    USER_SCOPE_E = {
        0: 'Local||本地用户',  # key=LOCAL
        1: 'LDAP User||LDAP用戶',  # key=LDAP
        2: 'LDAP User Group||LDAP用户组',  # key=LDAP_GROUP
        3: 'SFTP User||SFTP用户',  # key=SFTP_USER
        4: 'Machine to Machine User||机机交互用户'  # key=M2M_USER
    }

    '''
    '''
    DOMAIN_AUTH_SERVICE_TYPE_E = {
        0: 'LDAP||ldap验证'  # key=LDAP
    }

    '''
    '''
    SPEED_LEVEL_3_E = {
        1: 'low||低',  # key=LOW
        2: 'medium||中',  # key=MEDIUM
        3: 'high||高'  # key=HIGH
    }

    '''
    '''
    DST_RUNNING_STATUS_E = {
        1: 'Ready||准备',  # key=READY
        2: 'Migrating||迁移',  # key=MIGRATING
        3: 'Paused||暂停'  # key=PAUSED
    }

    '''
    '''
    PREDICTION_SWITCH_E = {
        1: 'On||开',  # key=ON
        2: 'Off||关'  # key=OFF
    }

    '''
    '''
    MIGRATION_MODE_E = {
        1: 'Schedule||定时',  # key=AUTO
        2: 'Manual||手动'  # key=MANUAL
    }

    '''
    '''
    TRIGGER_MODE_E = {
        1: 'Auto||自动',  # key=AUTO
        2: 'Schedule||定时',  # key=SCHEDULE
        3: 'Manual||手动'  # key=MANUAL
    }

    '''
    '''
    HIBERNATE_MANNER_E = {
        1: 'Stop Running||停转',  # key=STOP_RUNNING
        2: 'Power Off||下电'  # key=POWEROFF
    }

    '''
    '''
    HOTSPARE_SPACE_STRATEGY_E = {
        1: 'Low||低',  # key=LOW
        2: 'High||高',  # key=HIGH
        3: 'None||无'  # key=NONE
    }

    '''
    '''
    DST_STATUS_E = {
        1: 'active||激活',  # key=ACTIVE
        2: 'inactive||未激活'  # key=INACTIVE
    }

    '''
    '''
    SWITCH_E = {
        1: 'on||开',  # key=ON
        2: 'off||关'  # key=OFF
    }

    '''
    '''
    BST_TYPE_E = {
        1: 'LOGIC_BST||逻辑坏扇区',  # key=LOGIC_BST
        2: 'PHYSICAL_BST||物理坏扇区'  # key=PHYSICAL_BST
    }

    '''
    '''
    TASK_TYPE_E = {
        1: 'Precopy||预拷贝',  # key=TASK_PRECOPY
        2: 'Reconstruct||重构',  # key=TASK_RECONSTRUCT
        3: 'Migration||迁移',  # key=TASK_MIGRATION
        4: 'Format||格式化'  # key=TASK_FORMAT
    }

    '''
    '''
    LUN_STRIPE_UNIT_SIZE_E = {
        8: 'LUN_STRIPE_UNIT_SIZE_8K||分条深度为8KB',  # key=LUN_STRIPE_UNIT_SIZE_8K
        16: 'LUN_STRIPE_UNIT_SIZE_16K||分条深度为16KB',  # key=LUN_STRIPE_UNIT_SIZE_16K
        32: 'LUN_STRIPE_UNIT_SIZE_32K||分条深度为32KB',  # key=LUN_STRIPE_UNIT_SIZE_32K
        64: 'LUN_STRIPE_UNIT_SIZE_64K||分条深度为64KB',  # key=LUN_STRIPE_UNIT_SIZE_64K
        128: 'LUN_STRIPE_UNIT_SIZE_128K||分条深度为128KB',  # key=LUN_STRIPE_UNIT_SIZE_128K
        256: 'LUN_STRIPE_UNIT_SIZE_256K||分条深度为256KB',  # key=LUN_STRIPE_UNIT_SIZE_256K
        512: 'LUN_STRIPE_UNIT_SIZE_512K||分条深度为512KB',  # key=LUN_STRIPE_UNIT_SIZE_512K
        1024: 'LUN_STRIPE_UNIT_SIZE_1024K||分条深度为1024KB'  # key=LUN_STRIPE_UNIT_SIZE_1024K
    }

    '''
    '''
    CACHE_WRITE_BACK_E = {
        1: 'WRITE_BACK||回写',  # key=WRITE_BACK
        2: 'WRITE_THROUGH||透写',  # key=WRITE_THROUGH
        3: 'WRITE_BACK_MANDATORY||强制回写',  # key=WRITE_BACK_MANDATORY
        4: 'MIXED||混合'  # key=MIXED
    }

    '''
    '''
    CACHE_MIRROR_STATUS_E = {
        0: 'CACHE_MIRROR_DISABLE||非镜像',  # key=CACHE_MIRROR_DISABLE
        1: 'CACHE_MIRROR_ENABLE||镜像'  # key=CACHE_MIRROR_ENABLE
    }

    '''
    '''
    CACHE_READ_AHEAD_STRATEGY_E = {
        0: 'CACHE_READ_AHEAD_STRATEGY_NOTHING||不预取',  # key=CACHE_READ_AHEAD_STRATEGY_NOTHING
        1: 'CACHE_READ_AHEAD_STRATEGY_FASTNESS||固定预取',  # key=CACHE_READ_AHEAD_STRATEGY_FASTNESS
        2: 'CACHE_READ_AHEAD_STRATEGY_MULTIPLIER||可变预取',  # key=CACHE_READ_AHEAD_STRATEGY_MULTIPLIER
        3: 'CACHE_READ_AHEAD_STRATEGY_INTELLIGENT||只能预取'  # key=CACHE_READ_AHEAD_STRATEGY_INTELLIGENT
    }

    '''
    '''
    RAID_LEVEL_E = {
        0: 'NONE||RAID_LEVEL_NONE',  # key=RAID_LEVEL_NONE
        1: 'RADI10||RAID_LEVEL_RAID10',  # key=RAID_LEVEL_RAID10
        2: 'RAID5||RAID_LEVEL_RAID5',  # key=RAID_LEVEL_RAID5
        3: 'RAID0||RAID_LEVEL_RAID0',  # key=RAID_LEVEL_RAID0
        4: 'RAID1||RAID_LEVEL_RAID1',  # key=RAID_LEVEL_RAID1
        5: 'RAID6||RAID_LEVEL_RAID6',  # key=RAID_LEVEL_RAID6
        6: 'RAID50||RAID_LEVEL_RAID50',  # key=RAID_LEVEL_RAID50
        7: 'RAID3||RAID_LEVEL_RAID3',  # key=RAID_LEVEL_RAID3
        8: 'RAID60||RAID_LEVEL_RAID60'  # key=RAID_LEVEL_RAID60
    }

    '''
    '''
    RM_UPDATE_TYPE_E = {
        1: 'RM_UPDATE_TYPE_MANUAL||手动',  # key=RM_UPDATE_TYPE_MANUAL
        2: 'RM_UPDATE_TYPE_AUTO_START_TIMING||同步开始后定时等待',  # key=RM_UPDATE_TYPE_AUTO_START_TIMING
        3: 'RM_UPDATE_TYPE_AUTO_END_TIMING||同步完成后定时等待'  # key=RM_UPDATE_TYPE_AUTO_END_TIMING
    }

    '''
    '''
    RM_LUN_MIRROR_STATE_E = {
        1: 'RM_LUN_MIRROR_STATE_SYNCED||已同步',  # key=RM_LUN_MIRROR_STATE_SYNCED
        2: 'RM_LUN_MIRROR_STATE_CONSISTENT||完整',  # key=RM_LUN_MIRROR_STATE_CONSISTENT
        3: 'RM_LUN_MIRROR_STATE_SYNCING||正在同步',  # key=RM_LUN_MIRROR_STATE_SYNCING
        4: 'RM_LUN_MIRROR_STATE_INIT_SYNCING||正在初始同步',  # key=RM_LUN_MIRROR_STATE_INIT_SYNCING
        5: 'RM_LUN_MIRROR_STATE_INCONSISTENT||不完整'  # key=RM_LUN_MIRROR_STATE_INCONSISTENT
    }

    '''
    '''
    SPEED_LEVEL_E = {
        1: 'Low||低',  # key=SPEED_LEVEL_LOW
        2: 'Middle||中',  # key=SPEED_LEVEL_MIDDLE
        3: 'High||高',  # key=SPEED_LEVEL_HIGH
        4: 'Asap||最快'  # key=SPEED_LEVEL_ASAP
    }

    '''
    '''
    LUN_RELATION_E = {
        1: 'LUN_RELATION_MASTER||主LUN或源lUN',  # key=LUN_RELATION_MASTER
        2: 'LUN_RELATION_SLAVE||从LUN或目标LUN'  # key=LUN_RELATION_SLAVE
    }

    '''
    '''
    CPY_TYPE_E = {
        1: 'CPY_TYPE_FULL||全量',  # key=CPY_TYPE_FULL
        2: 'CPY_TYPE_INCREMENT||增量'  # key=CPY_TYPE_INCREMENT
    }

    '''
    '''
    EXC_AND_REC_MODE_E = {
        1: 'EXC_AND_REC_MODE_AUTO||自动',  # key=EXC_AND_REC_MODE_AUTO
        2: 'EXC_AND_REC_MODE_MANUAL||手动'  # key=EXC_AND_REC_MODE_MANUAL
    }

    '''
    '''
    HYPERCOPY_LUN_TYPE_E = {
        0: 'HYPERCOPY_LUN_TYPE_LOCAL||本阵列的LUN',  # key=HYPERCOPY_LUN_TYPE_LOCAL
        1: 'HYPERCOPY_LUN_TYPE_EXTS5000||外部私有阵列的LUN',  # key=HYPERCOPY_LUN_TYPE_EXTS5000
        2: 'HYPERCOPY_LUN_TYPE_THIRD||第三方阵列的LUN'  # key=HYPERCOPY_LUN_TYPE_THIRD
    }

    '''
    '''
    HYPERCLONE_LUN_STATUS_E = {
        1: 'HYPERCLONE_LUN_STATUS_INCONSISTENT||数据不一致',  # key=HYPERCLONE_LUN_STATUS_INCONSISTENT
        2: 'HYPERCLONE_LUN_STATUS_REVINCONSISTENT||反向数据不一致',  # key=HYPERCLONE_LUN_STATUS_REVINCONSISTENT
        3: 'HYPERCLONE_LUN_STATUS_SYNCHRONIZING||同步中',  # key=HYPERCLONE_LUN_STATUS_SYNCHRONIZING
        4: 'HYPERCLONE_LUN_STATUS_REVSYNCHRONIZING||反向同步中',  # key=HYPERCLONE_LUN_STATUS_REVSYNCHRONIZING
        5: 'HYPERCLONE_LUN_STATUS_CONSISTENT||数据一致',  # key=HYPERCLONE_LUN_STATUS_CONSISTENT
        6: 'HYPERCLONE_LUN_STATUS_SYNCHRONIZED||同步完成',  # key=HYPERCLONE_LUN_STATUS_SYNCHRONIZED
        7: 'HYPERCLONE_LUN_STATUS_FAULT||故障'  # key=HYPERCLONE_LUN_STATUS_FAULT
    }

    '''
    '''
    EPL_ARRAY_TYPE_E = {
        1: 'EPL_ARRAY_PRIVATE||本厂商设备',  # key=EPL_ARRAY_PRIVATE
        2: 'EPL_ARRAY_3RD||第三方设备',  # key=EPL_ARRAY_3RD
        3: 'EPL_ARRAY_UNKNOWN||未知设备'  # key=EPL_ARRAY_UNKNOWN
    }

    '''
    '''
    SNAPSHOT_STATUS_E = {
        1: 'SNAPSHOT_STATUS_DISABLE||停用',  # key=SNAPSHOT_STATUS_DISABLE
        2: 'SNAPSHOT_STATUS_ACTIVE||激活',  # key=SNAPSHOT_STATUS_ACTIVE
        3: 'SNAPSHOT_STATUS_ROLLBACK||回滚',  # key=SNAPSHOT_STATUS_ROLLBACK
        4: 'SNAPSHOT_STATUS_ERROR||错误'  # key=SNAPSHOT_STATUS_ERROR
    }

    '''
    '''
    RM_MODEL_E = {
        1: 'RM_MODEL_SYNC||同步',  # key=RM_MODEL_SYNC
        2: 'RM_MODEL_ASYNC||异步'  # key=RM_MODEL_ASYNC
    }

    '''
    '''
    WORM_LUN_STATE = {
        1: 'WORM_LUN_READ_ONLY||只读',  # key=WORM_LUN_READ_ONLY
        2: 'WORM_LUN_READ_WRITE||读写'  # key=WORM_LUN_READ_WRITE
    }

    '''
    '''
    TargetSessionIdentifyingHandle_E = {
        2: 'Discovery||Discovery',  # key=Discovery
        3: 'Normal||Normal'  # key=Normal
    }

    '''
    '''
    OS_TYPE_E = {
        0: 'Linux||Linux',  # key=Linux
        1: 'Windows||Windows',  # key=Windows
        2: 'Solaris||Solaris',  # key=Solaris
        3: 'HP-UX||HP-UX',  # key=HPUX
        4: 'AIX||AIX',  # key=AIX
        5: 'XenServer||XenServer',  # key=XenServer
        6: 'Mac OS||Mac OS',  # key=MacOS
        7: 'Vmware ESX||Vmware ESX',  # key=ESX
        8: 'Linux||Linux'  # key=LINUX_VIS
    }

    '''
    '''
    REMOTE_DEVICE_SCOPE_E = {
        1: 'All Remote Device||所有已经创建的远端设备',  # key=ALL_CREATED
        2: 'Linked Remote Device||所有已经创建的且处于已连接状态的远端设备'  # key=CREATED_AND_LINKED
    }

    '''
    '''
    EXPBOARD_TYPE_E = {
        0: 'SAS||SAS',  # key=SAS
        1: 'FC||FC'  # key=FC
    }

    '''
    '''
    INIT_TIER_POLICY_E = {
        0: 'automatic||自动',  # key=INIT_TIER_POLICY_AUTO
        1: 'Extreme Performance||最高性能',  # key=INIT_TIER_POLICY_EXTREME_PERFORMANCE
        2: 'Performance||性能',  # key=INIT_TIER_POLICY_PERFORMANCE
        3: 'Capacity||容量'  # key=INIT_TIER_POLICY_CAPACITY
    }

    '''
    '''
    MIGRATE_LUN_POLICY_E = {
        0: 'None||不迁移',  # key=MIGRATE_LUN_POLICY_NONE
        1: 'Auto||自动迁移',  # key=MIGRATE_LUN_POLICY_AUTO
        2: 'Highest Available||向高性能层迁移',  # key=MIGRATE_LUN_POLICY_HIGHEST
        3: 'Lowest Available||向低性能层迁移'  # key=MIGRATE_LUN_POLICY_LOWEST
    }

    '''
    '''
    SFP_MODE_E = {
        0: 'None||单模',  # key=SINGLEMODE
        1: 'Auto||多模'  # key=MULTIMODE
    }

    '''
    '''
    DISKSCAN_IOTYPE_E = {
        1: 'read||读',  # key=READ
        2: 'verify||验证'  # key=VERIFY
    }

    '''
    '''
    HOSTGROUP_WORKMODE_E = {
        0: 'A/P-F||A/P-F',  # key=APF
        1: 'A/A-A||A/A-A'  # key=AAA
    }

    '''
    '''
    IP_SEC_RULE_E = {
        1: 'WHITE NAME LIST||白名单',  # key=WHITE_NAME_LIST
        2: 'BLACK_NAME_LIST||黑名单'  # key=BLACK_NAME_LIST
    }

    '''
    '''
    TRAP_VERSION_E = {
        1: 'SNMPV1||SNMPV1',  # key=TRAP_V1
        2: 'SNMPV2c||SNMPV2c',  # key=TRAP_V2C
        3: 'SNMPV3||SNMPV3'  # key=TRAP_V3
    }

    '''
    '''
    TRAP_TYPE_E = {
        1: 'TRAP_HUAWEI||Huawei Trap',  # key=TRAP_HUAWEI
        2: 'TRAP_HUAWEISYMANTEC||HuaweiSymantec Trap',  # key=TRAP_HUAWEISYMANTEC
        3: 'TRAP_ALL||All Trap'  # key=TRAP_ALL
    }

    '''
    '''
    LDAP_MAP_TYPE_E = {
        0: 'USER_MAP||LDAP用户映射',  # key=USER_MAP
        1: 'GROUP_MAP||LDAP组映射'  # key=GROUP_MAP
    }

    '''
    '''
    LDAP_DIRECTORY_TYPE_E = {
        1: 'LDAP||LDAP',  # key=LDAP
        2: 'AD||AD'  # key=AD
    }

    '''
    '''
    LDAP_TRANSFER_E = {
        1: 'LDAP||LDAP',  # key=LDAP
        2: 'LDAPS||LDAPS'  # key=LDAPS
    }

    '''
    '''
    SCHEDULE_TYPE_E = {
        1: 'IO Monitoring Schedule||IO监控时刻表',  # key=MONITOR_SCHEDULE
        2: 'Migration Schedule||迁移时刻表',  # key=MIGRATION_SCHEDULE
        3: 'Spindown Schedule||休眠时刻表'  # key=SPINDOWN_SCHEDULE
    }

    '''
    '''
    ENUM_ROUTE_TYPE_E = {
        0: 'Net||网段路由',  # key=ROUTE_TYPE_NET
        1: 'Host||主机路由',  # key=ROUTE_TYPE_HOST
        2: 'Default||默认路由'  # key=ROUTE_TYPE_DEFAULT
    }

    '''
    '''
    MULTIPATH_TYPE_E = {
        0: 'Defalut||默认',  # key=DEFAULT
        1: 'ALUA||ALUA'  # key=ALUA
    }

    '''
    '''
    iSCSI_Session_Type_E = {
        0: 'Discovery||Normal',  # key=Normal
        1: 'Normal||Discovery'  # key=Discovery
    }

    '''
    '''
    BAD_DISK_TYPY_E = {
        1: 'REGISTER_FAILED||注册失败',  # key=REGISTER_FAILED
        2: 'WRITE_PROTECT||写保护',  # key=WRITE_PROTECT
        3: 'SLOW_DISK||慢盘',  # key=SLOW_DISK
        4: 'FAULT_DISK||故障盘'  # key=FAULT_DISK
    }

    '''
    '''
    SET_QUOTA_STATUS = {
        1: 'NOT_SUPPORT||不支持',  # key=NOT_SUPPORT
        2: 'NOT_SET||未设置',  # key=NOT_SET
        3: 'SET_DIR_QUOTA||已设置目录配额（未设置用户配额）',  # key=SET_DIR_QUOTA
        4: 'SET_USER_QUOTA||已设置用户配额（也设置了目录配额）'  # key=SET_USER_QUOTA
    }

    '''
    '''
    POSITION_TYPE = {
        1: 'Not in position||不再为',  # key=NOT_POSITION
        2: 'In position||在位'  # key=POSITION
    }

    '''
    '''
    DEPLOY_STATUS = {
        1: 'CREATE_CONNECTION||建立连接',  # key=CREATE_CONNECTION
        2: 'DOWNLOAD_CONFIG_FILE||下载配置文件',  # key=DOWNLOAD_CONFIG_FILE
        3: 'PARSE_CONFIG_FILE||解析配置文件',  # key=PARSE_CONFIG_FILE
        4: 'DOWNLOAD_PACKAGE||下载软件包%s',  # key=DOWNLOAD_PACKAGE
        5: 'DEPLOY_NETWORK||配置网络',  # key=DEPLOY_NETWORK
        6: 'DEPLOY_IPMI||配置IPMI',  # key=DEPLOY_IPMI
        7: 'INSTALL_SOFTWARE||安装软件%s',  # key=INSTALL_SOFTWARE
        8: 'DEPLOY_SOFTWARE||配置软件%s',  # key=DEPLOY_SOFTWARE
        9: 'START_STFTWARE||启动软件%s',  # key=START_STFTWARE
        10: 'DEPLOYFINISH||部署完成'  # key=DEPLOYFINISH
    }

    '''
    '''
    DEPLOY_ERROR_CODE = {
    }

    '''
    '''
    POWERON_STATUS_E = {
        0: 'POWERON_SUCCESS||POWERON_SUCCESS',  # key=POWERON_SUCCESS
        1: 'POWERON_FAIL||POWERON_FAIL',  # key=POWERON_FAIL
        2: 'POWERON_POWERONING||POWERON_POWERONING',  # key=POWERON_POWERONING
        3: 'POWEROFF||POWEROFF'  # key=POWEROFF
    }

    '''
    '''
    SYSTEM_ROLE_E = {
        0: 'SYSTEM_ROLE_NORMAL||SYSTEM_ROLE_NORMAL',  # key=SYSTEM_ROLE_NORMAL
        1: 'SYSTEM_ROLE_MASTER||SYSTEM_ROLE_MASTER',  # key=SYSTEM_ROLE_MASTER
        2: 'SYSTEM_ROLE_SLAVE||SYSTEM_ROLE_SLAVE'  # key=SYSTEM_ROLE_SLAVE
    }

    '''
    '''
    PRIORITY_E = {
        1: 'Low||低',  # key=LOW
        2: 'Middle||中',  # key=MIDDLE
        3: 'High||高'  # key=HIGH
    }

    '''
    '''
    REMOTE_DEVICE_SERVICE_TYPE_E = {
        1: 'LUN_COPY||LUN拷贝',  # key=LUN_COPY
        2: 'REMOTE_REPLICATION||远程复制'  # key=REMOTE_REPLICATION
    }

    '''
    '''
    STORAGE_CAPABILITY = {
        0: 'NoProtected||NoProtected',  # key=NoProtected
        1: 'Capacity||Capacity',  # key=Capacity
        2: 'Performance||Performance',  # key=Performance
        3: 'Extreme Performance||ExtremePerformance',  # key=ExtremePerformance
        4: 'Muti-Tiers||Muti-Tiers'  # key=Muti-Tiers
    }

    '''
    '''
    SPECIALITY_E = {
        0: 'SMARTCACHE||SMARTCACHE',  # key=SMARTCACHE
        1: 'SNAPSHOT||SNAPSHOT',  # key=SNAPSHOT
        2: 'LUNCOPY||LUNCOPY',  # key=LUNCOPY
        3: 'HYPERREPLICATION||HYPERREPLICATION',  # key=HYPERREPLICATION
        4: 'CONSISTENT_GROUP||CONSISTENT_GROUP',  # key=CONSISTENT_GROUP
        5: 'HyperClone||HyperClone',  # key=HyperClone
        6: 'THIN_PROVISION||THIN_PROVISION',  # key=THIN_PROVISION
        7: 'LUN_MUTI_MAPPING||LUN_MUTI_MAPPING',  # key=LUN_MUTI_MAPPING
        8: 'IPV6||IPV6',  # key=IPV6
        9: 'LICENSE_COMPARE||LICENSE_COMPARE',  # key=LICENSE_COMPARE
        10: 'NTP||NTP',  # key=NTP
        11: 'TIME_ZONE||TIME_ZONE',  # key=TIME_ZONE
        12: 'SYNC_CMD||SYNC_CMD',  # key=SYNC_CMD
        13: 'PERFORMANCE_DATA_IN_FILE||PERFORMANCE_DATA_IN_FILE',  # key=PERFORMANCE_DATA_IN_FILE
        14: 'EXPORT_ORIG_DATA||EXPORT_ORIG_DATA',  # key=EXPORT_ORIG_DATA
        15: 'CREATE_DATA_DISK||CREATE_DATA_DISK',  # key=CREATE_DATA_DISK
        16: 'INIT_FILE_SYSTEM||INIT_FILE_SYSTEM',  # key=INIT_FILE_SYSTEM
        17: 'ALUA||ALUA',  # key=ALUA
        18: 'ACCESSIP||ACCESSIP',  # key=ACCESSIP
        19: 'ExpandDisk||ExpandDisk',  # key=ExpandDisk
        20: 'DISKSUBRACK_LIGHT||DISKSUBRACK_LIGHT',  # key=DISKSUBRACK_LIGHT
        21: 'DISKSUBRACK_LIGHT_CTRL_HARDDISK||DISKSUBRACK_LIGHT_CTRL_HARDDISK',
        # key=DISKSUBRACK_LIGHT_CTRL_HARDDISK
        22: 'INPUT_POWER||INPUT_POWER',  # key=INPUT_POWER
        23: 'PERF_STAT_DUMP||PERF_STAT_DUMP',  # key=PERF_STAT_DUMP
        24: 'CLIENTINFO||CLIENTINFO',  # key=CLIENTINFO
        25: 'EXPORT_PERFORMANCE_DATA||EXPORT_PERFORMANCE_DATA',  # key=EXPORT_PERFORMANCE_DATA
        26: 'QUERY_USER_QUATO||QUERY_USER_QUATO',  # key=QUERY_USER_QUATO
        27: 'QUERY_CIFS_ONLINE_USER||QUERY_CIFS_ONLINE_USER',  # key=QUERY_CIFS_ONLINE_USER
        28: 'USER_LEVEL_READONLY||USER_LEVEL_READONLY',  # key=USER_LEVEL_READONLY
        29: 'ALARM_CONFIG_CLASSIFICATION||ALARM_CONFIG_CLASSIFICATION',  # key=ALARM_CONFIG_CLASSIFICATION
        30: 'NOTIFICATION_SMS_CLASSIFICATION||NOTIFICATION_SMS_CLASSIFICATION',
        # key=NOTIFICATION_SMS_CLASSIFICATION
        31: 'AUTO_BACKUP||AUTO_BACKUP',  # key=AUTO_BACKUP
        32: 'PERFORMANCE_THRESHOLD||PERFORMANCE_THRESHOLD',  # key=PERFORMANCE_THRESHOLD
        33: 'MULTI_PATH_MONITORING||MULTI_PATH_MONITORING',  # key=MULTI_PATH_MONITORING
        34: 'SUPPORT_FCOE_CARD||SUPPORT_FCOE_CARD',  # key=SUPPORT_FCOE_CARD
        35: 'PERFORMANCE_SPLITED_INTERVAL||PERFORMANCE_SPLITED_INTERVAL',  # key=PERFORMANCE_SPLITED_INTERVAL
        36: 'INTEGERATED_NAS||INTEGERATED_NAS',  # key=INTEGERATED_NAS
        37: 'SUPPORT_DEFAULT_ROUTE||SUPPORT_DEFAULT_ROUTE',  # key=SUPPORT_DEFAULT_ROUTE
        38: 'HOT_PATCH||HOT_PATCH',  # key=HOT_PATCH
        39: 'FC_PORT_MODE||FC_PORT_MODE',  # key=FC_PORT_MODE
        40: 'FILE_ENGINE_NODE||FILE_ENGINE_NODE',  # key=FILE_ENGINE_NODE
        41: 'LOG_OF_DOWNLOAD_PERF_STAT_ARCHIVE||LOG_OF_DOWNLOAD_PERF_STAT_ARCHIVE',
        # key=LOG_OF_DOWNLOAD_PERF_STAT_ARCHIVE
        42: 'HOSTGROUP_PORTMODE||HOSTGROUP_PORTMODE',  # key=HOSTGROUP_PORTMODE
        43: 'SPLIT_MIRROR_CONSISTENTGROUP||SPLIT_MIRROR_CONSISTENTGROUP',  # key=SPLIT_MIRROR_CONSISTENTGROUP
        44: 'LDAP_CONFIG||LDAP_CONFIG',  # key=LDAP_CONFIG
        45: 'T_SERIES_UNITARY||T_SERIES_UNITARY',  # key=T_SERIES_UNITARY
        46: 'THIN_LUN_CONTROLLER_MODIFY||THIN_LUN_CONTROLLER_MODIFY',  # key=THIN_LUN_CONTROLLER_MODIFY
        47: 'HAS_SVP||HAS_SVP',  # key=HAS_SVP
        48: 'BAY_RETRIEVEABLE||BAY_RETRIEVEABLE',  # key=BAY_RETRIEVEABLE
        49: 'HAS_MONITOR_BOARD||HAS_MONITOR_BOARD',  # key=HAS_MONITOR_BOARD
        50: 'PORT_MAPPING_VIEW||PORT_MAPPING_VIEW',  # key=PORT_MAPPING_VIEW
        51: 'HOST_LINK||HOST_LINK'  # key=HOST_LINK
    }

    '''
    '''
    DISK_SSD_IF_TYPE_E = {
        0: 'Not Available||NA',  # key=NA
        1: 'FC SSD||FC_SSD',  # key=FC_SSD
        2: 'SAS SSD||SAS_SSD',  # key=SAS_SSD
        3: 'NL SAS SSD||NL SAS_SSD',  # key=NL SAS_SSD
        4: 'SATA SSD||SATA_SSD',  # key=SATA_SSD
        5: 'SATA2 SSD||SATA2_SSD',  # key=SATA2_SSD
        6: 'SATA3 SSD||SATA3_SSD'  # key=SATA3_SSD
    }

    '''
    '''
    DISK_FORM_E = {
        0: 'Unknown||Unknown',  # key=Unknown
        1: '5.25 inch||DISK_5_25_INCH',  # key=DISK_5_25_INCH
        2: '3.5 inch||DISK_3_5_INCH',  # key=DISK_3_5_INCH
        3: '2.5 inch||DISK_2_5_INCH',  # key=DISK_2_5_INCH
        4: '1.8 inch||DISK_1_8_INCH'  # key=DISK_1_8_INCH
    }

    '''
    '''
    SYS_STATUS_E = {
        0: 'Normal||正常',  # key=Normal
        1: 'Abnormal||异常',  # key=Abnormal
        2: 'POWERONING||上电中',  # key=POWERONING
        3: 'POWEROFF||下电中',  # key=POWEROFF
        4: 'SAFE_MODE||安全保护状态',  # key=SAFE_MODE
        5: 'UPGRADING||升级中',  # key=UPGRADING
        6: 'POWER_LOST||掉电',  # key=POWER_LOST
        7: 'OFFLINE||离线'  # key=OFFLINE
    }

    '''
    '''
    RESOURCE_ACCESS_E = {
        1: 'NOACCESS||禁止访问',  # key=NOACCESS
        2: 'READ_ONLY||只读',  # key=READ_ONLY
        3: 'READ_WRITE||读写'  # key=READ_WRITE
    }

    '''
    '''
    FS_SHARE_WINDOWS_MODE = {
        1: 'NORMAL||NORMAL',  # key=NORMAL
        2: 'HOMEDIRE||HOMEDIRE'  # key=HOMEDIRE
    }

    '''
    '''
    FS_SHARE_TYPE = {
        1: 'CIFS_NFS||CIFS_NFS',  # key=CIFS_NFS
        2: 'CIFS||CIFS',  # key=CIFS
        3: 'NFS||NFS'  # key=NFS
    }

    '''
    '''
    QUOTA_TYPE_E = {
        1: 'QUOTA_FOLDER||Normal目录配额',  # key=QUOTA_FOLDER
        2: 'QUOTA_USER||用户的配额',  # key=QUOTA_USER
        3: 'QUOTA_USERGROUP||用户组的配额',  # key=QUOTA_USERGROUP
        4: 'DEFAULT_USER_QUOTA||用户默认配额',  # key=DEFAULT_USER_QUOTA
        5: 'DEFAULT_GROUP_QUOTA||组默认配额',  # key=DEFAULT_GROUP_QUOTA
        6: 'QUOTA_USER_USERGROUP||用户和组配额'  # key=QUOTA_USER_USERGROUP
    }

    '''
    '''
    ACCESS_PERMISSION = {
        1: 'CIFS_READ||只读',  # key=CIFS_READ
        2: 'CIFS_READ_WRITE||读写',  # key=CIFS_READ_WRITE
        3: 'CIFS_ALLCONTROL||完全控制',  # key=CIFS_ALLCONTROL
        4: 'CIFS_NOACCESS||禁止访问',  # key=CIFS_NOACCESS
        5: 'NFS_R||只读',  # key=NFS_R
        6: 'NFS_RW_NOROOT||读写，不允许root权限',  # key=NFS_RW_NOROOT
        7: 'NFS_RW_ALLOWROOT||读写，允许root权限',  # key=NFS_RW_ALLOWROOT
        8: 'NFS_NOACCESS||禁止访问',  # key=NFS_NOACCESS
        9: 'NFS_EXECUTE||执行'  # key=NFS_EXECUTE
    }

    '''
    '''
    ACCESS_OBJ = {
        1: 'USER||USER',  # key=USER
        2: 'USERGROUP||USERGROUP',  # key=USERGROUP
        3: 'DOMAIN_USER||DOMAIN_USER',  # key=DOMAIN_USER
        4: 'DOMAIN_USERGROUP||DOMAIN_USERGROUP',  # key=DOMAIN_USERGROUP
        5: 'HOST||HOST',  # key=HOST
        6: 'SUBNET||SUBNET',  # key=SUBNET
        7: 'NETGROUP||NETGROUP',  # key=NETGROUP
        8: 'USERANDGROUP||USERANDGROUP',  # key=USERANDGROUP
        9: 'IPADDRESS||IPADDRESS'  # key=IPADDRESS
    }

    '''
    '''
    DOMAIN_TYPE_E = {
        1: 'NIS||NIS',  # key=NIS
        2: 'LDAP||LDAP',  # key=LDAP
        3: 'AD||AD'  # key=AD
    }

    '''
    '''
    FILE_ID_E = {
        0: 'event_en||事件定义文件(英文)',  # key=event_en
        1: 'event_zh||事件定义文件(中文)',  # key=event_zh
        10: 'event_restore_file||告警转储文件',  # key=event_restore_file
        20: 'error_en||错误码资源文件(英文)',  # key=error_en
        21: 'error_zh||错误码资源文件(中文)',  # key=error_zh
        30: 'task_en||运行任务资源文件(英文)',  # key=task_en
        31: 'task_zh||运行任务资源文件(中文)',  # key=task_zh
        40: 'license||license文件',  # key=license
        50: 'configData||配置数据文件',  # key=configData
        60: 'systemLog||系统日志文件',  # key=systemLog
        70: 'runningData||运行数据文件',  # key=runningData
        80: 'performanceData||性能数据文件'  # key=performanceData
    }

    '''
    '''
    DOMAIN_SECURITY_E = {
        1: 'Domain||域',  # key=DOMAIN
        2: 'Netgroup||网络组'  # key=NETGROUP
    }

    '''
    '''
    CASESENSITIVITY_E = {
        0: 'NOFS_CASE_SENSITIVE||0 是大小写敏感',  # key=NOFS_CASE_SENSITIVE
        1: 'NOFS_CASE_INSENSITIVE||1 是大小写不敏感',  # key=NOFS_CASE_INSENSITIVE
        2: 'NOFS_CASE_MIXED||2 是混合'  # key=NOFS_CASE_MIXED
    }

    '''
    '''
    COMPRESSION_E = {
        1: 'NIO_COMPRESS_ON          1||NIO_COMPRESS_ON          1',  # key=NIO_COMPRESS_ON          1
        2: 'NIO_COMPRESS_OFF         2||NIO_COMPRESS_OFF         2',  # key=NIO_COMPRESS_OFF         2
        5: 'NIO_COMPRESS_GZIP_1      5||NIO_COMPRESS_GZIP_1      5',  # key=NIO_COMPRESS_GZIP_1      5
        6: 'NIO_COMPRESS_GZIP_2      6||NIO_COMPRESS_GZIP_2      6',  # key=NIO_COMPRESS_GZIP_2      6
        7: 'NIO_COMPRESS_GZIP_3      7||NIO_COMPRESS_GZIP_3      7',  # key=NIO_COMPRESS_GZIP_3      7
        8: 'NIO_COMPRESS_GZIP_4      8||NIO_COMPRESS_GZIP_4      8',  # key=NIO_COMPRESS_GZIP_4      8
        9: 'NIO_COMPRESS_GZIP_5      9||NIO_COMPRESS_GZIP_5      9',  # key=NIO_COMPRESS_GZIP_5      9
        10: 'NIO_COMPRESS_GZIP_6      10||NIO_COMPRESS_GZIP_6      10',  # key=NIO_COMPRESS_GZIP_6      10
        11: 'NIO_COMPRESS_GZIP_7      11||NIO_COMPRESS_GZIP_7      11',  # key=NIO_COMPRESS_GZIP_7      11
        12: 'NIO_COMPRESS_GZIP_8      12||NIO_COMPRESS_GZIP_8      12',  # key=NIO_COMPRESS_GZIP_8      12
        13: 'NIO_COMPRESS_GZIP_9      13||NIO_COMPRESS_GZIP_9      13'  # key=NIO_COMPRESS_GZIP_9      13
    }

    '''
    '''
    CHECKSUM_E = {
        1: 'CHECKSUM_ON||CHECKSUM_ON',  # key=CHECKSUM_ON
        2: 'CHECKSUM_OFF||CHECKSUM_OFF',  # key=CHECKSUM_OFF
        6: 'CHECKSUM_FLETCHER_2||CHECKSUM_FLETCHER_2',  # key=CHECKSUM_FLETCHER_2
        7: 'CHECKSUM_FLETCHER_4||CHECKSUM_FLETCHER_4',  # key=CHECKSUM_FLETCHER_4
        8: 'CHECKSUM_SHA256||CHECKSUM_SHA256'  # key=CHECKSUM_SHA256
    }

    '''
    '''
    QUOTA_SET_STATUS_E = {
        1: 'QUOTA_NONSUPPORT||不支持',  # key=QUOTA_NONSUPPORT
        2: 'QUOTA_YESSET||已设置',  # key=QUOTA_YESSET
        3: 'QUOTA_NOTSET||未设置'  # key=QUOTA_NOTSET
    }

    '''
    '''
    WORM_TYPE_E = {
        0: 'ENTERPRISE||Enterprise企业模式',  # key=ENTERPRISE
        1: 'COMPLIANCE||Compliance遵从模式',  # key=COMPLIANCE
        2: 'DISABLED||关闭'  # key=DISABLED
    }

    '''
    '''
    UNIT_E = {
        1: 'Byte||Byte',  # key=UNIT_BYTE
        2: 'KB||KB',  # key=UNIT_KB
        3: 'MB||MB',  # key=UNIT_MB
        4: 'GB||GB',  # key=UNIT_GB
        5: 'TB||TB',  # key=UNIT_TB
        6: 'PB||PB',  # key=UNIT_PB
        11: 'KiB||KiB',  # key=UNIT_KIB
        12: 'MiB||MiB',  # key=UNIT_MIB
        13: 'GiB||GiB',  # key=UNIT_GIB
        14: 'TiB||TiB',  # key=UNIT_TIB
        15: 'PiB||PiB',  # key=UNIT_PIB
        21: 'Bytes/s||Bytes/s',  # key=UNIT_BYTE_PER_SEC
        22: 'KB/s||KB/s',  # key=UNIT_BYTE_KB_SEC
        23: 'MB/s||MB/s',  # key=UNIT_BYTE_MB_SEC
        24: 'GB/s||GB/s',  # key=UNIT_BYTE_GB_SEC
        25: 'TB/s||TB/s',  # key=UNIT_BYTE_TB_SEC
        26: 'PB/s||PB/s',  # key=UNIT_BYTE_PB_SEC
        40: 'ns||纳秒',  # key=UNIT_NS
        41: 'μs||微秒',  # key=UNIT_MICROSECOND
        42: 'ms||毫秒',  # key=UNIT_MS
        43: 'second(s)||秒',  # key=UNIT_SECOND
        44: 'minute(s)||分',  # key=UNIT_MINUTE
        45: 'hour(s)||小时',  # key=UNIT_HOUR
        46: 'day(s)||天',  # key=UNIT_DAY
        47: 'month(s)||月',  # key=UNIT_MONTH
        48: 'year(s)||年',  # key=UNIT_YEAR
        70: 'Times||次',  # key=UNIT_TIMES
        71: 'Times/s||次/秒',  # key=UNIT_TIMES_PER_SEC
        72: 'Entries||个',  # key=UNIT_ENTRIES
        73: 'Entries/s||个/秒',  # key=UNIT_ENTRIES_PER_SEC
        74: '%||%',  # key=UNIT_PERCENTAGE
        90: 'W||瓦',  # key=UNIT_WATT
        91: 'KW||千瓦',  # key=UNIT_KILOWATT
        100: 'IO/s||IO/s'  # key=UNIT_IOPS
    }

    '''
    '''
    IOCLASS_CTRL_TYPE = {
        1: '控制IO上限||控制IO上限',  # key=CTRL_UPPER
        2: '控制IO下限||控制IO下限'  # key=CTRL_LOWER
    }

    '''
    '''
    CACHE_POLICY_E = {
        1: 'READ_CACHE_POLICY_EVICT_LOW||READ_CACHE_POLICY_EVICT_LOW',  # key=READ_CACHE_POLICY_EVICT_LOW
        2: 'READ_CACHE_POLICY_EVICT_MIDDLE||READ_CACHE_POLICY_EVICT_MIDDLE',
        # key=READ_CACHE_POLICY_EVICT_MIDDLE
        3: 'READ_CACHE_POLICY_EVICT_HIGH||READ_CACHE_POLICY_EVICT_HIGH',  # key=READ_CACHE_POLICY_EVICT_HIGH
        4: 'WRITE_CACHE_POLICY_DESTAGE_LOW||WRITE_CACHE_POLICY_DESTAGE_LOW',
        # key=WRITE_CACHE_POLICY_DESTAGE_LOW
        5: 'WRITE_CACHE_POLICY_DESTAGE_MIDDLE||WRITE_CACHE_POLICY_DESTAGE_MIDDLE',
        # key=WRITE_CACHE_POLICY_DESTAGE_MIDDLE
        6: 'WRITE_CACHE_POLICY_DESTAGE_HIGH||WRITE_CACHE_POLICY_DESTAGE_HIGH'
        # key=WRITE_CACHE_POLICY_DESTAGE_HIGH
    }

    '''
    '''
    ULTRAPATH_SWITH_E = {
        1: 'NORMAL||正常',  # key=NORMAL
        2: 'WAIT||待切换',  # key=WAIT
        3: 'FINISH||切换完成'  # key=FINISH
    }

    '''
    '''
    DESTROY_TYPE_E = {
        1: 'DoD||DoD方式',  # key=DOD_ERASEMENT
        2: 'Write Replication||自定义反复写'  # key=REP_ERASEMENT
    }

    '''
    '''
    SECURITY_STYLE_E = {
        1: 'UNIX||UNIX',  # key=UNIX
        2: 'NTFS||NTFS'  # key=NTFS
    }

    '''
    '''
    COMM_CONFIGURE_E = {
        1: 'VMWARE||VMWARE'  # key=VMWARE
    }

    '''
    '''
    SECURITY_MODEL_E = {
        1: 'LOCAL_ATTESTATION||本地认证',  # key=LOCAL_ATTESTATION
        2: 'ALL_ATTESTATION||全局认证（域认证和本地认证）'  # key=ALL_ATTESTATION
    }

    '''
    '''
    PASSWORDHASH_E = {
        1: 'clear||clear',  # key=clear
        2: 'md5||md5',  # key=md5
        3: 'crypt||crypt'  # key=crypt
    }

    '''
    '''
    APP_TYPE_E = {
        0: 'other||其他',  # key=other
        1: 'oracle||oracel',  # key=oracel
        2: 'exchange||exchange',  # key=exchange
        3: 'sqlserver||sqlserver',  # key=sqlserver
        4: 'vmware||vmware',  # key=vmware
        5: 'hyper-V||hyper-V'  # key=hyper-V
    }

    '''
    '''
    NTLM_LEVEL_E = {
        0: 'LEVEL_0||LEVEL_0',  # key=LEVEL_0
        1: 'LEVEL_1||LEVEL_1',  # key=LEVEL_1
        2: 'LEVEL_2||LEVEL_2',  # key=LEVEL_2
        3: 'LEVEL_3||LEVEL_3',  # key=LEVEL_3
        4: 'LEVEL_4||LEVEL_4'  # key=LEVEL_4
    }

    '''
    '''
    RES_TYPE_E = {
        1: 'DEFAULT||初始默认',  # key=DEFAULT
        2: 'CREATE||管理员创建'  # key=CREATE
    }

    '''
    '''
    CONSULT_STATUS_E = {
        0: 'NOPASS||密钥未协商通过',  # key=NOPASS
        1: 'PASS||已通过',  # key=PASS
        2: 'NOT_SUPPORT||不支持加密传输'  # key=NOT_SUPPORT
    }

    '''
    '''
    DDP_COMP_LEVEL_E = {
        0: 'DDP_COMP_LEVEL_FAST||速度快',  # key=DDP_COMP_LEVEL_FAST
        1: 'DDP_COMP_LEVEL_MIDDLE||速度相当',  # key=DDP_COMP_LEVEL_MIDDLE
        2: 'DDP_COMP_LEVEL_DEEP||速度最慢'  # key=DDP_COMP_LEVEL_DEEP
    }

    '''
    '''
    DISK_SCAN_SCOPE_E = {
        1: 'ALL||全局',  # key=ALL
        2: 'ENCLOSURE||指定硬盘框',  # key=ENCLOSURE
        3: 'DISK||指定硬盘'  # key=DISK
    }

    '''
    '''
    BACKUP_OBJECT_E = {
    }

    '''
    '''
    QUERY_SEQUENCE_E = {
    }

    '''
    '''
    VM_BACKUP_STATUS_E = {
    }

    '''
    '''
    VM_EXIST_STATUS_E = {
    }

    '''
    '''
    BACKUP_TYPE_E = {
    }

    '''
    '''
    RESTORE_MODE_E = {
    }

    '''
    '''
    RESTORE_LOCATION_TYPE_E = {
    }

    '''
    '''
    SERVER_ROLE_E = {
        1: 'dispatcher||备份管理服务器',  # key=dispatcher
        2: 'processer||备份处理服务器',  # key=processer
        3: 'none||无'  # key=none
    }

    '''
    '''
    DEVICE_TYPE_E = {
        1: 'Dsware||FusionStorage:华为分布式存储',  # key=Dsware
        2: 'Virtual||虚拟化存储'  # key=Virtual
    }

    '''
    '''
    SCHEDUAL_TYPE_E = {
    }

    '''
    '''
    FREQUENCY_RANGE_E = {
        0: 'year||年',  # key=year
        1: 'month||月',  # key=month
        2: 'week||周',  # key=week
        3: 'day||日',  # key=day
        4: 'hour||小时',  # key=hour
        5: 'minute||分钟'  # key=minute
    }

    '''
    '''
    CLIENT_TYPE_E = {
    }

    '''
    '''
    VM_TYPE_E = {
    }

    '''
    '''
    DISK_STATUS_E = {
    }

    '''
    '''
    POLICY_TYPE_E = {
    }

    '''
    '''
    BACKUP_OBJECT_TYPE_E = {
    }

    '''
    '''
    STORAGE_TYPE_E = {
    }

    '''
    '''
    NAS_PROTOCOL_TYPE_E = {
    }

    '''
    '''
    CIFS_VERIFY_TYPE_E = {
    }

    '''
    '''
    BACKUP_DATA_TYPE_E = {
    }

    '''
    '''
    RESOTRE_OBJECT_TYPE_E = {
    }

    '''
    '''
    OPERATE_TYPE_E = {
    }

    '''
    '''
    EXPIRED_STATUS_E = {
    }

    '''
    '''
    IP_CFG_TYPE_E = {
        0: 'DHCP||DHCP',  # key=DHCP
        1: 'STATIC||STATIC'  # key=STATIC
    }

    '''
    '''
    SERVICE_NAME_E = {
        1: 'ftp||ftp',  # key=ftp
        2: 'snmp||snmp',  # key=snmp
        3: 'nfs||nfs',  # key=nfs
        4: 'dps||dps',  # key=dps
        5: 'dhcp||dhcp'  # key=dhcp
    }

    '''
    '''
    ENUM_ROUTE_TYPE_E = {
        0: 'Net||网段路由',  # key=ROUTE_TYPE_NET
        1: 'Host||主机路由',  # key=ROUTE_TYPE_HOST
        2: 'Default||默认路由'  # key=ROUTE_TYPE_DEFAULT
    }

    '''
    '''
    PROCESS_STATUS_E = {
    }

    '''
    '''
    IS_CAN_RESTART_TYPE_E = {
    }

    '''
    '''
    CONFIG_TYPE_E = {
    }

    '''
    '''
    BAY_MODEL_E = {
        0: 'BAY_2U||2.5寸柜',  # key=BAY_2U
        1: 'BAY_4U||3.5寸柜',  # key=BAY_4U
        2: 'INTERMAXING||混插柜'  # key=INTERMAXING
    }

    '''
    '''
    SMARTCACHE_STATE_E = {
        0: 'CLOSE||关闭',  # key=CLOSE
        1: 'OPEN||打开',  # key=OPEN
        2: 'EXTEND_PARENTPOOL||继承POOL的状态'  # key=EXTEND_PARENTPOOL
    }

    '''
    '''
    CLIENT_TRNAS_MODE_E = {
        0: 'LAN-based transmission||基于局域网的Socket传输方式',  # key=LAN
        1: 'LAN-based transmission wish SSL||基于局域网的Socket加密传输方式'  # key=LANSSL
    }

# DoradoV3V300R001C00-common
