# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
from cbb.business.checkitems import eth_toe_switch_check
from cbb.business.checkitems.eth_toe_switch_check import ToeCheckScene
from cbb.business.checkitems.eth_toe_switch_check import ToeCheckSceneMsgAdapter
from cbb.business.operate.fru.common import common
from cbb.frame.base import baseUtil
from cbb.frame.base import funcUtils
from cbb.frame.base.constants import CheckStatus
from cbb.frame.context import contextUtil


@funcUtils.fakeProgress(totalSecs=60, intervalSec=1)
def execute(context):
    """TOE功能开关检查

    :param context:
    :return:
    """
    try:
        # 预置结果字典
        result_dict = {"flag": False, "errMsg": "", "suggestion": ""}
        lang = contextUtil.getLang(context)
        cli = contextUtil.getCli(context)
        log = contextUtil.getLogger(context)
        logger = baseUtil.getLogger(log, __file__)

        # 检查场景设置为FRU场景
        scene_msg = ToeCheckSceneMsgAdapter(ToeCheckScene.REPLACE_SPARE_PART, lang, cli, log)
        # 执行检查，获取检查结果
        result_flag, _, err_msg = eth_toe_switch_check.execute(scene_msg)
        logger.info("result_flag: %s, err_msg: %s" % (result_flag, err_msg))

        # 检查通过
        if result_flag == CheckStatus.PASS:
            contextUtil.handleSuccess(context)
            logger.logPass()
            return
        # 检查不通过
        elif result_flag == CheckStatus.NOTPASS:
            result_dict["errMsg"] = baseUtil.getPyResource(lang, "EthTOESwitchCheck.TOESwitch.on")
            result_dict["suggestion"] = err_msg
        # 未完成检查
        else:
            result_dict["errMsg"], result_dict["suggestion"] = common.getMsg(lang, "common.exception")
        contextUtil.handleFailure(context, result_dict)
        logger.logNoPass(err_msg)
        return
    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
