﻿# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import getCurrentFruRunningInfo
from cbb.frame.rest import restData
from cbb.business.operate.fru.common import commonFunction

MEMBER_DISK_INDEX = 2


def execute(context, preCheck, **kwargs):
    """获取所有硬盘信息（ETH和FC）

    :param context(dict): python执行上下文
    :param preCheck(bool): True-更换前检查 False-更换后检查
    :param kwargs: 可变参数
    :return:
    """
    # 更换前备份信息
    if preCheck:
        # 硬盘信息(获取所有运行状态为Online的硬盘信息，返回运行状态、健康状态信息)
        currentNormalDisks = {}
        normalDisks = getCurrentFruRunningInfo.executeBy2Status(
            context, restData.Enum.ObjEnum.DISK,
            restData.Enum.RunningStatusEnum.ONLINE, None, **kwargs)
        currentNormalDisks.update(normalDisks)
        BaseFactory.log.info(context, "list of normal disks:%s" % str(normalDisks))
        BaseFactory.persist.setModule(context, "allNormalDisks", normalDisks)
        BaseFactory.result.setResultPass(context)
        return
    # 更换后比对信息
    else:
        BaseFactory.log.info(context, "====Check Normal Disks==== begin")
        normalDisksBefore = BaseFactory.persist.getModule(context, "allNormalDisks")
        BaseFactory.log.info(context, "NormalDisks before is :%s" % str(normalDisksBefore))
        # 硬盘信息
        normalDisksAfter = getCurrentFruRunningInfo.executeBy2Status(
            context, restData.Enum.ObjEnum.DISK,
            restData.Enum.RunningStatusEnum.ONLINE, None, **kwargs)
        BaseFactory.log.info(context, "NormalDisks after is :%s" % str(normalDisksAfter))
        abnormalDiskDescList, abnormalDiskList = check_disk_status(
            normalDisksBefore, normalDisksAfter)
        BaseFactory.log.info(context, "Check abnormals details :%s" % str(abnormalDiskDescList))
        if abnormalDiskDescList and has_invalid_disk_location(context):
            BaseFactory.result.setResultFailByKey(
                context, FuncFactory.LangKey.DISK_LOCATION_INVALID)
            BaseFactory.log.info(context, "disk location invalid.")
            return
        BaseFactory.log.info(context, "no disk location invalid.")
        if abnormalDiskDescList:
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.DISK_STAIUS_CHECK_CONSISTENT,  None, ", ".join(abnormalDiskList))
            BaseFactory.log.info(context, "====Check Disks==== fail end")
            return

        # 否则正常通过。
        BaseFactory.result.setResultPass(context)
        BaseFactory.log.info(context, "====Check Disks==== pass end")
        return


def check_disk_status(disk_before, disk_after):
    # 一致性校验：运行状态为Online的硬盘，健康状态不能发生变化(更换后为Normal的不需要校验)
    abnormalDiskList = []
    abnormalDiskDescList = []
    err_desc = "[DiskID:{}, Before(Status:{}), After(Status:{})]"
    for disk in disk_before:
        statusListBefore = disk_before.get(disk, [])
        statusListAfter = disk_after.get(disk, [])
        if statusListBefore == statusListAfter:
            continue
        if not statusListAfter or any([
            statusListBefore[MEMBER_DISK_INDEX]
            == str(restData.Enum.DiskLogicTypeEnum.MEMBER)
            and statusListAfter[MEMBER_DISK_INDEX]
            != str(restData.Enum.DiskLogicTypeEnum.MEMBER),
            "Normal" not in statusListAfter
        ]):
            abnormalDiskList.append(disk)
            # 健康状态和运行状态均需要比对

            errDiskDesc = err_desc.format(
                str(disk), ",".join(statusListBefore),
                ",".join(statusListAfter),
            )
            abnormalDiskDescList.append(errDiskDesc)
    return abnormalDiskDescList, abnormalDiskList


def has_invalid_disk_location(context):
    disk_info_list = commonFunction.get_disk_info_in_cli_mode(context)
    BaseFactory.log.info(
        context, "get disk info cli:{}".format(disk_info_list))
    return "--" in [disk.get("ID") for disk in disk_info_list]
