# coding:utf-8
import time

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.common.query.hardware.utils import getFruGivenTypeAndConditions
from cbb.frame.base import funcUtils
from cbb.frame.rest import restData
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil

PORT_TYPES = ([restData.Enum.ObjEnum.ETH_PORT, 'ETH'],
              [restData.Enum.ObjEnum.FC_PORT, 'FC'],
              [restData.Enum.ObjEnum.SAS_PORT, 'SAS'],
              )

LIMIT_TIME = 2 * 60
INTERNAL = 1


@funcUtils.fakeProgress(totalSecs=LIMIT_TIME, intervalSec=INTERNAL)
def execute(context, preCheck=True, portTypes=PORT_TYPES):
    """端口信息（前端端口、后端端口、管理端口、维护端口、ScaleOut端口）

    :param context:
    :param preCheck:
    :return:
    """
    # 获取所有linkUp的端口信息
    allPortTypeDict = get_all_ports(context, portTypes)

    if preCheck:
        # 保存信息
        BaseFactory.persist.setModule(context, "allPortTypeDict", allPortTypeDict)

        BaseFactory.log.info(context, "allPortTypeDict :%s" % str(allPortTypeDict))
        BaseFactory.result.setResultPass(context)
        return
    else:

        # 获取已保存信息
        linked_port_info_before = BaseFactory.persist.getModule(
            context, "allPortTypeDict")
        linked_port_info_before = linked_port_info_before if \
            linked_port_info_before else []
        BaseFactory.log.info(context,
                             "linkedPortInfoBefore is :%s" %
                             str(linked_port_info_before))

        start_time = time.time()
        linked_down_port_locs = []
        while True:
            if time.time() - start_time > LIMIT_TIME:
                BaseFactory.result.setResultFailByKey(
                    context,
                    FuncFactory.LangKey.PORTS_CHECK_INCONSISTENT_AFTER_REP,
                    sugParamTuple=", ".join(linked_down_port_locs))
                BaseFactory.log.info(context,
                                     "Check linked up ports fail end")
                return

            time.sleep(10)

            BaseFactory.log.info(context, "Post Check linked up ports begin")
            linked_port_info_after = get_all_ports(context, portTypes)
            BaseFactory.log.info(context,
                                 "linkedPortInfoAfter is :%s" %
                                 str(linked_port_info_after))

            linked_down_port_locs = []
            for port_type_name in linked_port_info_before:
                linked_up_ports_info_dict_before = linked_port_info_before.get(
                    port_type_name, {})
                linked_up_ports_info_dict_after = linked_port_info_after.get(
                    port_type_name, {})
                for port_loc in linked_up_ports_info_dict_before:
                    if port_loc not in linked_up_ports_info_dict_after:
                        linked_down_port_locs.append(port_loc)
            if not linked_down_port_locs:
                break

        BaseFactory.result.setResultPass(context)
        BaseFactory.log.info(context, "Check linked up ports pass end")
        return


def get_all_ports(context, port_types):
    """
    获取所有Linkup的端口信息
    """
    all_port_type_dict = dict()
    for port_type, type_name in port_types:
        linked_ports_info = getFruGivenTypeAndConditions(
            context, port_type, status=restData.Enum.RunningStatusEnum.LINK_UP)
        all_port_type_dict[type_name] = linked_ports_info
        if port_type == restData.Enum.ObjEnum.SAS_PORT:
            BaseFactory.log.info(
                context,
                "backupSASLinkPortInfo linkedSasPorts :%s" % linked_ports_info)
            BaseFactory.persist.setModule(context,
                                          FuncFactory.PERSIST_LINKED_SAS_PORT,
                                          linked_ports_info)
    return all_port_type_dict
