﻿# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import QuorumFunction
from cbb.frame.rest import restData
from cbb.frame.context import contextUtil
import time


'''
仲裁链路状态检查
'''
def execute(context):

    BaseFactory.log.info(context, "====Check quorum server link ==== begin")
    try:
        rest = contextUtil.getRest(context)
        # 获取所有异常的仲裁链路信息
        abnormalQuorumLinkIdList = QuorumFunction.QuorumCommon.getQuorumServNotLinkUpIDs(rest)
        if abnormalQuorumLinkIdList:
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.PUBSUG_REPL_QUORUM_LINK_UNNORMAL, None,
                                                  ", ".join(abnormalQuorumLinkIdList))
            BaseFactory.log.info(context, "====Check quorum server link ==== fail end")
            return

        BaseFactory.result.setResultPass(context)
        BaseFactory.log.info(context, "====Check quorum server link ==== pass end")
        return
    except Exception as ex:
        BaseFactory.exception.handler(context, ex)
    return
