#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@version: Toolkit V200R006C00
@time: 2020/07/27
@file: check_sed_msid_risk.py
@function:
@modify:
"""
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.checkitems import check_sed_msid_risk
from cbb.business.operate.checkitems.check_sed_msid_risk import errCode
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.context import contextUtil


def execute(context):
    try:
        BaseFactory.log.info(context, "check the sed msid risk")

        BaseFactory.log.info(context, "check the sed msid risk")
        selected = BaseFactory.json.toDict(context.get(
            "input_selectfru_diskSelectedRow"))
        BaseFactory.log.info(context, "the selected=%s"
                             % str(selected))
        exp_disk_types = [selected["diskType"]]

        cli = contextUtil.getCli(context)

        ret = check_sed_msid_risk.execute(context, exp_disk_types, cli)

        right_version = ""
        right_patch = ""
        if ret[0]:
            BaseFactory.log.info(context,
                                 "===the sed msid risk check pass===")
            BaseFactory.result.setResultPass(context)
            return
        elif ret[2] == errCode.V60RC1_TOO_OLD:
            BaseFactory.log.error(context, "version V6.0.RC1 is too old")
            right_version += "OceanStor Dorado V6 6.0.1"
            right_patch += "SPH1"
        elif ret[2] == errCode.V600_PATCH_NOT_MEET:
            BaseFactory.log.error(context, "version V6.0.0 PATCH is too old")
            right_version += "OceanStor Dorado V6 6.0.0"
            right_patch += "SPH7"
        else:
            BaseFactory.log.error(context, "version V6.0.1 PATCH is too old")
            right_version += "OceanStor Dorado V6 6.0.1"
            right_patch += "SPH1"

        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.FRU_SOFTWARE_PATCH_NOT_MATCH,
            (ret[3], ret[4]), (right_version, right_patch))
        return

    except Exception as exception:
        BaseFactory.log.error(
            context,
            "failed to check the sed msid risk, exception=" +
            str(exception))
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.FRU_SED_MSID_CHECK_FAILED)
        return
