﻿# -*- coding: UTF-8 -*-
import json

from cbb.business.operate.fru.common import common
from cbb.business.operate.fru.common import config
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

DISK_TYPE_ERROR_ALARM = 64438665509  # 0xF00D80125 	新硬盘型号不一致未加入硬盘域


def execute(context, select_id):
    """
    :param context: 上下文
    :param select_id: 保持数据的ID
    :return:
    """
    lang = contextUtil.getLang(context)
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        disks = json.loads(context.get(select_id))
        result, msg, sug = check_multi_stream_alram(context, disks)
        if not result:
            contextUtil.setResult(context, False, msg, sug)
            return

        return check_disk_specification(context, disks)
    except Exception as ex:
        logger.error("check specification error:%s" % str(ex))
        msg, sug = common.getMsg(lang, "execute.error")
        contextUtil.setResult(context, False, msg, sug)
        return


def check_multi_stream_alram(context, disks):
    """
    多流盘告警检查
    :param context:
    :param disks:
    :return:
    """

    # Dorado 指定版本需要检查
    productModel = contextUtil.getProductModel(context)
    productVersion = contextUtil.getDevObj(
        context).get("version")
    isDoradoDev = baseUtil.isDoradoDev(productModel)
    if not isDoradoDev or productVersion < \
            config.NEED_CHK_DISK_NOT_SUPPORT_BY_MULTI_STREAM_ALM_VER:
        return True, "", ""

    # 有成员盘的时候检查
    is_member_disk = False
    for disk in disks:
        pool_id = disk.get("poolId")
        if pool_id and str(pool_id).isdigit():
            is_member_disk = True
            break

    if not is_member_disk:
        return True, "", ""

    rest = contextUtil.getRest(context)
    lang = contextUtil.getLang(context)
    start_time = contextUtil.getItem(context, "START_SYS_TIME")
    systime_rec = restUtil.CommonRest.getSysUTCTimeRecord(rest)
    end_time = restUtil.Tlv2Rest. \
        getRecordValue(systime_rec,
                       restData.Sys.SystemUtcTime.CMO_SYS_UTC_TIME)
    condition = {DISK_TYPE_ERROR_ALARM: []}
    recs = restUtil.CommonRest.getSysEvent(rest, start_time, end_time,
                                           condition,
                                           type=restData.RestCfg.
                                           SpecialUri.
                                           QUERY_CURRENT_ALARM_INFO)
    if recs:
        msg, sug = common.getMsg(lang, "disk.type.error")
        return False, msg, sug

    return True, "", ""


def check_disk_specification(context, disks):
    rest = contextUtil.getRest(context)
    lang = contextUtil.getLang(context)
    type_inconsistence_list = []
    cap_inconsistence_list = []
    for disk in disks:
        disk_id = disk.get("id")
        disk_loc = disk.get("location")
        rec = restUtil.CommonRest.getDiskById(rest, disk_id)
        disk_type_enum = restUtil.CommonRest. \
            getRecordValue(rec, restData.RestCfg.Disk.DISKTYPE)
        new_disk_type = restUtil.Tlv2Rest. \
            getStr(context, restData.EnumStr.StrDiskTypeEnum, disk_type_enum)

        old_disk_type = disk.get("diskType")
        if old_disk_type != new_disk_type:
            type_inconsistence_list.append(disk_loc)

        old_cap = disk.get("totalCapacity")
        sectors = restUtil.CommonRest. \
            getRecordValue(rec, restData.RestCfg.Disk.SECTORS).longValue()
        sector_size = restUtil.CommonRest. \
            getRecordValue(rec, restData.RestCfg.Disk.SECTORSIZE).longValue()

        new_cap = sectors * sector_size
        if new_cap < old_cap:
            cap_inconsistence_list.append(disk_loc),

    result = True
    sug = ""
    msg, __ = common.getMsg(lang, "disk.specification.inconsistence")
    if type_inconsistence_list:
        result = False
        type_inconsistence_list.sort()
        __, sug1 = common.getMsg(lang, "disk.type.inconsistence",
                                 suggestionArgs=", ".join(
                                     type_inconsistence_list))
        sug += sug1

    if cap_inconsistence_list:
        result = False
        cap_inconsistence_list.sort()
        __, sug2 = common.getMsg(lang, "disk.cap.inconsistence",
                                 suggestionArgs=", ".join(
                                     cap_inconsistence_list))
        sug += sug2

    return result, msg, sug
