# -*- coding: UTF-8 -*-
import json

from cbb.business.operate.fru.common import common
from cbb.business.operate.fru.common import GuideLinker
from cbb.business.operate.fru.common.TlvEnumFactory import TlvEnum
from cbb.business.operate.fru.common.TlvStrFactory import TlvStr
from cbb.frame.context import contextUtil

MAX_SELECT_NUM = 5


def save_data(context, select_id):
    lang = contextUtil.getLang(context)
    disks = json.loads(context.get(select_id))
    if len(disks) > MAX_SELECT_NUM:
        msg, sug = common.getMsg(lang, "disk.max.num", str(MAX_SELECT_NUM))
        contextUtil.setResult(context, False, msg, sug)
        return

    pools = set()
    fault = TlvStr.getStr(context, TlvStr.HEALTH_STATUS_E,
                          TlvEnum.Enum.HEALTH_STATUS_E.get('FAULT'))
    for disk in disks:
        pool = disk.get("poolID")
        if pool:
            healtstatus = disk.get("healthStatus")
            if healtstatus == fault:
                pools.add(pool)
                continue

            if pool in pools:
                msg, sug = common.getMsg(lang, "disk.same.pool")
                contextUtil.setResult(context, False, msg, sug)
                return
            pools.add(pool)

    # use the first disk to show replacement guide
    fruType = GuideLinker.FruType.DISK
    location = disks[0].get("location")
    GuideLinker.initGuideInfo(context, fruType, location)
    contextUtil.setResult(context, True, "", "")
    return
