﻿# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil


def execute(context, fruType, fruID, location, lightStatusField):
    """备件点灯操作: 机框、控制器、级联板、接口模块

    :param context(dict): python上下文
    :param fruType(string): FRU类型
    :param fruID(string): FRU的ID
    :param location(string): FRU的location
    :param lightStatusField: 定位灯状态字段定义
    :return: True or Falsere
    """

    try:
        BaseFactory.log.info(context, "====Switch Light Status==== start")
        # 基本参数合法性检查
        checkParams = (fruType, fruID, lightStatusField)
        if not all(checkParams):
            BaseFactory.log.error(context, "Failed to light the part, Params Error: " + str(checkParams))
            raise Exception

        # 发送命令点灯/关灯
        param0 = (restData.PublicAttributes.TYPE, fruType)
        param1 = (restData.PublicAttributes.ID, fruID)
        param2 = (lightStatusField, restData.Enum.SwitchEnum.ON)
        paramlist = restUtil.Tlv2Rest.getParamList(param0, param1, param2)
        rest = contextUtil.getRest(context)
        if fruType == restData.Enum.ObjEnum.DISK:
            cmd = restData.TlvCmd.SET_DISK_LITHTSW
        else:
            cmd = restData.TlvCmd.MODIFY
        restUtil.Tlv2Rest.execCmd(rest, cmd, paramlist)
        BaseFactory.log.info(context, "====Switch Light Status==== pass end")
        BaseFactory.result.setResultPass(context)
        return
    except Exception as ex:
        BaseFactory.log.error(context, "failed to light the controller of " + fruID + ", exception=" + str(ex))
        BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.FRU_SWITCH_LIGNT_STATUS_FAILED, location)
        return
