﻿# -*- coding: UTF-8 -*-
from cbb.frame.util import public_ip_address_utils

RESOURCE_DICT = {
    "controller_replace_tdm_warning_info_zh": u"更换过程中，如果工具异常退出，或网络断开，请重新打开工具进行全流程更换。否则，更换"
                                              u"流程未完成有可能导致设备存在运行风险，如有疑问，请联系华为技术支持工程师。",
    "controller_replace_tdm_warning_info_en": u"If the tool exits abnormally or the network is disconnected during the"
                                              u" replacement, restart the tool and redo the overall replacement. "
                                              u"Otherwise, the device may run at a risk if the replacement is not "
                                              u"complete. For any questions, contact Huawei technical support "
                                              u"engineers.",
    "service_vm_not_open_zh": u"存在更换前手动停止的业务虚拟机未重新启动，如果忽略该项检查，请点击“确定”按钮，否则点击“取消”按钮。",
    "service_vm_not_open_en": u"Some service virtual machines that have been manually stopped before the replacement "
                              u"have not been restarted. To ignore this check, click OK. Otherwise, click Cancel.",
    "guide_video_title_zh": u"更换视频二维码及链接",
    "guide_video_title_en": u"Replacement Multimedia QR Code and Link",

    "guide_video_desc_zh": u"<html>请扫描下方二维码或点击<a href='%s'>此处链接"
                           u"</a>，查看当前设备型号及对应备件模块的更换视频，并按"
                           u"照视频指导内容进行更换。</html>",
    "guide_video_desc_en": u"Scan the QR code or click <a href='%s'>here</a>"
                           u" to view the parts replacement multimedia of "
                           u"the current device model and corresponding "
                           u"parts, and replace the parts as instructed.",

    "guide_video_link_v6_zh": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_v6_zh"),
    "guide_video_link_v6_en": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_v6_en"),

    "guide_video_link_protect_zh": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_protect_zh"),
    "guide_video_link_protect_en": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_protect_en"),

    "guide_video_link_computing_zh": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_computing_zh"),
    "guide_video_link_computing_en": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_computing_en"),

    "guide_video_link_micro_zh": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_micro_zh"),
    "guide_video_link_micro_en": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_micro_en"),

    "guide_video_link_new_oceanstor_zh": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_new_oceanstor_zh"),
    "guide_video_link_new_oceanstor_en": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_new_oceanstor_en"),

    "guide_video_link_v5_zh": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_v5_zh"),
    "guide_video_link_v5_en": public_ip_address_utils.get_guide_video_link(
        "guide_video_link_v5_en"),

    # 前端接口模块
    "replacingfrontIntf_should_close_VM_Makesure_zh": u"虚拟机（%s）已绑定待更换接口模块上的端口%s，请确认虚拟机（%s）已关闭或已停止该虚拟机上的所有业务。",
    "replacingfrontIntf_should_close_VM_Makesure_en": u"VM (%s) has been bonded with %s on the interface module that you want to replace. Ensure that VM (%s) has been closed or all services on it has been stopped. ",

    "replacingfrontIntf_no_VM_zh": u"该设备不支持虚拟机或待更换接口模块上的端口没有绑定正常运行的虚拟机，请直接点击“下一步”。",
    "replacingfrontIntf_no_VM_en": u"The device does not support VMs or the ports on the interface module that you want to replace are not bonded with VMs which are running properly. Click Next. ",

    "replacingfrontIntf_stop_service_zh": u"请手动停止待更换前端接口模块上连接的主机业务。",
    "replacingfrontIntf_stop_service_en": u"Manually stop the services of the hosts that are connected to the front-end interface module that you want to replace. ",

    "replacingfrontIntf_noneed_stop_service_zh": u"待更换的前端接口模块没有或不会影响业务，请直接点击“下一步”。",
    "replacingfrontIntf_noneed_stop_service_en": u"The front-end interface module that you want to replace has no impact on services or does not affect services. Click Next. ",

    # 后端接口模块
    "replacingendIntf_stop_service_zh": u"更换后端接口模块需要停止所有主机上的业务，请手动停止所有主机上的业务后再进行更换。",
    "replacingendIntf_stop_service_en": u"Before replacing back-end interface module, manually stop all the host services.",

    "replacingendIntf_noneed_stop_service_zh": u"待更换的后端接口模块没有或不会影响业务，请直接点击“下一步”。",
    "replacingendIntf_noneed_stop_service_en": u"The back-end interface module that you want to replace has no impact on services or does not affect services. Click Next. ",

    "hotpatch_version_later_zh": u"或以后版本",
    "hotpatch_version_later_en": u" or a later version",

    "hotPatchVersionCheck_ignore_warning_tips_zh": u"热补丁版本检查不通过。请按如下操作安装热补丁后再重新进行备件更换：\n%s\n如果忽略该检查项，可能会存在备件更换失败或备件更换后不可用的风险。经评估确认要忽略该检查项，请勾选“我已阅读上述信息，了解执行此操作带来的后果”，并点击“确认”进行后续操作。",
    "hotPatchVersionCheck_ignore_warning_tips_en": u"The hot patch version check is not passed. Install the hot patch based on the following operations and then replace the parts again: \n%s\n If you skip this check item, the part replacement may fail, or the parts cannot be used after the replacement. If you determine to skip this check item based on an evaluation, select “I have read and understood the consequence associated with performing this operation” and click OK to perform subsequent operations.",

    # 前端线缆
    "replacingfrontEndCable_should_close_VM_Makesure_zh": u"虚拟机（%s）已绑定待更换前端线缆上的端口%s，请确认虚拟机%s已关闭或已停止该虚拟机上的所有业务。",
    "replacingfrontEndCable_should_close_VM_Makesure_en": u"VM (%s) has been bonded with %s on the front-end cable that you want to replace. Ensure that VM (%s) has been closed or all services on it has been stopped.",

    "replacingfrontEndCable_no_VM_zh": u"该设备不支持虚拟机或待更换前端线缆上的端口没有绑定正常运行的虚拟机，请直接点击“下一步”。",
    "replacingfrontEndCable_no_VM_en": u"The device does not support VMs or the ports on the front-end cable that you want to replace are not bonded with VMs which are running properly. Click Next. ",

    "replacing_front_cable_stop_service_zh": u"请手动停止待更换前端线缆上连接的主机业务。",
    "replacing_front_cable_stop_service_en": u"Manually stop the services of the hosts that are connected to the front-end cable that you want to replace. ",

    "replacing_front_cable_noneed_stop_service_zh": u"待更换的前端线缆没有或不会影响业务，请直接点击“下一步”。",
    "replacing_front_cable_noneed_stop_service_en": u"The front-end cable that you want to replace has no impact on services or does not affect services. Click Next. ",

    # 后端接口模块
    "replacingExp_stop_service_zh": u"更换级联模块需要停止所有主机上的业务，请手动停止所有主机上的业务后再进行更换。",
    "replacingExp_stop_service_en": u"Before replacing expansion module, manually stop all the host services.",

    "replacingExp_noneed_stop_service_zh": u"待更换的级联模块没有或不会影响业务，请直接点击“下一步”。",
    "replacingExp_noneed_stop_service_en": u"The expansion module that you want to replace has no impact on services or does not affect services. Click Next. ",

    # 硬盘
    "replacingDisk_precopy_hotspace_not_enough_zh": u"步骤1：请检查当前硬盘域对应层级有无故障硬盘。如果存在故障硬盘，请先更换故障硬盘；更换完成后执行步骤4，否则执行步骤2；\n步骤2：请在所更换硬盘的引擎上，查找对应层级的所有存储池的RAID级别中的最大成员盘个数，如果最大成员盘个数等于当前硬盘域对应层级的总盘数，请执行步骤4；否则执行步骤3；\n步骤3：请在所更换硬盘的引擎上，查找当前硬盘域对应层级的总盘数。如果总盘数等于4，请执行步骤4；否则执行步骤5；\n步骤4：请继续“下一步”操作；\n步骤5：请联系技术支持工程师处理。",
    "replacingDisk_precopy_hotspace_not_enough_en": u"Step 1: Check whether any faulty disks exist on the corresponding tier of the current disk domain.  If yes, replace the faulty disks and go to step 4. If no, go to step 2. \nStep 2: On the engine where disks are replaced, check whether the maximum number of member disks in RAID groups of all storage pools is equal to the total disk quantity on the corresponding tier of the current disk domain. If yes, go to step 4. If no, go to step 3. \nStep 3: On the engine where disks are replaced, check whether the total disk quantity on the corresponding tier of the current disk domain is 4.  If yes, go to step 4. If no, go to step 5. \nStep 4: Click Next. \nStep 5: Contact technical support engineers. ",

    # 光模块
    "replacingfibre_stop_service_zh": u"请手动停止待更换光模块上连接的主机业务。",
    "replacingfibre_stop_service_en": u"Manually stop the services of the hosts that are connected to the optical module that you want to replace. ",

    "replacingFibre_noneed_stop_service_zh": u"待更换的光模块没有或不会影响业务，请直接点击“下一步”。",
    "replacingFibre_noneed_stop_service_en": u"The optical module that you want to replace has no impact on services or does not affect services. Click Next. ",

    # 控制器
    "replacingController_mgmPort_zh": u"所更换的控制器上更换前已连接的管理端口：%s，更换后未连接。",
    "replacingController_mgmPort_en": u"The management ports %s that were connected before the controller is replaced is not connected after the replacement.",

    # 控制框
    "replacingControllerEnclosure_mgmPort_zh": u"所更换的控制框上更换前已连接的管理端口：%s，更换后未连接。",
    "replacingControllerEnclosure_mgmPort_en": u"The management ports %s that were connected before the controller enclosure is replaced is not connected after the replacement.",
    # 切换业务
    "replacingfibre_frontendintf_suggestion_stop_service_zh": u"主动通知阵列切换业务失败，存在可能造成业务中断的风险。若要重新进行更换流程，请先点击取消按钮并确认相关接口卡、端口在位，控制器运行正常；或者请咨询技术工程师再重新进行更换流程。如果忽略该风险，则请勾选已知道该风险，并点击确认进行后续操作。",
    "replacingfibre_frontendintf_suggestion_stop_service_en": u" Actively notifying the storage array of service switchover failure may cause services to be interrupted. If you want to perform the replacement again, click Cancel and ensure that the corresponding interface module and port are in place and controllers are running properly. You can also consult technical engineers and perform the placement again. If you want to skip this risk, select I have read the previous information and understood subsequences of the operation and click OK to proceed with further operations.",
    # 告警
    "sync_alarm_zh": u"系统中存在以下告警: %s \n如忽略该告警带来的风险，请点击“确定”按钮。如需处理该告警，请点击“取消”按钮。",
    "sync_alarm_en": u"Existed alarm : %s \n If ignore the risk which following the alarm,please click OK.If handle the alarm,please chick Cancel.",

    "replacingManageFanCtrl_precheck_warning_zh": u"由于引擎的控制器和辅助散热模块外观相似，为避免将控制器当成辅助散热模块引起误操作而导致业务中断或数据丢失，请单击“确定”后严格按照下一步中的“更换指导”进行操作。",
    "replacingManageFanCtrl_precheck_warning_en": u"Controllers and assistant cooling units have the samilar appearance. To prevent service interruption and data loss due to mistakenly removing a controller for an assistant cooling unit. Click OK and perform operations by strictly following instructions in the Replacement Guide.",

    "master_controller_system_disk_fault_zh": u"无法导出系统配置数据进行备份。如果更换过程中发生配置数据丢失问题，则会存在因为没有备份数据导致配置数据不能恢复的风险，如果接受该风险，请点击“确认”跳过该步骤，否则请点击“取消”停止更换。",
    "master_controller_system_disk_fault_en": u"System configuration data cannot be exported for backup. If configuration data is lost during the replacement, it cannot be retrieved due to no backup data. If you accept the risk, click OK to skip this step. Otherwise, click Cancel to stop the replacement.",

    "backup.db.message_zh": u"本次流程进行了配置数据备份，点击“确认”删除备份数据。如需"
                            u"将配置数据带离客户现场，请务必经得客户授权后，方可带离现"
                            u"场！",
    "backup.db.message_en": u"During the peocess, the configuration data is "
                            u"backed up. To delete the backup data, click OK."
                            u" If you need to take the configuration data "
                            u"away from the customer's site, obtain the "
                            u"approval from the device administrator before"
                            u" you leave the site!",
    "backup.db.log.message_zh": u"本次流程进行了系统日志收集及配置数据备份，点击“确认”"
                                u"删除备份数据。如需将配置数据带离客户现场，请务必经得"
                                u"客户授权后，方可带离现场！",
    "backup.db.log.message_en": u"During the peocess, the system running log"
                                u" and configuration data is backed up. To "
                                u"delete the backup data, click OK. If you "
                                u"need to take the configuration data away "
                                u"from the customer's site, obtain the "
                                u"approval from the device administrator "
                                u"before you leave the site!",

    "backup.log.message_zh": u"如需查看更换前的存储日志，请查看路径：%s。",
    "backup.log.message_en": u"To view the system running log before "
                             u"replacement, please see the path:%s.",

    "contact.engineers_zh": u"请联系技术工程师处理。",
    "contact.engineers_en": u"Contact technical support engineers for help.",

    "patch.ver.check.fail_zh": u"补丁版本不满足要求。",
    "patch.ver.check.fail_en": "The patch version does not meet the "
                               "requirement.",

    "replacement.exist.risk_zh": u"当前版本存在更换风险，请联系技术支持工程师评估后"
                                 u"处理。",
    "replacement.exist.risk_en": "The current version has replacement risks."
                                 " Contact technical support engineers.",

    "patch.ver.not.meet_zh": u"当前版本存在更换风险，请安装%s或之后版本的补丁后再进"
                             u"行更换。",
    "patch.ver.not.meet_en": "The current version has replacement risks. "
                             "Install patch %s or a later version and "
                             "perform the replacement.",

    "patch.ver.warning.tips_zh": u"热补丁版本检查不通过。\n如果忽略该检查项，可能会"
                                 u"存在备件更换失败或备件更换后不可用的风险。经评估"
                                 u"确认要忽略该检查项，请勾选“我已阅读上述信息，了解"
                                 u"执行此操作带来的后果”，并点击“确认”进行后续操作。",

    "patch.ver.warning.tips_en": "The hot patch version check is not passed."
                                 "\n If you skip this check item, the part "
                                 "replacement may fail, or the parts cannot "
                                 "be used after the replacement. If you "
                                 "determine to skip this check item based on"
                                 " an evaluation, select \"I have read and "
                                 "understood the consequence associated with"
                                 " performing this operation\" and click OK "
                                 "to perform subsequent operations.",
}

ALARM_DICT = {
    # 远程复制告警
    "0x000F01C0001_zh": u"远程复制异常断开",
    "0x000F01C0001_en": u"Remote replication is interrupted.",

    "0x000F01C0002_zh": u"远程复制不可用",
    "0x000F01C0002_en": u"Remote replication is unavailable.",

    "0x000F01C0003_zh": u"远程复制主LUN数据回滚失败",
    "0x000F01C0003_en": u"Data on the primary LUN in the remote replication fails to be rolled back.",

    "0x000F01C0004_zh": u"远程复制从LUN数据回滚失败",
    "0x000F01C0004_en": u"Failed to roll back the secondary LUN in remote replication.",

    "0x200F0027002C_zh": u"远程复制同步失败",
    "0x200F0027002C_en": u"Remote replication failed to synchronize data.",

    "0x000F00270038_zh": u"远程复制异常断开",
    "0x000F00270038_en": u"Remote replication is interrupted.",

    "0x000F00270039_zh": u"远程复制不可用",
    "0x000F00270039_en": u"Remote replication is unavailable.",

    "0x000F0027003A_zh": u"远程复制自动启同步失败",
    "0x000F0027003A_en": u"Remote replication failed to synchronize data automatically.",

    "0x100F0027008B_zh": u"远程复制从LUN数据回滚失败",
    "0x100F0027008B_en": u"Failed to roll back the secondary LUN in remote replication.",

    # 远端设备告警
    "0x000F0E10001_zh": u"复制链路断开",
    "0x000F0E10001_en": u"Replication link is down.",

    "0x000F00E00014_zh": u"没有备用链路",
    "0x000F00E00014_en": u"No backup links available.",

    "0x000F00E00015_zh": u"阵列间链路连接数达到规格",
    "0x000F00E00015_en": u"Number of links between storage arrays reaches the system limit.",

    "0x000F00E00016_zh": u"阵列间链路加密协商失败",
    "0x000F00E00016_en": u"The link encryption between storage array links failed.",
}

# -----------New Frame----------------------
MESSAGES_DICT = {
    "check.host.system.consistent": {
        "errMsg_zh": u"主机（IDs:%s）操作系统与主机多路径推送的操作系统一致但存在误"
                     u"告警。",
        "errMsg_en": "The operating system type of host (IDs: %s) is "
                     "consistent with that pushed by UltraPath while a false"
                     " alarm indicating inconsistent operating system type "
                     "is generated.",
    },
    "check.host.system.inconsistent": {
        "errMsg_zh": u"主机（IDs:%s）操作系统与主机多路径推送的操作系统不一致。",
        "errMsg_en": "The operating system type of host (IDs: %s) is "
                     "inconsistent with that pushed by UltraPath.",
    },
    "check.host.system.sug": {
        "suggestion_zh": u"请登录CLI界面，执行如下命令：change host host_id="
                         u"hostId operating_system=osType（其中hostId为需要修改"
                         u"的主机id，osType为多路径推送的操作系统）修改指定主机操作系"
                         u"统为多路径推送的操作系统。",
        "suggestion_en": "Log in to the CLI and run the change host host_id="
                         "hostId operating_system=osType command (hostId "
                         "indicates the ID of the host to be modified and "
                         "osType indicates the operating system type pushed"
                         " by UltraPath) to change the operating system type"
                         " of the host to that pushed by UltraPath.",
    },
    "check.coffer.disk.controller": {
        "errMsg_zh": u"引擎上状态正常的保险箱盘数量不足，不能更换。",
        "errMsg_en": "The replacement fails because the number of normal "
                     "coffer disks on the engine where the part is to be "
                     "replaced is insufficient.",
        "suggestion_zh": u"请先插入至少一块保险箱盘或者更换故障的保险箱盘，保证该备件"
                         u"所在逻辑引擎至少有一块保险箱盘正常，再进行更换。",
        "suggestion_en": "Before replacing a part on an engine, insert at "
                         "least one coffer disk or replace the faulty coffer "
                         "disk on the engine, ensuring that at least one "
                         "coffer disk is working normally on the logic "
                         "engine.",
    },
    "check.coffer.disk.enclosure.arm": {
        "errMsg_zh": u"系统中状态正常的保险箱盘数量不足，不能更换。",
        "errMsg_en": "The replacement fails because the number of normal "
                     "coffer disks in the system is insufficient.",
        "suggestion_zh": u"请在每个引擎插入至少一块保险箱盘或者更换故障的保险箱盘，"
                         u"保证每个逻辑引擎都至少有一块保险箱盘正常，再进行控制框更换。",
        "suggestion_en": "Before replacing a controller enclosure, insert at"
                         " least one coffer disk or replace the faulty coffer"
                         " disk on each logic engine, ensuring that at least "
                         "one coffer disk is working normally on each logic "
                         "engine.",
    },
    "check.coffer.disk.enclosure": {
        "errMsg_zh": u"系统中状态正常的保险箱盘数量不足，不能更换。",
        "errMsg_en": "The replacement fails because the number of normal "
                     "coffer disks in the system is insufficient.",
        "suggestion_zh": u"请在前3个槽位插入至少两块保险箱盘或者更换故障的保险箱盘，"
                         u"保证每个逻辑引擎前3个槽位都有两块保险箱盘正常，再进行控制框"
                         u"更换。",
        "suggestion_en": "Before replacing a controller enclosure, insert at"
                         " least two coffer disks to the first three disk "
                         "slots or replace the faulty coffer disk on each "
                         "logic engine, ensuring that at least two coffer "
                         "disks in the first three disk slots on each logic "
                         "engine are working normally.",
    },
    "check.rocache.fail": {
        "errMsg_zh": u"当前缓存数据量较多，不允许更换。",
        "errMsg_en": "The replacement is not allowed due to large amount of "
                     "cached data.",
        "suggestion_zh": u"请安装%s及以后版本的通用热补丁。",
        "suggestion_en": "Install general hot patch %s or later.",
    },
    "check.rocache.fail.no.patch": {
        "errMsg_zh": u"当前缓存数据量较多，不允许更换。",
        "errMsg_en": "The replacement is not allowed due to large amount of "
                     "cached data.",
        "suggestion_zh": u"请联系技术工程师处理。",
        "suggestion_en": "Contact technical support engineers for help.",
    },
    "common.exception": {
        "errMsg_zh": u"获取信息失败。",
        "errMsg_en": "Failed to process the message.",
        "suggestion_zh": u"请检查系统状态或稍后重试。如果有任何疑问，请联系技术支持工程师协助处理。",
        "suggestion_en": "Please check the system status or try again later. If you have any problems, please contact technical support engineers for help.",
    },

    "manageBoard.port.status.error": {
        "errMsg_zh": u"更换前后端口健康状态或运行状态不一致。",
        "errMsg_en": "The health status and running status of the ports are inconsistent before and after replacement.",
        "suggestion_zh": u"请确认以下端口状态或连线是否正确：<br>%s。",
        "suggestion_en": "Ensure that the status and connections of the following ports are correct: <br>%s",
    },

    "expboard.existed.none.redt.sas.path": {
        "errMsg_zh": u"无冗余后端路径，不能更换。",
        "errMsg_en": "No redundant Back-end path. The replacement cannot be performed.",
        "suggestion_zh": u"请确认系统中存在冗余后端路径。",
        "suggestion_en": "Ensure that there is redundant Back-end path in the system.",
    },

    "redundant.controller.abnormal":
        {
            "errMsg_zh": u"冗余控制器不存在或状态异常。",
            "errMsg_en": "The redundant controller does not exist or is abnormal. The replacement cannot be performed.",
            "suggestion_zh": u"请确保冗余控制器在位且工作正常。",
            "suggestion_en": "Ensure that the redundant controller is in position and works correctly.",
        },
    "ctrls.ibc.pwd.changed":
        {
            "errMsg_zh": u"当前集群控制器IBC密码不是默认值。",
            "errMsg_en": "The cluster controller IBC password is not the default one.",
            "suggestion_zh": u"请在每个控制器上，恢复用户ibc_os_hs的密码为默认密码后重试。",
            "suggestion_en": "Restore the password of user ibc_os_hs to the default one and retry.",
        },

    "ctrls.ibc.key.pair.changed":
        {
            "errMsg_zh": u"控制器上的IBC公私钥对不是默认值。",
            "errMsg_en": "The IBC public/private key pair of controller is not the default one.",
            "suggestion_zh": u"请在每个控制器上，恢复用户ibc_os_hs的公私钥对为默认公私钥对后重试。",
            "suggestion_en": "Restore the public/private key pair of user ibc_os_hs to the default one on each controller and retry.",
        },

    "system.backIo.check.failure":
        {
            "errMsg_zh": u"业务压力超过标准，不能更换。",
            "errMsg_en": "The service pressure exceeds the limit. The replacement cannot be performed.",
            "suggestion_zh": u"请在单个控制器的CPU使用率不超过40%的时间段内，进行操作。",
            "suggestion_en": "Perform operations when the CPU usage of a single controller does not exceed 40%. ",
        },

    "controller.health.status.abnormal":
        {
            "errMsg_zh": u"启动控制器失败或控制器状态异常。",
            "errMsg_en": "Failed to start the controller or the controller status is abnormal.",
            "suggestion_zh": u"请重新拔插控制器后重试，如有疑问联系技术支持工程师协助处理。",
            "suggestion_en": "Please retry after you remove and insert the controller. If you have any question, contact technical support.",
        },

    "controller.health.status.error.code":
        {
            "errMsg_zh": u"控制器上电流程出现错误，错误码：%s，原始信息：\n%s。",
            "errMsg_en": "An error occurred in the controller power-on process. Error code: %s, "
                         "original information: \n%s.",
            "suggestion_zh": u"请等待5分钟后重新检测，仍有问题请联系技术工程师协助处理。",
            "suggestion_en": "Please wait for 5 minutes and check again."
                             " If the problem persists, contact technical support.",
        },

    "controller.running.status.abnormal":
        {
            "errMsg_zh": u"系统运行状态异常。",
            "errMsg_en": "The system operating status is abnormal.",
            "suggestion_zh": u"请联系技术支持工程师协助处理。",
            "suggestion_en": "Contact technical support engineers for help.",
        },

    "controller.mgmt.not.redundant":
        {
            "errMsg_zh": u"冗余管理路径不存在，不能更换。",
            "errMsg_en": "The redundant management path is not existed. The replacement cannot be performed.",
            "suggestion_zh": u"请确保管理网线连接正确。",
            "suggestion_en": "Ensure that the management cable is correctly connected.",
        },

    "controller.sas.diskenclosure.link.error":
        {
            "errMsg_zh": u"检测到冗余控制器连接的硬盘框[%s]连线错误。",
            "errMsg_en": "The cables of disk enclosures[%s] which incorrectly connected on the redundant controller.",
            "suggestion_zh": u"请检查冗余控制器连接的硬盘框的连线是否正确，确保和待更换控制器连接的硬盘框一致，然后重新检查。",
            "suggestion_en": "Check whether the cables between the redundant controller and disk enclosures are correctly connected. Ensure that the cable connections are the same as those between the disk enclosures and the controller that you want to replace. Then retry.",
        },

    "controller.postcheck.sas.port.unlinked":
        {
            "errMsg_zh": u"检测到控制器上后端端口[%s]未连接。",
            "errMsg_en": "The Back-end ports[%s] on the controller are not connected.",
            "suggestion_zh": u"请确保以上端口连接正确，然后重试。",
            "suggestion_en": "Ensure that the preceding ports are correctly connected. Then retry.",
        },

    "controller.replication.exist.linkdown.ports":
        {
            "errMsg_zh": u"远程复制业务相关端口[%s]未连接。",
            "errMsg_en": "The ports[%s] on the back up remote replication are correctly connected. Then retry.",
            "suggestion_zh": u"请确保以上端口连接正确，然后重试。",
            "suggestion_en": "Ensure that the preceding ports are correctly connected. Then retry.",
        },

    "controller.replication.unsynchronized":
        {
            "errMsg_zh": u"系统中存在无法同步的远程复制业务,远程复制Id有:[%s]",
            "errMsg_en": "Some remote replication tasks in the system cannot be synchronized:[%s].",
            "suggestion_zh": u"请稍后重试或联系技术支持工程师协助处理。",
            "suggestion_en": "Retry later or contact technical support engineers for help.",
        },

    "controller.cbu.not.redundant":
        {
            "errMsg_zh": u"检查到控制器上的备电电池不存在或者状态异常。",
            "errMsg_en": "Backup batteries do not exist on the controller or the status of the backup batteries is abnormal.",
            "suggestion_zh": u"请重新更换电池后重试，如有疑问联系技术支持工程师协助处理。",
            "suggestion_en": "Please retry after you replace the backup batteries. If you have any question, contact technical support.",
        },

    "controller.offline.controller.failed":
        {
            "errMsg_zh": u"离线控制器失败。",
            "errMsg_en": "Failed to take the controller offline.",
            "suggestion_zh": u"请联系技术支持工程师协助处理。",
            "suggestion_en": "Contact technical support engineers for help.",
        },
    "xpu.offline.controller.failed":
        {
            "errMsg_zh": u"离线存储节点失败。",
            "errMsg_en": "Failed to take the storage node offline.",
            "suggestion_zh": u"请联系技术支持工程师协助处理。",
            "suggestion_en": "Contact technical support engineers for help.",
        },
    "xpu.enable.ssdp.service.failed":
        {
            "errMsg_zh": u"使能SSDP服务失败。",
            "errMsg_en": "Failed to enable the SSDP Service.",
            "suggestion_zh": u"请联系技术支持工程师协助处理。",
            "suggestion_en": "Contact technical support engineers for help.",
        },
    "cmp.storage.bmc.status.exception":
        {
            "errMsg_zh": u"BMC健康状态不为OK。",
            "errMsg_en": "The BMC health status is not OK.",
            "suggestion_zh": u"请检查BMC状态或稍后重试。如果有任何疑问，"
                             u"请联系技术支持工程师协助处理。",
            "suggestion_en": "Please check the BMC status or try again "
                             "later. If you have any problems, please "
                             "contact technical support engineers for help.",
        },
    "sftp.download.fail":
        {
            "errMsg_zh": u"sftp传输失败。",
            "errMsg_en": "Failed to download file by sftp.",
            "suggestion_zh": u"请在网络和设备状态正常时重试。",
            "suggestion_en": "Retry when the network and device is normal.",
        },

    "controller.exist.alarm":
        {
            "errMsg_zh": u"系统中存在影响备件更换的告警，告警ID为：[%s]。",
            "errMsg_en": "The system has an alarm that affects parts replacement. The alarm ID is:[%s].",
            "suggestion_zh": u"请登录DeviceManager查看相关告警，根据告警的修复建议进行修复，修复完成后重试。",
            "suggestion_en": "Log in to DeviceManager to check the alarm. Rectify faults according to the recommended actions. Then retry.",
        },
    "redundant.cbu.powerNotEnough":
        {
            "errMsg_zh": u"冗余控制器的BBU模块正在充放电，不能更换。",
            "errMsg_en": "The BBU of the redundant controller is charging or discarging. Do not replace the BBU.",
            "suggestion_zh": u"请以admin用户登录执行命令，show bbu general 查看BBU状态，待BBU状态恢复正常后重试。",
            "suggestion_en": "Log in to the system as user admin and run the show bbu general command to view the BBU status. After the BBU status becomes normal, try again.",
        },

    "mgmtBoard.not.single.fault":
        {
            "errMsg_zh": u"冗余管理模块不存在或状态异常，不能更换。",
            "errMsg_en": "The redundant management module does not exist or is abnormal. You cannot replace it.",
            "suggestion_zh": u"请确保冗余管理模块（%s）在位且工作正常。",
            "suggestion_en": "Ensure that the redundant management module (%s) on controller enclosure can be detected and work properly.",
        },
    "mgmtBoard.not.double.fault":
        {
            "errMsg_zh": u"冗余管理模块不存在或状态异常，不能更换。",
            "errMsg_en": "The redundant management module does not exist or is abnormal. You cannot replace it.",
            "suggestion_zh": u"控制框（%s）上不存在正常的管理模块，请联系技术支持工程师协助处理。",
            "suggestion_en": "No management module is available on controller enclosure (%s). Contact technical support engineers.",
        },
    "mgmtCable.not.red":
        {
            "errMsg_zh": u"冗余管理线缆不存在或连线异常，不能更换。",
            "errMsg_en": "The network cable between redundant management planes does not exist or is improperly connected. You cannot replace it.",
            "suggestion_zh": u"请确保以下端口间已经正确连线：<br>%s",
            "suggestion_en": "Ensure that the following ports are properly connected:<br>%s",
        },
    "controller.nas.check.error.mapndmp":
        {
            "errMsg_zh": u"当前控制器（%s）存在%s活动的连接，拔插该控制器时这些连接将会断开，业务会受到影响。",
            "errMsg_en": "Controller (%s) has active %s connections. When the controller is removed and inserted, these connections will be disconnected and services will be affected.",
        },
    "controller.nas.check.error.nomapndmp.1":
        {
            "errMsg_zh": u"设备存在NDMP活动的连接，当前控制器（%s）存在%s活动的连接，拔插该控制器时这些连接将会断开，业务会受到影响。",
            "errMsg_en": "The system has active NDMP connections. Controller (%s) has active %s connections. When the controller is removed and inserted, these connections will be disconnected and services will be affected.",
        },
    "controller.nas.check.error.nomapndmp.2":
        {
            "errMsg_zh": u"设备存在NDMP活动的连接，拔插该控制器时这些连接将会断开，业务会受到影响。",
            "errMsg_en": "The system has active NDMP connections. When the controller is removed and inserted, these connections will be disconnected and services will be affected.",
        },
    "controller.nas.check.suggestion":
        {
            "errMsg_zh": u"建议拔插控制器时提前在主机侧暂停业务或者切换业务到其他控制器。",
            "errMsg_en": "You are advised to suspend services on the host or switch services to other controllers before removing and inserting a controller.",
        },
    "controller.nas.check.confirm":
        {
            "errMsg_zh": u"若继续拔插控制器，请单击“确定”；若停止拔插控制器，请单击“取消”。",
            "errMsg_en": "To continue removing and inserting controller, click OK. To stop removing and inserting controller, click Cancel.",
        },
    "check.cli.host.red.link.host.red.not.pass":
        {
            "errMsg_zh": u"前端链路不冗余，不能更换。",
            "errMsg_en": "No redundant front-end links exist and the "
                         "replacement cannot be performed.",
            "suggestion_zh": u"请确认以下主机除待更换部件外至少存在一条冗余"
                             u"链路，如果有任何疑问，请联系技术支持工程师进"
                             u"行处理：<br>主机ID：%s",
            "suggestion_en": "Ensure that each of the following hosts has at "
                             "least one redundant link (which cannot be "
                             "connected to a component to be replaced). "
                             "<br>If you have any questions, contact "
                             "technical support engineers. <br> Host ID: %s",
        },
    "execute.error":
        {
            "errMsg_zh": u"获取系统信息失败，请检查网络连接或设备状态是否正常。",
            "errMsg_en": "Fail to get system information."
                         "Check whether the network connection and device status are normal.",
            "suggestion_zh": u"请稍后重试或联系技术支持工程师协助处理。",
            "suggestion_en": "Retry later or contact technical support "
                             "engineers for help.",
        },
    "get.controller.info.fail":
        {
            "errMsg_zh": u"获取控制器信息失败。",
            "errMsg_en": "Fail to get controller information.",
            "suggestion_zh": u"请稍后重试或联系技术支持工程师协助处理。",
            "suggestion_en": "Retry later or contact technical support "
                             "engineers for help.",
        },
    "check.cli.host.red.link.ports.fail":
        {
            "errMsg_zh": u"获取端口信息失败。",
            "errMsg_en": "Fail to get port infomation.",
            "suggestion_zh": u"请稍后重试或联系技术支持工程师协助处理。",
            "suggestion_en": "Retry later or contact technical support engineers for help.",
        },
    "dev.conn.failure":
        {
            "errMsg_zh": u"与设备通信异常，请检查网络连接或设备状态是否正常。",
            "errMsg_en": "The communication with the device is abnormal. Check whether the network connection and device status are normal.",
        },
    "sas.cable.board.error":
        {
            "errMsg_zh": u"硬盘框存在单链路，请确保级联模块%s上的后端线缆连接正确，详细信息可查看告警。",
            "errMsg_en": "A single link exists in the disk enclosure. Ensure that the Back-end cable of expansion module %s is correctly connected. For details, see the alarm information.",
        },
    "sas.cable.port.error":
        {
            "errMsg_zh": u"后端线缆连接错误，请确认端口%s上的后端线缆连接正确，详细信息可查看告警。",
            "errMsg_en": "The Back-end cable is incorrectly connected. Ensure that the Back-end cable is correctly connected to port %s. For details, see the alarm information.",
        },
    "sas.cable.pair.port.error":
        {
            "errMsg_zh": u"端口（位置：%s）线缆连接错误（建议连接端口：%s）。请确保1个环路或者1个域中的硬盘框类型一致，不支持不同类型硬盘框混插。",
            "errMsg_en": "port (location: %s) is incorrectly connected (advised port: %s).The type of disk enclosures in a loop or domain must be the same.",
        },
    "sas.cable.pair.port.incompatible":
        {
            "errMsg_zh": u"线缆规格与端口（位置：%s）不兼容，详细信息可查看告警。",
            "errMsg_en": "Cable specifications are incompatible with the port (location:%s). For details, see the alarm information.",
        },
    "sas.cable.error":
        {
            "errMsg_zh": u"后端线缆连接异常。",
            "errMsg_en": "The Back-end cable is linked error.",
            "suggestion_zh": u"检查后端线缆是否连接正确，详细信息可查看告警。",
            "suggestion_en": "Check whether the Back-end cable is correctly connected according to alarms. For details, see the alarm information.",
        },
    "sas.cable.error.V6":
        {
            "errMsg_zh": u"后端线缆连接异常。",
            "errMsg_en": "The Back-end cable is linked error.",
            "suggestion_zh": u"步骤1：通过告警查看后端链路是否正确，请参考告警（%s）信息进行处理。"
                             u"\n步骤2：如果问题仍无法解决，需要进行下一步操作，请联系技术支持工程师，在确定后端链路冗余的前提下，忽略该检查结果。",
            "suggestion_en": "Step 1: Check whether the back-end link is correct based on the alarm information. "
                             "Rectify the fault by referring to the alarm (%s). "
                             "\nStep 2: If the fault persists, go to the next step. Contact technical support "
                             "engineers. If the back-end links are redundant, ignore the check result.",
        },
    "hyper.metro.pair.health.status.abnormal":
        {
            "errMsg_zh":u"\n双活Pair[%s]健康状态异常(健康状态：%s)",
            "errMsg_en":"\nThe health status of active-active pair [%s] is abnormal (health status: %s).",
        },
    "hyper.metro.pair.link.status.abnormal":
        {
            "errMsg_zh":u"\n双活Pair[%s]链路状态异常(链路状态：%s)",
            "errMsg_en":"\nThe link status of active-active pair [%s] is abnormal (link status: %s).",
        },
    "hyper.metro.pair.running.status.abnormal":
        {
            "errMsg_zh":u"\n双活Pair[%s]运行状态异常(运行状态：%s)",
            "errMsg_en":"\nThe running status of active-active pair [%s] is abnormal (running status: %s).",
        },
    "check.hyper.metro.pair.running.status":
        {
            "errMsg_zh":u"\n请确认双活Pair运行状态正常，然后重试。",
            "errMsg_en":"\nEnsure that running status of active-active pair is normal.",
        },
    "multi.repalce.fan.verify.module.tip":
        {
            "errMsg_zh": u"请选择同一控制器、智能硬盘框级联模块或者辅助散热模块的风扇进行批量更换。",
            "errMsg_en": "Select the fan modules in the same controller, expansion module of a smart disk enclosure, or ACM for batch replacement.",
        },
    "select.memory.msg":
        {
            "errMsg_zh": u"（控制器：%s 槽位：%s）",
            "errMsg_en": "(Controller: %s Slot: %s)",
        },

    "multi.repalce.memory.verify.module.tip":
        {
            "errMsg_zh": u"请选择同一控制器的内存模块进行批量更换。",
            "errMsg_en": "Select the memory modules in the same controller for "
                         "batch replacement.",
        },
    "multi.replace.system.disk.verify.module.tip":
        {
            "errMsg_zh": u"多个控制器的系统盘存在故障请手动进行系统盘的更换。",
            "errMsg_en": "The system disks of multiple controllers are faulty. Manually replace the system disks.",
        },

    "check.multi.pools.abnormal":
        {
            "errMsg_zh": u"待更换硬盘所在的硬盘域状态不正常。",
            "errMsg_en": "The disk domain status of the disk is abnormal.",
            "suggestion_zh": u"请确保以下硬盘域的健康状态为正常，"
                             u"且运行状态为在线，硬盘域ID为：%s",
            "suggestion_en": "Ensure that the health status of the following "
                             "disk domains is normal and "
                             "the running status is online:%s",
        },
    "get.domain.error":
        {
            "errMsg_zh": u"获取硬盘域信息异常。",
            "errMsg_en": "Failed to obtain disk domain information.",
            "suggestion_zh": u"请确保设备和网络状态正常后重试。",
            "suggestion_en": "Retry when the network and controller are "
                             "normal.",
        },

    "hot.spare.not.enough":
        {
            "errMsg_zh": u"硬盘域%s热备空间不足，请首先处理相关告警或事件，"
                         u"然后重试。",
            "errMsg_en": "The hot spare space of disk domain %s is "
                         "insufficient. Handle related alarms or "
                         "events and retry.",
        },
    "pre.copy.time.out":
        {
            "errMsg_zh": u"预拷贝硬盘[%s]超时，不能更换硬盘。",
            "errMsg_en": "Disk[%s] pre-copy timed out. The disk cannot be "
                         "replaced.",
        },
    "pre.copy.fail":
        {
            "errMsg_zh": u"预拷贝失败。",
            "errMsg_en": "Failed to pre-copy.",
            "suggestion_zh": u"%s",
            "suggestion_en": "%s",
        },

    "pre.copy.no.disk":
        {
            "suggestion_zh": u"硬盘[%s]不存在或已被离线，"
                             u"请检查更换的硬盘是否正常接入，"
                             u"或登录DeviceManager查看告警并进行处理。",
            "suggestion_en": "Failed to start the disk[%s] pre-copy."
                             "The disk cannot be replaced.Check whether the "
                             "disk is connected properly, "
                             "or log in to DeviceManager "
                             "to check the related alarm and "
                             "rectify the fault according to "
                             "the recommended actions.",
        },
    "disk.type.not.match":
        {
            "errMsg_zh": u"系统中存在保险箱盘类型不匹配告警。",
            "errMsg_en": "An alarm is reported indicating that non-coffer"
                         " disks exist among the coffer disks.",
            "suggestion_zh": u"请首先处理告警，然后重试。",
            "suggestion_en": "Handle the alarms and retry.",
        },
    "get.disk.info.error":
        {
            "suggestion_zh": u"获取硬盘[%s]信息异常。",
            "suggestion_en": "Failed to get disk[%s] information",
        },
    "pre.copy.start.time.out":
        {
            "errMsg_zh": u"启动硬盘[%s]预拷贝失败，不能更换硬盘。",
            "errMsg_en": "Failed to start the disk[%s] pre-copy. "
                         "The disk cannot be replaced.",
        },
    "disk.health.status.abnormal":
        {
            "errMsg_zh": u"硬盘健康状态异常。",
            "errMsg_en": "The health status of disks is abnormal. ",
        },
    "one.disk.health.status.abnormal":
        {
            "suggestion_zh": u"硬盘[%s]健康状态异常。",
            "suggestion_en": "The disk[%s] health status is abnormal. ",
        },
    "disk.running.status.abnormal":
        {
            "errMsg_zh": u"硬盘运行状态异常。",
            "errMsg_en": "The running status of disks is abnormal. ",
        },
    "one.disk.running.status.abnormal":
        {
            "suggestion_zh": u"硬盘[%s]运行状态异常。",
            "suggestion_en": "The disk[%s] running status is abnormal. ",
        },
    "disk.type.error":
        {
            "errMsg_zh": u"新换盘由于型号与被替换盘不一致，导致未加入到硬盘域。",
            "errMsg_en": "New disk is not added to disk domain because the "
                         "model is different from the current disk.",
            "suggestion_zh": u"请更换该槽位硬盘，"
                             u"确保新硬盘的型号与被替换盘保持一致。",
            "suggestion_en": "Replace the disk in the slot and ensure that "
                             "the model of the new disk"
                             " is the same as that of"
                             " the disk to be replaced.",
        },

    "disk.specification.inconsistence":
        {
            "errMsg_zh": u"硬盘更换前后规格不一致。",
            "errMsg_en": "The specifications of disks are inconsistent "
                         "after the replacement.",
        },
    "disk.type.inconsistence":
        {
            "suggestion_zh": u"\n以下硬盘的类型与更换前不一致，"
                             u"请使用硬盘类型一致的硬盘进行更换:\n%s",
            "suggestion_en": "\nThe disk type before and "
                             "after replacement is "
                             "inconsistent.Ensure that the new disk must "
                             "have the same type as the disk to be "
                             "replaced：\n%s",
        },
    "disk.cap.inconsistence":
        {
            "suggestion_zh": u"\n已更换的硬盘容量小于更换前的硬盘容量。"
                             u"请使用大于或等于更换前容量的硬盘进行更换：\n%s",
            "suggestion_en": "\nThe capacity of the new disk is less than "
                             "that of the original disk. Ensure that the "
                             "capacity of the new disk is no less than the "
                             "capcity before replacement:\n%s",
        },
    "disk.max.num":
        {
            "errMsg_zh": u"选择的硬盘数量超过最大值%s个。",
            "errMsg_en": "The number of selected disks "
                         "exceeds the maximum %s.",
        },
    "disk.same.pool":
        {
            "errMsg_zh": u"不支持同时更换同一硬盘域的硬盘。",
            "errMsg_en": "It is not supported to replace the disks of "
                         "the same disk domain at the same time.",
        },
    "get.bond.fail": {
        "errMsg_zh": u"获取端口绑定信息失败。",
        "errMsg_en": "Failed to get information of bonds.",
        "suggestion_zh": u"请检查系统状态或稍后重试。如果有任何疑问，"
                         u"请联系技术支持工程师协助处理。",
        "suggestion_en": "Please check the system status or try again later. "
                         "If you have any problems, please contact "
                         "technical support engineers for help.",
    },
    "get.version.fail":
        {
            "errMsg_zh": u"获取设备版本信息失败。",
            "errMsg_en": "Fail to get the device version.",
            "suggestion_zh": u"请稍后重试或联系技术支持工程师协助处理。",
            "suggestion_en": "Retry later or contact technical support "
                             "engineers for help.",
        },
    "check.bond.patch.fail": {
        "errMsg_zh": u"当前更换部件存在跨卡绑定，不允许更换。",
        "errMsg_en": "The replacement is not allowed due to "
                     "the cross-card binding on the component.",
        "suggestion_zh": u"请安装%s及以后版本的通用热补丁。",
        "suggestion_en": "Install general hot patch %s or later.",
    },
    "check.bond.no.patch.fail": {
        "errMsg_zh": u"当前更换部件存在跨卡绑定，不允许更换。",
        "errMsg_en": "The replacement is not allowed due to "
                     "the cross-card binding on the component.",
        "suggestion_zh": u"请联系技术支持工程师协助处理。",
        "suggestion_en": "Please contact technical support "
                         "engineers for help.",
    },
    "controller.power.supply.check.suggestion": {
        "errMsg_zh": u"当前控制框上存在电源模块（%s）状态异常，备件更换涉及拔插控制器时存在"
                     u"业务中断风险。若继续拔插控制器，请单击“确定”；若停止拔插控制器，请单"
                     u"击“取消”。",
        "errMsg_en": "Power supply modules (%s) on the current controller "
                     "enclosure are abnormal. When a controller is removed and"
                     " inserted during spare part replacement,may interrupt "
                     "services. To continue, click OK. To stop, click Cancel.",
    },
    "failover_event_ip_error.suggestion.V5R7C60SPC100": {
        "errMsg_zh": u"当前系统软件版本为"
                     u"V500R007C60SPC100，请安装V500R007C60SPH101或更高版本补"
                     u"丁，然后再进行备件更换。",
        "errMsg_en": "Current "
                     "system software version is V500R007C60SPC100 and hot "
                     "patch V500R007C60SPH101 or later is installed, "
                     "the check result is Passed. Otherwise, "
                     "continue the check."
    },
    "failover_event_ip_error.suggestion.V5R7C60SPC300": {
        "errMsg_zh": u"当前系统软件版本为"
                     u"V500R007C60SPC300，请安装V500R007C60SPH302或更高版本补"
                     u"丁，然后再进行备件更换。",
        "errMsg_en": "Current "
                     "system software version is V500R007C60SPC300 and hot "
                     "patch V500R007C60SPH302 or later is installed, "
                     "the check result is Passed. Otherwise, "
                     "continue the check."
    },
    "failover_event_ip_error.suggestion.other": {
        "errMsg_zh": u"请联系技术工程师。",
        "errMsg_en": "Contact technical support engineers."
    },
    "failover_event_ip_error.suggestion": {
        "errMsg_zh": u"存在NFS文件锁，不满足更换条件。\n",
        "errMsg_en": "NFS lock exists and parts cannot be replaced."
    },
    "cli.domain.config.check.not.pass.no.smart": {
        "errMsg_zh": u"\n硬盘域[ID:%s]成员盘数为%s，大于%s(25+热备盘数)且小"
                     u"于等于%s（（25+热备盘数）*2）。",
        "errMsg_en": "\nThe number of member disks in disk domain [ID: %s] "
                     "is %s, which is more than %s  (25 + Number of hot "
                     "spare disks) and less than or equal to %s "
                     "((25 + Number of hot spare disks) x 2)"
    },
    "cli.domain.config.check.not.pass": {
        "errMsg_zh": u"\n硬盘域[ID:%s]成员盘数为%s，小于等于%s((25+热备盘数)*2)。",
        "errMsg_en": "\nThe number of member disks in disk domain [ID: %s] "
                     "is %s, which is less than or equal to %s "
                     "((25 + Number of hot spare disks) x 2).",
    },

    "software.cross.intf.bond.physic.not.pass": {
        "errMsg_zh": u"\n存在跨卡绑定使用IPV6的场景，绑定端口名称[%s]。",
        "errMsg_en": "\nA cross-interface module bond port uses an IPv6 address."
                     "The bond port name is [%s].",
    },
    "software.cross.intf.bond.logic.not.pass": {
        "errMsg_zh": u"\n存在跨卡绑定使用IPV6的场景，逻辑端口名称[%s]。",
        "errMsg_en": "\nA cross-interface module bond port uses an IPv6 address."
                     "The logical port name is [%s].",
    },
    "software.cross.intf.bond.default.fg.not.pass": {
        "errMsg_zh": u"\n逻辑端口[%s]关联的默认漂移组存在跨卡绑定的端口。",
        "errMsg_en": "\nThe default failover group associated with logical port "
                     "[%s] contains cross-interface module bond port.",
    },
    "software.cross.intf.bond.fg.not.pass": {
        "errMsg_zh": u"\n逻辑端口[%s]关联的漂移组存在跨卡绑定的端口[绑定名称：%s]。",
        "errMsg_en": "\nThe failover group associated with logical port [%s] "
                     "contains cross-interface module bond port [name: %s]."
    },
    "software.cross.intf.bond.install.patch.sug": {
        "errMsg_zh": u"\n当前版本是%s, 请安装%s或更高版本的补丁。",
        "errMsg_en": "\nThe current version is %s. Install the patch %s "
                     "or a later version."
    },
    "software.cross.intf.bond.contact.engineer": {
        "errMsg_zh": u"\n请联系技术工程师处理。",
        "errMsg_en": "\nContact technical support engineers."
    },
    "nic.bond.mode.sph6.error_message": {
        "errMsg_zh": u"\n当前系统存在绑定端口。",
        "errMsg_en": "\nOne or more bond ports exist in the current system.",
        "suggestion_zh": u"\n当前版本是%s, 请安装6.0.1.SPH6或更高版本"
                         u"的补丁。",
        "suggestion_en": "\nThe current version is %s. Install the patch "
                         "6.0.1.SPH6 or a later version."

    },
    "palm.ctrl.limit": {
        "errMsg_zh": u"\n当前工具不支持更换。",
        "errMsg_en": "\nThe current tool does not support the "
                     "controller replacement.",
        "suggestion_zh": u"\n请联系技术支持工程师。",
        "suggestion_en": "\nContact technical support engineers. "

    },
    "palm.ctrl.limit.process.abnormal": {
        "errMsg_zh": u"\n内部错误。",
        "errMsg_en": "\nInternal error.",
        "suggestion_zh": u"\n请联系技术支持工程师。",
        "suggestion_en": "\nContact technical support engineers. "
    },
    "palm.ctrl.limit.patch": {
        "errMsg_zh": u"\n当前版本不满足更换要求。",
        "errMsg_en": "\nThe current version does not meet "
                     "the replacement requirements.",
        "suggestion_zh": u"\n当前版本为%s，请安装%s及以后的补丁。",
        "suggestion_en": "\nThe current version is %s. "
                         "Please install %s or a later patch."
    },
    "node.status.error": {
        "errMsg_zh": u"\n业务回切失败。",
        "errMsg_en": "\nFailed to switch back services.",
        "suggestion_zh": u"\n请联系技术支持工程师。",
        "suggestion_en": "\nContact technical support engineers."
    },
    "NFS.exists.and.disabled": {
        "errMsg_zh": u"\n当前系统存在NFS4.1业务且NFS4.1服务已关闭。",
        "errMsg_en": "\nThe NFS4.1 service exists in the system and has"
                     " been disabled.",
        "suggestion_zh": u"\n请选择以下两种方式之一进行修复，若有疑问请联系技术支持工程师："
                         u"\n1、执行命令：change service nfs support_v41_enabled="
                         u"on，开启默认租户（租户0）下NFS4.1服务开关；"
                         u"\n2、若设备版本为以下版本，请安装对应补丁版本："
                         u"\n1）设备版本为V500R007C30SPC100，则安装"
                         u"V500R007C30SPH125补丁或之后补丁；"
                         u"\n2）设备版本为V300R006C50SPC100，则安装"
                         u"V300R006C50SPH125补丁或之后补丁；"
                         u"\n 3）设备版本为V500R007C61，则安装"
                         u"V500R007C61SPH016补丁或之后补丁；"
                         u"\n4）设备版本为V300R006C61，则安装"
                         u"V300R006C61SPH016补丁或之后补丁；",
        "suggestion_en": "\nContact technical support engineers."
    },
}
