# -*- coding: UTF-8 -*-

DORADO_V3_PRODUCT_TYPE = ['Dorado5000 V3', 'Dorado6000 V3', 'Dorado18000 V3']

NO_CHECK_RECONSTRUCTE_VER = 'V300R006C10'

NO_CHECK_RECONSTRUCTE_DORADO_VER = 'V300R001C01SPC100'


class UpgradeCheck():
    """
    进行硬盘升级检查处理
    """

    def __init__(self):
        pass

    @staticmethod
    def needCheckReconstruct(dataDict):
        """判断是否需要检查

        :param dataDict: 上下文字典
        :return:
        """
        dev = dataDict.get("dev")
        devVersion = str(dev.getPreUpgradeVersion())
        devType = str(dev.getDevNode().getDeviceType())

        if devType in DORADO_V3_PRODUCT_TYPE:
            if devVersion >= NO_CHECK_RECONSTRUCTE_DORADO_VER:
                return False
        else:
            if devVersion >= NO_CHECK_RECONSTRUCTE_VER:
                return False
        return True
