# -*- coding: UTF-8 -*-
import traceback

from cbb.frame.base.regex import Regex
from cbb.frame.util.GZipHandler import GZipHandler


class HddFw:

    def __init__(self, diskfwTgz, logger):
        self.diskfwTgz = diskfwTgz
        self.logger = logger
        self.hddfwInfo = {}
        self.hddfile = "hddfw.conf"

    def parseHddFw(self):
        """解析红黑榜

        :return:
        """
        hddstream = None
        try:
            gzip = GZipHandler(self.diskfwTgz)
            hddstream = gzip.openMemberFile(self.hddfile)
            while True:
                line = hddstream.readFileline()
                if not line:
                    break

                if not Regex.search("^[A-Za-z0-9]", line):
                    continue

                infoList = line.split(":")
                if len(infoList) > 2:
                    self.hddfwInfo[infoList[0]] = infoList[1]

            return self.hddfwInfo
        except:
            self.logger.error("parse hddfw.conf error:%s" % (traceback.format_exc()))
            self.hddfwInfo = {}
            return self.hddfwInfo
        finally:
            # noinspection PyBroadException
            try:
                hddstream.closeFile()
            except Exception as e:
                self.logger.error("Close file exception:%s" % (traceback.format_exc()))
