# -*- coding: UTF-8 -*-
import os
from defusedxml import ElementTree as ET


def parseSupportXmlFile(logger):
    """获取xml文件解析后的字典

    :param logger: 日志打印对象
    :return: xml解析的字典
    """
    xmlInfo = {}
    try:
        supportXmlFile = getSuppImpXmlFile()

        xmlInfo = parseXMLFile(supportXmlFile)
        return xmlInfo

    except Exception as ex:
        logger.logException(ex)
        raise Exception("ERROR00001", ex)


def parseXMLFile(filePath):
    """解析xml文件

    :param filePath: xml文件路径
    :return: 解析后的xml文件信息（一个嵌套的字典)
    """
    xmlElementTree = ET.parse(filePath)
    rootElement = xmlElementTree.getroot()
    # 通过解析xml文件的根节点来解析整个文件
    xmlInfo = parseXMLElement(rootElement)
    return xmlInfo


def parseXMLElement(element):
    """递归调用解析xml节点

    :param element: xml的一个节点
    :return: 解析后的xml节点信息（一个嵌套的字典)
    """
    elementName = element.tag
    elementAttrbutes = element.attrib
    if not element.text:
        element.text = ""
    elementText = element.text.strip()

    # 对节点的子节点
    elementChildEles = []
    childElements = element.getchildren()
    for childElement in childElements:
        elementChildEles.append(parseXMLElement(childElement))

    # 将xml节点的名称，属，文本，子节点存放到字典
    elementInfo = {
        "elementName": elementName,
        "elementAttrbutes": elementAttrbutes,
        "elementText": str(elementText),
        "elementChildEles": elementChildEles
    }

    return elementInfo


def getSupportDevMap(xmlInfo):
    """获取特定版本号对应的设备型号

    :param xmlInfo: xml规则文件解析的字典集
    :return:
    """
    devDictMap = {}

    productXmlList = getChildNodeXml(xmlInfo, "supportImportStep")
    # 查找特定版本的设备型号列表
    for node in productXmlList:
        devXmlAttrVer = node["elementAttrbutes"]["version"]
        devXmlAttrStr = node["elementAttrbutes"]["device"]
        devList = devXmlAttrStr.split(',')
        devDictMap[devXmlAttrVer] = devList

    return devDictMap


def getChildNodeXml(xmlInfo, nodeType):
    """取xmlInfo字典中，节点类型为nodeType中的所有子节点

    :param xmlInfo: xml规则文件解析的字典集
    :param nodeType: 节点类型
    :return:
    """
    reList = []
    childXmlInfo = xmlInfo["elementChildEles"]
    for node in childXmlInfo:
        if nodeType == node["elementName"]:
            reList = node["elementChildEles"]
            break
    return reList


def getSuppImpXmlFile():
    """获取supportImportVersions.xml文件

    :return:
    """
    curDir = os.path.dirname(__file__)
    fileName = "supportImportVersions.xml"
    pat = "products"
    filePath = os.path.join(curDir[0:curDir.find(pat)], pat, fileName)
    return filePath
