# coding:utf-8
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion.common import CLUST_TYPE_SWITCH
from operator import methodcaller
import os


class ExpansionDocLink(object):
    def __init__(self, context):
        self.context = context
        self.lang = contextUtil.getLang(context)
        self.root_path = contextUtil.getImportRootDir(context)
        self.network_type = contextUtil.getItem(context, "newConfigClustType")
        self.ctrl_height = contextUtil.getItem(context, "ctrlHeight")
        self.after_ctrl_num = contextUtil.getItem(context, "newConfigCtrlNum")
        self.product_type = contextUtil.getItem(context, "productModel")
        self.inner_type = contextUtil.getItem(context, "internalModel")
        self.has_inner_metro = contextUtil.getItem(context, "hasInnerMetroLicense")

    def get_doc_link(self, doc_tag, doc_method):
        return methodcaller(doc_method, doc_tag)(self)

    def get_network_image(self, doc_tag):
        """
        获取组网图地址，示例：
        :param doc_tag:
        :return: \\packages\\DoradoV600R003C00\\res\\html\\
        networking\\network_type\\doc_tag\\xUxC\\networkOrg_lang.html
        """
        base_path = os.path.join(self.root_path, "res", "html", "networking",
                                 self.network_type, doc_tag)
        expansion_scene = "%sU%sC" % (self.ctrl_height, self.after_ctrl_num)
        html_file_name = "networkOrg_%s.html" % self.lang
        if self.has_inner_metro and self.network_type == CLUST_TYPE_SWITCH:
            html_file_name = "networkOrg_inner_metro_%s.html" % self.lang
        return os.path.join(base_path, expansion_scene, html_file_name)

    def get_help_doc(self, doc_tag):
        """
        获取帮助文件地址
        :param: doc_tag
        :return: 文件地址
        """
        return os.path.join(self.root_path, "res", "help",
                            "%s_%s.chm" % (doc_tag, self.lang))
