# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
融合存储V5R7C60 Kunpeng高端整柜配置文件
"""

# H3/H10任一槽位接后端卡时可扩的智能硬盘框数量，key=级联深度
ENCLOSURES_ON_H3_H10_NUM = {
    "2": 4,
    "4": 8,
}

# V5整柜每柜最大2U硬盘框规格，区分后端组网方式
MAX_DISK_ENC_PER_BAY = {
    "SAS": 16,
    "SMART": 8
}

# V5整柜每个系统柜支持的最大硬盘柜规格
MAX_DISK_BAY_PER_SYS = {
    # SAS后端组网，key=级联深度
    "SAS": {
        "2": 3,
        "4": 5,
    },
    # IP后端组网，key=级联深度
    "SMART": {
        "2": 5,
        "4": 11,
    }
}

# V5整柜单个引擎最大支持的2U硬盘框规格
MAX_DISK_ENCS_PER_ENG = {
    # SAS后端组网，key=级联深度
    "SAS": {
        "2": 48,
        "4": 96
    },
    # IP后端组网，key=级联深度
    "SMART": {
        "2": 40,
        "4": 80,
    }
}

# SAS组网4U硬盘框的起始位置列表
START_LOC_SAS_4U_LIST = [i for i in range(1, 20, 4)] + \
                        [i for i in range(31, 42, 4)]

# SAS组网2U硬盘框的起始位置列表
START_LOC_SAS_2U_LIST = [i for i in range(1, 20, 2)] + \
                        [i for i in range(31, 42, 2)]

# F系列SAS组网特殊柜的框起始位置列表
START_LOC_SAS_2U_SPE_BAY = {
    # 1号、2号硬盘柜只能扩半柜
    "special_dkb": ["DKB%s_1" % str(i) for i in range(0, 4)] + [
        "DKB%s_2" % str(i) for i in range(0, 4)],
    "loc_list": [i for i in range(1, 16, 2)]
}

# IP组网硬盘框的起始位置列表
START_LOC_IP_2U_LIST = [i for i in range(3, 20, 4)] + \
                       [i for i in range(31, 42, 4)]

# NVMe混插硬盘框的NVMe区域
AREA_NVME_2U_LIST = [i for i in range(17, 42, 2)]

# NVMe混插硬盘框的起始位置列表
START_LOC_NVME_2U_LIST = [19, 31, 35, 39]

# IP组网特殊柜的硬盘框起始位置列表
START_LOC_IP_2U_SPE_BAY = {
    # F系列
    "f_series": {
        # 特殊硬盘柜：DKB0_3,DKB0_4,DKB1_3,DKB1_4...
        "special_dkb": ["DKB%s_3" % str(i) for i in range(0, 4)] + [
            "DKB%s_4" % str(i) for i in range(0, 4)],
        # key: H3/H10槽位可用数量（0,1,2）, value: 柜上放置硬盘框的起始位置列表
        0: [i for i in range(3, 16, 4)],
        1: [i for i in range(3, 20, 4)] + [31, ],
        2: START_LOC_IP_2U_LIST
    },
    # 非F系列
    "non_f_series": {
        # 特殊硬盘柜： DKB0_4,DKB0_9
        "special_dkb": ["DKB0_4", "DKB0_10"],
        # key: H3/H10槽位可用数量（1,2）, value: 柜上放置硬盘框的起始位置列表
        1: [i for i in range(3, 16, 4)],
        2: START_LOC_IP_2U_LIST
    }
}

# 2U、4U对应的硬盘类型，仅用于绘图
ENC_TYPE = {
    "2": "EXPSAS2U_25",
    "3": "EXPSAS2U_25",
    "4": "EXPSAS4U_24_NEW",
}
